package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;
import javax.swing.tree.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.ui.lists.*;
public class UITreeTable extends UITable implements IEnableListener, MouseListener, TreeExpansionListener {
	protected UiTreeModelWrapper fTreeModelWrapper;
	protected int[] fNodesPendingSelection = new int[0];
	protected boolean fRootVisible = true;
/**
 * Add the given component (a column) to the receiver.
 *
 * @param c		UIComponent		The component to be added.
 */
public void add(UIComponent c) {
	UIColumn column = (UIColumn) c;
	if (column != null) {
		super.add(column);
		column.initializeFor(getTreeTable());
	}
}
private void collapse(int nodeId) {
	getTree().collapsePath(getPathFor(nodeId));
}
//Convert the tree constant into one for the table.

protected int convertModeForTable(int mode) {
	if (mode == TREE_SINGLE_SELECTION)
		return LIST_SINGLE_SELECTION;
	if (mode == TREE_CONTIGUOUS_SELECTION)
		return LIST_SINGLE_INTERVAL_SELECTION;
	if (mode == TREE_DISCONTIGUOUS_SELECTION)
		return LIST_MULTIPLE_INTERVAL_SELECTION;
	return -1;
}
protected UiTableModelWrapper createTableModelWrapper() {
	return new UiTreeTableModelWrapper((UIHierarchicalItemList) fItemList);
}
protected IJList createWidget() {
	return (IJList) new UiJTreeTable(getTreeTableModel(), this);
}
private void ensureIndexIsVisible(int row) {
	if (row < 0)
		return;
	Rectangle r = getTreeTable().getCellRect(row, 0, false); // left most cell in row
	getTreeTable().scrollRectToVisible(r);
}
protected void ensureNodeIsVisible(int nodeId) {
	TreePath path= getPathFor(nodeId);
	getTree().makeVisible(path);
	ensureIndexIsVisible(getTree().getRowForPath(path));
}
protected void ensurePathIsVisible(TreePath path) {
	ensureIndexIsVisible(getTree().getRowForPath(path));
}
private void expand(int nodeId) {
	getTree().expandPath(getPathFor(nodeId));
}
private int[] getIndicesFor(TreePath[] paths) {
	if (paths == null)
		return null;
	int size = paths.length;
	int[] indices = new int[size];
	for (int i = 0; i < size; i++) {
		indices[i] = getTree().getRowForPath(paths[i]);
	}
	return indices;
}
protected int getLastNodeIdFrom(TreePath path) {
	return ((ITreeNode) path.getLastPathComponent()).getId();
}
protected TreePath getPathFor(int nodeId) {
	ITreeNode node = fTreeModelWrapper.locateNodeWithId(nodeId);
	if (node == null) return null;
	return new TreePath(node.getPath());
}
protected TreePath[] getPathsFor(int[] nodeIds) {
	if (nodeIds == null)
		return null;
	int size = nodeIds.length;
	TreePath[] paths = new TreePath[size];
	for (int i = 0; i < size; i++) {
		paths[i] = getPathFor(nodeIds[i]);
	}
	return paths;
}
protected TreePath[] getPathsFor(Vector nodeIds) {
	if ((nodeIds == null) || (nodeIds.isEmpty()))
		return null;
	int size = nodeIds.size();
	TreePath[] paths = new TreePath[size];
	for (int i = 0; i < size; i++) {
		paths[i] = getPathFor(((Integer) nodeIds.elementAt(i)).intValue());
	}
	return paths;
}
/**
 * Answer the tree paths for the given indices.
 */
public TreePath[] getPathsForRows(int[] selectedRowIndices) {
	if (selectedRowIndices == null) return null;
	int size= selectedRowIndices.length;
	TreePath[] selectedPaths= new TreePath[size];
	for (int i= 0; i < size; i++) {
		selectedPaths[i]= getTree().getPathForRow(selectedRowIndices[i]);
	}
	return selectedPaths;
}
/**
 * Answer the currently selected rowId's.
 */
public int[] getSelectedRowIds() {
	int[] sel = fWidget.getSelectedIndices();
	if (sel != null) {
		int[] selectedOids = new int[sel.length];
		for (int i = 0; i < sel.length; i++) {
			selectedOids[i] = fTreeModelWrapper.getTableModelWrapper().indexToOid(sel[i]);
		}
		return selectedOids;
	} else {
		return new int[0];
	}
}
/**
 * Answer the current selection model for the receiver.
 * Possible return values are :
 *		SINGLE_SELECTION = 0;
 *		SINGLE_INTERVAL_SELECTION = 1;
 *		MULTIPLE_INTERVAL_SELECTION = 2;
 */
public int getSelectionMode() {
	ListSelectionModel sm= getTreeTable().getSelectionModel();
	if (sm != null) return sm.getSelectionMode();
	else return -1;
}
/**
 * The tree is the renderer of the treeTable
 */
public JTree getTree() {
	return getTreeTable().getTreeRenderer();
}
/**
 * Answer the receiver's current itemList.
 *
 * The receiver's <code>UIItemList</code> is responsible for the order in which
 * the receiver's rows are displayed.
 *
 * @see UIItemList
 *
 */
public UIHierarchicalItemList getTreeItemList() {
	return (UIHierarchicalItemList) fItemList;
}
/**
 * Answer the treeTable widget for the receiver
 */
private UiJTreeTable getTreeTable() {
	return (UiJTreeTable) getWidget();
}
protected UiTreeTableModelWrapper getTreeTableModel() {
	return (UiTreeTableModelWrapper) fTableModel;
}
public void handleEnsureIndexIsVisible(Anything args) {
	ensureNodeIsVisible(args.asInt(0));
}
protected void handleIsNodeExpanded(int nodeId) {
	boolean isExpanded = getTree().isExpanded(getPathFor(nodeId));
	sendULC("isExpanded", new Anything(isExpanded));
}
protected UIItemList handleMissingItemList(ORBConnection conn, UITableModel tableModel) {
	UITableModel model = tableModel;
	if (model == null) {
		trouble("uitreeTable.restoreState", "a list must have either an itemList or listModel assigned");
		// create a default table model instance to allow the view to come up
		model = new UITableModel();
		model.fData = new UiItemCache(model);
	}
	UIHierarchicalItemList itemList = new UIHierarchicalItemList();
	itemList.setCache(model.getItemCache());
	itemList.clearRoot();
	return itemList;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("ensureNodeIsVisible")) {
		ensureNodeIsVisible(args.asInt(0));
		return;
	}
	if (request.equals("setSelectionMode")) {
		setSelectionMode(args.asInt(-1));
		return;
	}
	if (request.equals("setSelectedNodes")) {
		handleSetSelectedNodes(args);
		return;
	}
	if (request.equals("setRootVisible")) {
		fRootVisible = args.asBoolean(true);
		if (!getTreeItemList().hasNoRoot())
			setRootVisible(fRootVisible);
		return;
	}
	if (request.equals("expand")) {
		expand(args.asInt(-1));
		return;
	}
	if (request.equals("collapse")) {
		collapse(args.asInt(-1));
		return;
	}
	if (request.equals("isExpanded")) {
		handleIsNodeExpanded(args.asInt(-1));
		return;
	}
	super.handleRequest(conn, request, args);
}
protected void handleSetItemList(ORBConnection conn, Anything args, boolean notify) {
	super.handleSetItemList(conn, args, false);
	//COPY_PASTE FROM SETCOMPONENT. CLEANUP !
	fTableModel.setItemList(getTreeItemList());
	fTreeModelWrapper.setItemList(getTreeItemList());
	fTreeModelWrapper.setRoot(getTreeItemList().getRoot());
	notify(TABLE_MODEL_CONTENTS_CHANGED, null, -1, -1);
}
private void handleSetSelectedNodes(Anything args) {
	if (args == null)
		return;
	Vector nodeIds = args.toCollection();
	setSelectedItems(nodeIds);
}
protected boolean isValidPath(TreePath path) {
	if (path == null)
		return false; // invalid notification / de-selection
	ITreeNode node = (ITreeNode) path.getLastPathComponent();
	return node.isValidNode();
}
// IItemListListener interface
public void notify(int type, String[] attributeNames, int start, int end) {
	if (type == TABLE_MODEL_ROWS_REMOVED) {
		if (getTreeItemList().hasNoRoot()) { //handles the root deletion case only
			updateRootVisibility();
			return;
		}
	}
	super.notify(type, attributeNames, start, end);
}
protected void notifySelectionPathsChange(TreePath[] newPaths) {
	Anything a= new Anything();
	prepareNodesFrom(a, newPaths);
	sendULC("setSelectedNodes", a);
}
/**
 * Notify the ULC side that the tree has been collapsed.
 */
protected void notifyTreeCollapsedAt(Object collapsedNodeObj) {
	ITreeNode collapsedNode= (ITreeNode) collapsedNodeObj;
	Anything a= new Anything();
	a.put("id", collapsedNode.getId());
	sendOptionalEventULC("nodeCollapsed", a);
}
/**
 * Notify the ULC side that the tree has been expanded. 
 * No args are sent as of now.
 */
protected void notifyTreeExpandedAt(Object expandedNodeObj) {
	ITreeNode expandedNode= (ITreeNode) expandedNodeObj;
	Anything a= new Anything();
	a.put("id", expandedNode.getId());
	sendOptionalEventULC("nodeExpanded", a);
}
protected int oidToIndex(int oid) {
	return fTreeModelWrapper.getTableModelWrapper().oidToIndex(oid);
}
protected void prepareNodesFrom(Anything a, TreePath[] newPaths) {
	if (newPaths != null) { // null in case of complete de-selection, say
		for (int i= 0; i < newPaths.length; i++) {
			TreePath path= newPaths[i];
			if (isValidPath(path)) {
				int nodeId= getLastNodeIdFrom(path);
				a.append(new Anything(nodeId));
			}
		}
	}
}
private TreePath[] prepareSelectedNodesFrom(Anything args) {
	return getPathsFor(args.toCollection());
}
void refreshSelectedItems(IRow[] rows) {
	Vector oids = new Vector(rows.length);
	for (int i = 0; i < rows.length; i++) {
		oids.addElement(new Integer(rows[i].getOid()));
	}
	if (getTree() != null)
		setSelectedNodes(getPathsFor(oids));
}
/**
 * remove the given component as listener from being informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
public void removeEnableListener(IEnableListenerTarget component) {
	Assert.isNotNull(component);
	if (fEmptyStateListeners == null)
		return;
	fEmptyStateListeners.removeElement(component);
}
protected void removeFromSelection(int from, int to) {
	//do nothing.
}
protected UIItemList restoreItemList(ORBConnection conn, Anything args) {
	return (UIHierarchicalItemList) getManaged(UIHierarchicalItemList.class, conn, args);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fRootVisible = args.get("rootVisible", true); //set the visibility flag now because it is used in the setItemList method.
	super.restoreState(conn, args);
}
protected void revalidateAsync() {
	DeferredRequest r = new DeferredRequest(fConnection) {
		public void safeDispatch() {
			getTreeTable().invalidate();
			getTreeTable().revalidate();
		}
	};
	fConnection.postRequest(r);
}
/**
 * Perform the necessary actions on the given selection change
 * event.
 */
public void selectionChanged(String event) {
	super.selectionChanged(event);
	if (getTree() != null) {
		if (getTable().getSelectedRows().length > 0)
			getTree().setSelectionRows(getTable().getSelectedRows());
		else
			getTree().clearSelection();
	}
	//removeEditorAsync();
	revalidateAsync();
	updateAsync();
}
protected void setComponent(ORBConnection conn, Anything args) {
	super.setComponent(conn, args);
	fTreeModelWrapper = new UiTreeModelWrapper(getTreeItemList());
	fTreeModelWrapper.setTableModelWrapper(fTableModel);
	getTreeTable().setTreeRendererFrom(fTreeModelWrapper, this);
	if (getItemList().getItemCache() == null)
		setRootVisible(false); //For the dummy itemList / model case : Don't show anything !
	DeferredRequest r = new DeferredRequest(conn) {
		public void safeDispatch() {
			setRowHeight(getTable().getRowHeight());
		}
	};
	conn.postRequest(r);
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	super.setEnabled(state);
	getTree().setEnabled(state);
}
protected void setInitialSelection(Anything args) {
	if (args.isDefined("selectedNodes"))
		handleSetSelectedNodes(args.get("selectedNodes"));
}
/**
 * Two cases to be handled :
 * (i) An existing itemList is to be replaced by a new one. Then, set the rootVisibility
 *     to that of the new one (if it is different from that of the old itemList).
 * (ii) restoreState, when there is no existing itemList. Then, set the rootVisibility to
 *      that specified by the receiver (fRootVisible).
 */
protected void setItemList(UIItemList itemList) {
	if (getTreeItemList() != null) {
		boolean hadNoRoot = getTreeItemList().hasNoRoot();
		super.setItemList(itemList);
		if (getTreeItemList().hasNoRoot() != hadNoRoot) {
			updateRootVisibility();
		}
	} else {
		super.setItemList(itemList);
		setRootVisible(fRootVisible);
	}
}
protected void setRootVisibilityAsync(boolean bool) {
	final boolean b = bool;
	fConnection.postRequest(new DeferredRequest(fConnection) {
		public void safeDispatch() {
			setRootVisibleNoNotify(b);
		}
	});
}
/**
 * The application wants to change the root visibility of the receiver to @rootVisible.
 * Depending on the itemList's state, the visibility is propagated to the UI or not.
 */
protected void setRootVisible(boolean rootVisible) {
	if (getTreeTable() == null || getTree() == null) { // while restoring state treeTable is still null
		setRootVisibilityAsync(rootVisible);
	} 
	else {
		getTree().setRootVisible(rootVisible);
		//clearSelection(); //else do this consistently within the notifies below.
		if (rootVisible)
			super.notify(TABLE_MODEL_ROWS_ADDED, new String[0], 0, 0);
		else
			super.notify(TABLE_MODEL_ROWS_REMOVED, new String[0], 0, 0);
		refreshCurrentSelection(); //To handle selection when root visibility is changed
		updateAsync();
	}
}
/**
 * The application wants to change the root visibility of the receiver to @rootVisible.
 */
protected void setRootVisibleNoNotify(boolean rootVisible) {
	getTree().setRootVisible(rootVisible); //getTree() should *Not* be null at this stage
	updateAsync();
}
/**
 * Set the rowHeight for the receiver.
 * @param 	rh	int 	The new height in pixels.
 */
public void setRowHeight(int rh) {
	super.setRowHeight(rh);
	getTree().setRowHeight(rh);
	return;
}
public void setSelectedItems(Vector nodeIds) {
	Vector missingOids = new Vector();
	TreePath[] paths = new TreePath[nodeIds.size()];
	int[] oids = new int[nodeIds.size()];
	for (int i = 0; i < nodeIds.size(); i++) {
		int nextId = ((Integer) nodeIds.elementAt(i)).intValue();
		ITreeNode node = fTreeModelWrapper.locateNodeWithId(nextId);
		if (node == null) {
			missingOids.addElement(new Integer(nextId));
		} else {
			paths[i] = getPathFor(nextId);
		}
	}
	if (missingOids.size() > 0) {
		int[] nodesToRequest = new int[missingOids.size()];
		for (int i = 0; i < missingOids.size(); i++) {
			nodesToRequest[i] = ((Integer) missingOids.elementAt(i)).intValue();
		}
		getTreeItemList().requestNodeIds(nodesToRequest);
		fNodesPendingSelection = nodesToRequest;
	} else {
		getTree().setSelectionPaths(paths);
		int[] indices = getIndicesFor(paths);
		int[][] intervals = new UlcSorter().sortToIntervals(indices);
		getWidget().setSelectionInvervals(intervals, indices);
		selectionChanged("");
	}
}
private void setSelectedNodes(TreePath[] paths) {
	if (paths == null)
		clearSelection();
	else {
		getTree().setSelectionPaths(paths);
		int[] indices = getIndicesFor(paths);
		int[][] intervals = new UlcSorter().sortToIntervals(indices);
		getWidget().setSelectionInvervals(intervals, indices);
		selectionChanged("");
		fNodesPendingSelection = new int[0];
	}
}
/**
 * Set the current selection model for the receiver.
 * Possible return values are :
 *		SINGLE_TREE_SELECTION = 1;
 *		CONTIGUOUS_TREE_SELECTION = 2;
 *		DISCONTIGUOUS_TREE_SELECTION = 4.
 *
 * Note that these constants are not the same for the tree and
 * the table, hence we do a 'mapping' of the above values to
 * those required by the receiver.
 *
 * @see convertModeForTable(model).
 *
 */

public void setSelectionMode(int mode) {
	if (getTree() != null) {
		TreeSelectionModel sm = getTree().getSelectionModel();
		if (sm != null) {
			if (mode != -1)
				sm.setSelectionMode(mode);
			else
				sm.setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
		}
	}
	super.setSelectionMode(convertModeForTable(mode));
}
/**
 * The tree has been collapsed, at the location specified in
 * the given event. Notify the listeners accordingly.
 *
 * param e 	TreeExpansionEvent	The collapse event from the JTree widget
 */
public void treeCollapsed(TreeExpansionEvent e) {
	notifyTreeCollapsedAt(e.getPath().getLastPathComponent());
}
/**
 * The tree has been expanded, at the location specified in
 * the given event. Notify the listeners accordingly.
 *
 * param e 	TreeExpansionEvent	The expansion event from the JTree widget
 */
public void treeExpanded(TreeExpansionEvent e) {
	notifyTreeExpandedAt(e.getPath().getLastPathComponent());
}
protected void updateAsync() {
	DeferredRequest r = new DeferredRequest(fConnection) {
		public void safeDispatch() {
			getTreeTable().revalidate();
			getTreeTable().repaint();
		}
	};
	fConnection.postRequest(r);
}
public void updatePendingSelection(boolean tryRefreshCurrentSelection) {
	if (fNodesPendingSelection != null && fNodesPendingSelection.length > 0) {
		TreePath[] paths = getPathsFor(fNodesPendingSelection);
		if (paths != null) {
			for (int i= 0; i < paths.length; i++)
				if (paths[i] == null)
					return;
			setSelectedNodes(paths);
		}
	}
	else if (tryRefreshCurrentSelection)
		refreshCurrentSelection();
}
protected void updateRoot() {
	updateAsync();
}
protected void updateRootVisibility() {
	if (fRootVisible) {
		if (getTreeItemList().hasNoRoot())
			setRootVisible(false);
		else
			setRootVisible(true);
	}
}
}
