package com.ibm.ulc.ui;

import com.ibm.ulc.util.*;
import com.ibm.ulc.base.*;
/**
 * Parse the labelString and return an object with the final labelString and the
 * mnemonic character initialized if present or null otherwise.
 *
 * @param labelString java.lang.String
 */
public class UiLabelAndMnemonic extends UlcObject implements IDefaults {
	public String fLabel = null;
	public Character fMnemonic = null;
/**
 * Parse the labelString and return an object with the final labelString and the
 * mnemonic character initialized if present or null otherwise.
 *
 * @param labelString java.lang.String
 */
public UiLabelAndMnemonic(String labelString) {
	parseLabelForMnemonic(labelString);
}
/**
 * Parse the labelString and return an object with the final labelString and the
 * mnemonic character initialized if present or null otherwise.
 *
 * @param labelString java.lang.String
 */
private void parseLabelForMnemonic(String labelString) {
	int mnemonicPos = labelString.indexOf(MNEMONIC_INDICATOR);
	if (mnemonicPos < 0) {
		fLabel = labelString;
		return;
	}
	if (mnemonicPos == 0) {
		fLabel = labelString.substring(1, labelString.length());
		fMnemonic = new Character(fLabel.charAt(0));
		return;
	}
	fLabel = labelString.substring(0, mnemonicPos) + labelString.substring(mnemonicPos + 1, labelString.length());
	fMnemonic = new Character(fLabel.charAt(mnemonicPos));
}
}
