package com.ibm.ulc.ui;

import javax.swing.border.*;
import java.awt.Insets;
import java.awt.Component;
import javax.swing.*;
public class UiJToolBar extends JToolBar {
public UiJToolBar() {
	super();
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
public void setEnabled(boolean state) {
	super.setEnabled(state);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		c.setEnabled(state);
	}
	Component parent = getParent();
	if (parent != null) {
		parent.invalidate();
		parent.validate();
		parent.repaint();
	}
}
	 /**
	  * Sets the margin between the toolbar's border and
	  * its buttons. Setting to null causes the toolbar to
	  * use the default margins. The toolbar's default Border
	  * object uses this value to create the proper margin.
	  * However, if a non-default border is set on the toolbar, 
	  * it is that Border object's responsibility to create the
	  * appropriate margin space (otherwise this property will 
	  * effectively be ignored).
	  *
	  * NOTE: This is a workaround since Swing does not respect the settings!
	  *
	  * @param m an Insets object that defines the space between the 
	  *          border and the buttons
	  * @see Insets
	  * @beaninfo
	  * description: The margin between the toolbar's border and contents
	  *       bound: true
	  *      expert: true
	  */
public void setMargin(Insets m) {
	super.setMargin(m);
	Border originalBorder= getBorder();
	if (originalBorder instanceof CompoundBorder)
		originalBorder= ((CompoundBorder) originalBorder).getOutsideBorder();
	if (m == null)
		setBorder(originalBorder);	
	else {
		Border margin = new EmptyBorder(m);		
		setBorder(new CompoundBorder(originalBorder, margin));
	}
}
}
