package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;


public class UiJCheckbox extends JCheckBox implements IRenderer {
	IAboutToPaintListener fListener= null;
public UiJCheckbox(String label) {
	super(label);
}
public void configureAsRenderer(JList list, IAboutToPaintListener listener, Object o, boolean isSelected) {
	fListener = listener;
	boolean state = false;
	if (o instanceof Boolean) {
		Boolean b = (Boolean) o;
		state = b.booleanValue();
	}
	setSelected(state);
	if (isSelected) {
		setOpaque(true); // we have to set this in order to get background painted
		setForeground(list.getSelectionForeground());
		setBackground(list.getSelectionBackground());
	}
	else {
		setOpaque(false);
		setForeground(list.getForeground());
		setBackground(list.getBackground());
	}
}
public void configureAsRenderer(JTable table, IAboutToPaintListener listener, Object o, boolean isSelected) {
	fListener = listener;
	boolean state = false;
	if (o instanceof Boolean) {
		Boolean b = (Boolean) o;
		state = b.booleanValue();
	}
	setSelected(state);
	if (isSelected) {
		setOpaque(true); // we have to set this in order to get background painted
		setForeground(table.getSelectionForeground());
		setBackground(table.getSelectionBackground());
	}
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
	public void free() {
		Container con= getParent();
		if (con != null)
			con.remove(this);
		fListener= null;
	}
	public void paint(Graphics g) {
		if (fListener != null)
			fListener.aboutToPaint();
		super.paint(g);
	}
}
