package com.ibm.ulc.ui;

import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.util.*;
import java.util.*;
/**
 * Implements the default class lookup mechanism for the UI Engine.
 * The <code>typeString</code> passed from the ULC is used to find a matching class.
 * If the typeString contains a '.' then the name is assumed to be a fully qualified
 * name and the typeString is used as the fully qualified class name
 *
 */
public class UiClassLookUp extends UlcObject implements IClassLookUp {
	protected Hashtable fClassMappingTable = null;
	static protected String[] fUIListElements = {"Column", "ComboBox", "List", "RowModel", "Table", "ItemList", "TableModel", "Tree", "TreeTable", "TreeRowModel", "HierarchicalItemList", "Container", "TreeColumn"};
	static protected String[] fUIDataTypeElements = {"DateValidator", "PercentValidator", "RangeValidator", "RegularExpressionValidator", "StringFormatter", "NumberValidator"};
/**
 * Construct a UiClassLookUp object with its classNameMappings initialized.
 */
public UiClassLookUp() {
	fClassMappingTable= classNameMappings();
}
/**
 * returns a fully qualified class name if a mapping exists or the type 
 * if no mapping exists
 */
public String classNameFor(String type) {
	Object mappedName = fClassMappingTable.get(type);
	return (mappedName == null ? null : (String) mappedName);
}
/**
 * Initialize the classNameMappings for this object.
 */
public Hashtable classNameMappings() {
	Hashtable h = new Hashtable();

	
	String uiListElementsPrefix = "com.ibm.ulc.ui.lists.UI";
	for (int i = 0; i < fUIListElements.length; i++) {
		h.put(fUIListElements[i], uiListElementsPrefix + fUIListElements[i]);
	}
	
	String uiDataTypeElementsPrefix = "com.ibm.ulc.ui.dataTypes.UI";
	for (int i = 0; i < fUIDataTypeElements.length; i++) {
		h.put(fUIDataTypeElements[i], uiDataTypeElementsPrefix + fUIDataTypeElements[i]);
	}


	return h;
}
}
