package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
public class UIPagebook extends UIFormComponent {
	protected JPanel fPanel = null;
	protected boolean fEnabled = true;
	protected boolean fVisible = true;
public void add(UIComponent cc) {
	UIPage page = (UIPage) cc;
	if (page != null) {
		Component c = (Component) page.getComponent();
		fPanel.add(page.getTitle(), c);
		if (!fVisible)
			page.setVisible(fVisible);
		if (!fEnabled)
			page.setEnabled(fEnabled);
		forceParentRepaint();
	}
	if (!fEnabled)
		setEnabled(fEnabled);
}
	public void free() {
		fPanel= null;
		super.free();
	}
	public Component getComponent() {
	    return fPanel;
	}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setPage")) {
		setPage(args.asString(null));
		return;
	}
	super.handleRequest(conn, request, args);
}
	public void remove(UIComponent cc) {
		UIPage page= (UIPage) cc;
		if (page != null) {
	        Component c= (Component) page.getComponent();
			fPanel.remove(c);
			forceParentRepaint();			
		}
	}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fPanel = new UiJPanel(new CardLayout(), getUI().getDoubleBuffering());
	if (args.isDefined("w") || args.isDefined("h"))
		fPanel.setPreferredSize(new Dimension(args.get("w", 200), args.get("h", 150)));
	super.restoreState(conn, args);
	if (fFormModel == null)
		setPage(args.get("page", null));
}
/**
 * Set the background of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setBackgroundColor(int red, int green, int blue, boolean refresh) {
	setBackgroundColorWithOpaque(red, green, blue, refresh);
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	super.setEnabled(state);
	fEnabled= state;
}
void setPage(String pageName) {
	if (pageName != null) {
		CardLayout cl = (CardLayout) fPanel.getLayout();
		if (cl != null) {
			cl.show(fPanel, pageName);
			fPanel.invalidate();
			fPanel.validate();
			Anything a = new Anything();
			a.put("tab", pageName);
			sendOptionalEventULC("tabChanged", a);
		}
	}
}
/**
 * Set the component to be visible or hidden.
 * 
 */
public void setVisible(boolean visible) {
	super.setVisible(visible);
	fVisible = visible;
}
public void updateFromModel() {
	if (fFormModel != null) {
		Object o = fFormModel.getValueAt(fKey);
		if (o instanceof PendingCell || o instanceof InvalidCell)
			o = null;
		if (o == null) {
			fPanel.setEnabled(false);
		}
		else {
			setPage(o.toString());
			fPanel.setEnabled(true);
		}
	}
}
}
