package com.ibm.ulc.ui;

import java.awt.Component;
import java.awt.Color;
import javax.swing.JComponent;
import com.ibm.ulc.ui.base.*;
/**
 * My instances mark mandatory widgets with a particular background color.
 */
public class UIMandatoryInputBackgroundColorStyle extends UIMandatoryInputStyle {
/**
 * Perform any processing necessary for the initialization of the component
 *
 */
protected void initializeForComponent(UIComponent component) {
	setPropertyValue(component, COLOR, component.getBackgroundComponent().getBackground());
}
/**
 * Change the background color (and save the old one) to show that more input is (not) needed.
 *
 * @param boolean 		needsInput	true if more input is needed, false otherwise
 * @param UIComponent	component	The owning widget 
 */
public void mark(boolean needsInput, UIComponent component) {
	if (getBooleanPropertyValue(component, NEEDS_INPUT) != needsInput) {
		Color newColor = null;
		if (needsInput)
			newColor = getHighLightColor();
		else
			if (component instanceof UIField)
				newColor = component.getBackgroundColor();
			else
				newColor = (Color) getPropertyValue(component, COLOR);
		Color oldColor = swapColorWith(component, newColor);
		setPropertyValue(component, COLOR, oldColor);
		setBooleanPropertyValue(component, NEEDS_INPUT, needsInput);
		component.getComponent().repaint();
	}
}
/**
 * Set the attributes used to display the mandatory character again,
 * in order to trigger a refresh of the user interface.
 */
void refreshNeedsMoreInputAttributes(boolean needsMoreInput, UIComponent c) {
	Component comp= c.getBackgroundComponent();
	if (needsMoreInput)
		comp.setBackground(getHighLightColor());
	else
		if (c instanceof UIField)
			comp.setBackground(c.getBackgroundColor());
		else
			comp.setBackground(comp.getBackground());
}
	
/**
 * Set the background color of the component to newColor and 
 * answer the old color object.
 * 
 * @param	UIComponent component	The INeedsMoreInput UIComponent
 * @param	Color		newColor	The new color
 * @return	Color					The old color
 */
public Color swapColorWith(UIComponent component, Color newColor) {
	Component comp = component.getBackgroundComponent();
	Color c = comp.getBackground();
	comp.setBackground(newColor);
	return c;
}
}
