package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.util.*;
import java.net.URL;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
public class UIApplication extends UIProxy {
	protected UIHelpBrowserContext fHelpContext = null;
	public UIApplication() {
	}
public void add(UIProxy m) {
}
public void checkIfLastApplication() {
	Enumeration c = fConnection.getRegistry().getRegistry().elements();
	while (c.hasMoreElements()) {
		try {
			UIApplication a = (UIApplication) c.nextElement();
			if (a != this)
				return;
		} catch (ClassCastException e) {
		}
	}
	fConnection.close();
}
/**
 * Display the help for the specified component
 * 
 */
protected void displayHelp(UIComponent component) {
	UIHelpBrowserContext hc = getHelpContext();
	if (hc != null) {
		URL u = component.getHelpURL(hc);
		hc.getBrowserHelper().showDocument(u);
	}
}
public UIApplication getApplication() {
	return this;
}
/**
 * The Help context is used when the user hits the F1 key.
 */
public UIHelpBrowserContext getHelpContext() {
	return fHelpContext;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("terminate")) {
		checkIfLastApplication();
		free(); // if it comes here there was more than one application active
		return;
	}
	if (request.equals("setHelpContext")) {
		setHelpContext(conn, args);
		return;
	}
	super.handleRequest(conn, request, args);
}
// we call internalRemoveFromChildren in the superclass so we do nothing here
public void remove(UIProxy m) {
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	setHelpContext(conn, args.get("hc"));
}
/**
 * The ULC application has sent a reference to the Help context.
 * Register it in the active connection. Each Application has its own Help Context.
 * The Help context is used when the user hits the F1 key.
 *
 * @param conn		ORBConnection	The active connection.
 * @param args		Anything		The arguments associated with this request.
 */
public void setHelpContext(ORBConnection connection, Anything args) {
	fHelpContext = (UIHelpBrowserContext) UIProxy.getManaged(UIHelpBrowserContext.class, connection, args);
}
}
