package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.base.*;
public class UIAlert extends UIComponent {
	protected Frame fParent = null;
	protected UIShell fParentShell = null;
	protected String fTitle = null;
	protected Object[] fOptions = null;
	protected String fMessage = null;
	protected Icon fIcon = null;
	protected JDialog fDialog; // caching in order to be able to free it later.
	protected static Object fgLock = new Object();
	protected static boolean fgBusy = false;
	private MouseAdapter fMouseAdapter = new MouseAdapter() {
		public void mousePressed(MouseEvent e) {
		}
	};
	private KeyAdapter fKeyAdapter = new KeyAdapter() {
		public void keyPressed(KeyEvent e) {
			e.consume();
		}
	};
	public void free() {
		if (fParent != null) {
			if (fParent instanceof UiJFrame)
				((UiJFrame) fParent).free();
			fParent.dispose();
			fParent= null;
		}	
		if (fDialog != null) {
			fDialog.getRootPane().removeAll();
			fDialog.getContentPane().removeAll();
			fDialog.getContentPane().setLayout(null);	
			fDialog.getParent().removeAll();
			fDialog.removeAll();
			fDialog.dispose();
			fDialog= null;
		}	
		fTitle= null;
		fOptions= null;
		fMessage= null;
		fIcon= null;
		super.free();
	}
	public Component getComponent() {
		return null;
	}
/**
 * Internal method.
 * Look for the first available shell and return it.
 * If no shells are available create a hidden shell and return it.
 */
private UIShell getDefaultShell(ORBConnection conn) {
	java.util.Enumeration c = conn.getRegistry().getRegistry().elements();
	while (c.hasMoreElements()) {
		try {
			UIShell s = (UIShell) c.nextElement();
			return s;
		}
		catch (ClassCastException e) {
		}
	}
	UIShell sh = new UIShell();
	sh.restoreState(conn, new Anything());
	return sh;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setVisible")) {
		if (fgBusy) {
			final ORBConnection c = conn;
			final String req = request;
			final Anything a = args;
			DeferredRequest r = new DeferredRequest(conn) {
				public void safeDispatch() {
					handleRequest(c, req, a);
				}
			};
			conn.postRequest(r);
		}
		else
			synchronized (fgLock) {
			fgBusy = true;
			show();
			fgBusy = false;
		}
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	fParentShell = (UIShell) getManaged(UIShell.class, conn, args.get("parent"));
	if (fParentShell == null)
		fParentShell = getDefaultShell(conn);
	if (fParentShell != null)
		fParent = fParentShell.getFrame();
	fTitle = args.get("label", "Alert");
	UIIcon icon = (UIIcon) getManaged(UIIcon.class, conn, args.get("icon"));
	if (icon != null) {
		Image image= icon.getImage();
		if (image != null)
			fIcon = new ImageIcon(image);
	}
	fMessage = args.get("msg", "<no message>");
	String b1 = args.get("button1", "Ok");
	String b2 = args.get("button2", null);
	String b3 = args.get("button3", null);
	if (b2 == null && b3 == null)
		fOptions = new Object[] {b1};
	else
		if (b2 != null && b3 != null)
			fOptions = new Object[] {b1, b2, b3};
		else
			if (b2 != null && b3 == null)
				fOptions = new Object[] {b1, b2};
			else
				fOptions = new Object[] {b1, b3};
	if (args.get("visible", true)) {
		show();
	}
}
private void setGlassPaneVisible(JFrame frame, boolean visible) {
	System.out.println("UIAlert Setting gp= " + visible);
	Component glassPane = frame.getGlassPane();
	if (glassPane != null) {
		if (visible) {
			((JComponent) glassPane).setOpaque(false);
			glassPane.addMouseListener(fMouseAdapter);
			glassPane.addKeyListener(fKeyAdapter);
		} else {
			glassPane.removeMouseListener(fMouseAdapter);
			glassPane.removeKeyListener(fKeyAdapter);
		}
		glassPane.setVisible(visible);
		if (visible)
			glassPane.requestFocus();
	}
}
public void show() {
	JOptionPane optionPane = new JOptionPane();
	if (fMessage != null)
		optionPane.setMessage(fMessage);
	if (fIcon != null)
		optionPane.setIcon(fIcon);
	if (fOptions != null)
		optionPane.setOptions(fOptions);
	JDialog dialog = optionPane.createDialog(fParent, fTitle);
	if (fParentShell != null)
		fParentShell.setGlassPaneVisibleForApplet(true);
	dialog.show();
	if (fParentShell != null)
		fParentShell.setGlassPaneVisibleForApplet(false);
	Object selectedValue = optionPane.getValue();
	sendEventULC("dismiss", "cmd", new Anything(selectedValue != null ? (String) selectedValue : "windowClosing"));
	dialog.dispose();
	// disabled caching of dialog because when running as an embedded applet the second time an
	// alert was displayed only the frame would display.
	//fDialog = dialog; // caching in order to be able to free it later.
	optionPane = null;
}
}
