package com.ibm.ulc.test;

import com.ibm.ulc.application.*;
import java.lang.reflect.Method;
import java.util.Vector;
import java.util.Enumeration;
import com.ibm.ulc.testsample.*;
public abstract class UlxControlViewAbstract extends UlxAbstractComposite {
	protected boolean fUpdateActivePageOnly = true;
	protected UlxAbstractTestComposite fTestComposite = null;
	protected boolean fTestRunResult = true;
/**
 * UlxControlViewAbstract constructor comment.
 */
public UlxControlViewAbstract() {
	super();
}
/**
 * UlxAbstractTestComposite constructor comment.
 * @param vajContext com.ibm.ulc.varun.IUsesVajContext
 */
public UlxControlViewAbstract(IUsesVajContext usesVajContext) {
	super(usesVajContext);
}
/**
 * Comment
 */
public void ctrLinkedFieldValueChanged(ULCField field, ULCSlider slider) {
	int value;
	try {
		value = Integer.parseInt((String) field.getValue());
	} catch (ClassCastException e) {
		value = 0;
	}
	slider.setValue(value);
}
/**
 * Comment
 */
public void ctrlLinkedSliderValueChanged(ULCSlider slider, ULCField field) {
	Integer value = slider.getValueAsInteger();
	if (field.getValue() != value)
		field.setValue(value.toString());
}
protected UlxTestedViewAbstract getActiveTestedView() {
	if (getTestComposite() == null)
		return null;
	else
		return getTestComposite().getActiveTestedView();
}
public UlxData getDataSource() {
	return getTestComposite().getDataSource();
}
protected String getInstruction() {
	return "This method (#getInstruction) should be reimplemented by all Control Views";
}
protected Method getMethod(Object object, String selector, Class[] parameters) {
	Method answer = null;
	try {
		answer = object.getClass().getMethod(selector, parameters);
	} catch (Throwable t) {
		logError(object, "getting selector " + selector, t);
	}
	return answer;
}
/**
 * Comment
 */
public Object getNull() {
	return null;
}
public boolean getRunResult() {
	return fTestRunResult;
}
protected ULCNotebook getTargetNotebook() {
	return getTestComposite().getTargetNotebook();
}
protected UlxAbstractTestComposite getTestComposite() {
	return fTestComposite;
}
protected Vector getTestProxies() {
	if (getTestComposite() == null)
		return new Vector();
	else
		return getTestComposite().getTargetProxies();
}
protected Vector getTestTargets() {
	if (getTestComposite() == null)
		return new Vector();
	else
		return getTestComposite().getTargetComponents();
}
protected boolean getUpdateActivePageOnly() {
	return fUpdateActivePageOnly;
}
public void logError(Object object, String selector, Throwable t) {
	getTestComposite().logError(object, selector, t);
	pause();
}
protected void pause() {
	try {
		getTestComposite().pause();
	} catch (Throwable t) {
		try {
			Thread.sleep(1000);
		} catch (Throwable tt) {
			tt.toString();
		}
	}
}
public void resetErrorLog() {
	getTestComposite().resetErrorLog();
}
public void resetRunResult() {
	fTestRunResult = true;
}
/**
 * This message is sent to the receiver when automatic testing is selected for the
 * testcase holding the receiver. It is meant to execute the tests (if any) that can
 * run in unattended mode.
 *
 * The answer indicates whether the tests have completed successfully in that no
 * exception has been encountered.
 *
 * The @visibly parameter indicates whether the pages (if any) of the notebook holding
 * the tested components should be made visible or not. It should be noted that in
 * most cases, the tests are meaningless because only the test on the first page will 
 * actually execute code on the UI engine.
 *
 * @param	visibly		make all tests visible while executing
 * @return	boolean		indicates the apparent success of the test
 */
abstract public void run(boolean visibly);
/**
 * The component that will be sent up in my place.
 */
protected void setComponent(ULCComponent component) {
	super.setComponent(component);
	setInstructionText(getInstruction());
}
abstract protected void setInstructionText(String instruction);
protected void setNotebookPage(int index, boolean doit) {
	if (doit && getTargetNotebook() != null) {
		getTargetNotebook().setActiveTab(index);
		pause();
	}
}
protected void setRunResult(boolean result) {
	if (!result)
		fTestRunResult = false;
	pause();
}
public void setTestComposite(UlxAbstractTestComposite composite) {
	fTestComposite = composite;
}
/**
 * Answer the test categories covered by the receiver
 *
 * 
 */
static public String[] testCategories() {
	return new String[] {"uncategorized"};
}
/**
 * Answer the names of the API tested in this component.
 *
 * The answer contains the names of the methods tested.
 */
static public String[] testedAPI() {
	return new String[] {};
}
/**
 * Answer the names of the ULC classes tested in this component.
 *
 * Unless the classse tested are defined in <code>com.ibm.ulc.application</code>, the
 * class names must be fully specified. This information is optional if @testedPRs 
 * is specified.
 */
static public String[] testedClasses() {
	return new String[0];
}
public void testMessage(String message) {
	getTestComposite().testMessage(message);
}
/**
 * Answer the String to be displayed in the receiver's notebook tab.
 *
 * Some test suites will include multiple tests in one notebook. This method
 * allows for specific titles. If subclasses do not reimplement this method, the
 * receiver's class name is answered.
 */
static public String testPageTabString() {
	if (testedAPI().length > 0)
		return testedAPI()[0];
	else
		return "N/A";
}
}
