package com.ibm.ulc.examples.carRental.views;

import java.io.PrintStream;
import java.util.Vector;
import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.examples.carRental.model.*;

/**
 * The main view for displaying/editing a reservation.
 */
public class ReservationView extends AbstractView implements IActionListener, ISelectionChangedListener, IUsesVajContext, IWindowListener {
	/**
	 Open the view on a test instance, instead of an "empty" instance.
	 */
	protected static boolean fgUseTestInstance= false;
	/**
	 * Turn on debug mode (show a debug menu).
	 */
	protected static boolean fgDebugMode= false;
	/**
	 * The form model holding onto the model of this view.
	 * @serial
	 */
	protected ContractSpecFormModel fContractSpecFormModel= new ContractSpecFormModel(ULCFormModel.FORM_NOTIFICATION_ON_REQUEST);
	/**
	 * The location tree model that is shared among the location selection composites
	 * @serial
	 */
	protected ULCTreeTableModel fLocationTreeModel= null;
	/**
	 * The debug menu
	 * @serial
	 */
	protected ULCMenu fDebugMenu= null;
	private ULCLabel ivjAwardLabel1 = null;
	private ULCButton ivjBackButton = null;
	private ULCButton ivjCancelButton = null;
	private ULCButton ivjFinishButton = null;
	private ULCBox ivjHorizontalBox = null;
	private ULCBox ivjHorizontalBox1 = null;
	private ULCLabel ivjLogoLabel = null;
	private ULCButton ivjNextButton = null;
	private ULCLabel ivjRentsLabel = null;
	private ULCBox ivjVerticalBox = null;
	private ULCFiller ivjFiller1 = null;
	private ULCNotebook ivjNotebook1 = null;
	private ULCPage ivjPage1 = null;
	private ULCPage ivjPage2 = null;
	private ULCPage ivjPage3 = null;
	private ULCPage ivjPage4 = null;
	private ULCPage ivjPage5 = null;
	private ULCPage ivjPage6 = null;
	private ULCPage ivjPage7 = null;
	private CustomerForm ivjCustomerForm = null;
	protected ULCVajContext ivjVajContext = null;
	private PickupForm ivjPickupForm = null;
	private ReturnForm ivjReturnForm = null;
	private CarForm ivjCarForm = null;
	private GuaranteeForm ivjGuaranteeForm = null;
	private OptionsForm ivjOptionsForm = null;
	private PriceForm ivjPriceForm = null;
	private ULCMandatoryAndEnabler ivjAbsoluteMandatoryEnabler = null;
	private ULCAndEnabler ivjAndEnabler = null;
	private ULCMandatoryAndEnabler ivjConditionalMandatoryEnabler = null;
	private ULCOrEnabler ivjOrEnabler = null;
	private ULCMenuItem ivjExitMenuItem = null;
	private ULCMenu ivjFileMenu = null;
	private ULCMenu ivjGoMenu = null;
	private ULCMenuItem ivjNextMenuItem = null;
	private ULCMenuItem ivjPreviousMenuItem = null;
	private ULCMenuBar ivjShellULCMenuBar = null;
	private ULCMenuItem ivjPrintScreen = null;
	private ULCMenuItem ivjPrintScreenD = null;
/**
 * ReservationView constructor comment.
 */
public ReservationView() {
	super();
}
/**
 * Constructor
 * @param usesVajContext com.ibm.ulc.application.IUsesVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public ReservationView(com.ibm.ulc.application.IUsesVajContext usesVajContext) {
	super();
	if (usesVajContext != null) {
		ivjVajContext = usesVajContext.getVajContext();
	}
	initialize();
}
/**
 * Constructor
 * @param usesVajContext com.ibm.ulc.application.IUsesVajContext
 * @param title java.lang.String
 * @param parent com.ibm.ulc.application.ULCShell
 * @param modal boolean
 * @param visible boolean
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public ReservationView(com.ibm.ulc.application.IUsesVajContext usesVajContext, java.lang.String title, com.ibm.ulc.application.ULCShell parent, boolean modal, boolean visible) {
	super();
	if (usesVajContext != null) {
		ivjVajContext = usesVajContext.getVajContext();
	}
	initialize();
	if (title != null && title.length() != 0) 
		fLabel = title;
	fModal = modal;
	fVisible = visible;
	setParentShell(parent);
}
/**
 * Method to handle events for the IActionListener interface.
 * @param actionEvent com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(com.ibm.ulc.application.ULCActionEvent actionEvent) {
	// user code begin {1}
	// user code end
	if (actionEvent.getSource() == getFinishButton()) 
		connEtoC2(actionEvent);
	if (actionEvent.getSource() == getNextButton()) 
		connEtoC3(actionEvent);
	if (actionEvent.getSource() == getBackButton()) 
		connEtoC4(actionEvent);
	if (actionEvent.getSource() == getCancelButton()) 
		connEtoC5(actionEvent);
	if (actionEvent.getSource() == getExitMenuItem()) 
		connEtoC6(actionEvent);
	if (actionEvent.getSource() == getNextMenuItem()) 
		connEtoC7(actionEvent);
	if (actionEvent.getSource() == getPreviousMenuItem()) 
		connEtoC8(actionEvent);
	if (actionEvent.getSource() == getPrintScreen()) 
		connEtoM1(actionEvent);
	if (actionEvent.getSource() == getPrintScreenD()) 
		connEtoM2(actionEvent);
	// user code begin {2}
	// user code end
}
/**
 * Align the data on UI and ULC side: to do so,
 * take the input from the UI and then upload everything again.
 *
 * Creation date: (27.01.00 16:59:57)
 */
protected void alignUIAndULC() {
	saveInput();
	fContractSpecFormModel.cancelInput();
}
/**
 * Comment
 */
public void backButton_ActionPerformed(com.ibm.ulc.application.ULCActionEvent event) {
	previousAction();
}
/**
 * Comment
 */
public void cancelButton_ActionPerformed(com.ibm.ulc.application.ULCActionEvent event) {
	closeAction();
}
/**
 * Shut the view.
 * Creation date: (11.01.00 18:41:19)
 */
protected void closeAction() {
	ULCAlert alert= new ULCAlert(this, "Question", "Do you want to close the reservation wizard?", "Yes", "No");
	if ((alert.ask()).equals("Yes")) {
		setVisible(false);
	}
}
/**
 * connEtoC1:  (Notebook1.selectionChanged.selectionChanged(com.ibm.ulc.application.ULCSelectionChangedEvent) --> ReservationView.notebook1_SelectionChanged(Lcom.ibm.ulc.application.ULCSelectionChangedEvent;)V)
 * @param arg1 com.ibm.ulc.application.ULCSelectionChangedEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1(com.ibm.ulc.application.ULCSelectionChangedEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.notebook1_SelectionChanged(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC2:  (FinishButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> ReservationView.finishButton_ActionPerformed1(Lcom.ibm.ulc.application.ULCActionEvent;)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC2(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.finishButton_ActionPerformed1(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC3:  (NextButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> ReservationView.nextButton_ActionPerformed(Lcom.ibm.ulc.application.ULCActionEvent;)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC3(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.nextButton_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC4:  (BackButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> ReservationView.backButton_ActionPerformed(Lcom.ibm.ulc.application.ULCActionEvent;)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC4(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.backButton_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC5:  (CancelButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> ReservationView.cancelButton_ActionPerformed(Lcom.ibm.ulc.application.ULCActionEvent;)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC5(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.cancelButton_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC6:  (ExitMenuItem.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> ReservationView.exitMenuItem_ActionPerformed(Lcom.ibm.ulc.application.ULCActionEvent;)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC6(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.exitMenuItem_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC7:  (NextMenuItem.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> ReservationView.nextMenuItem_ActionPerformed(Lcom.ibm.ulc.application.ULCActionEvent;)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC7(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.nextMenuItem_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC8:  (PreviousMenuItem.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> ReservationView.previousMenuItem_ActionPerformed(Lcom.ibm.ulc.application.ULCActionEvent;)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC8(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.previousMenuItem_ActionPerformed(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC9:  (Shell.windowClosing.windowClosing(com.ibm.ulc.application.ULCWindowEvent) --> ReservationView.closeAction()V)
 * @param arg1 com.ibm.ulc.application.ULCWindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC9(com.ibm.ulc.application.ULCWindowEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.closeAction();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM1:  (PrintScreen.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> Shell.printScreen()V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM1(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.printScreen();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM2:  (PrintScreenD.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> Shell.printScreen(ZZ)V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM2(com.ibm.ulc.application.ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.printScreen(true, true);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP1SetTarget:  (AndEnabler.this <--> FinishButton.enabler)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP1SetTarget() {
	/* Set the target from the source */
	try {
		getFinishButton().setEnabler(getAndEnabler());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP2SetTarget:  (AbsoluteMandatoryEnabler.this <--> AndEnabler.and)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP2SetTarget() {
	/* Set the target from the source */
	try {
		getAndEnabler().setAnd(getAbsoluteMandatoryEnabler());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP3SetTarget:  (OrEnabler.this <--> AndEnabler.and)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP3SetTarget() {
	/* Set the target from the source */
	try {
		getAndEnabler().setAnd(getOrEnabler());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP4SetTarget:  (ConditionalMandatoryEnabler.this <--> OrEnabler.or)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP4SetTarget() {
	/* Set the target from the source */
	try {
		getOrEnabler().setOr(getConditionalMandatoryEnabler());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP5SetTarget:  (ReservationView.companyLogo <--> LogoLabel.icon)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP5SetTarget() {
	/* Set the target from the source */
	try {
		getLogoLabel().setIcon((com.ibm.ulc.application.ULCIcon)this.getCompanyLogo());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP6SetTarget:  (ReservationView.awardLogo <--> AwardLabel1.icon)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP6SetTarget() {
	/* Set the target from the source */
	try {
		getAwardLabel1().setIcon(this.getAwardLogo());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * Enable/disable the back and next button for the page index given in the argument.
 * @param page int
 */
protected void doPageDependentEnabling(int page) {
	int pages = getNotebook1().getPages().size();
	getBackButton().setEnabled(page > 0);
	getNextButton().setEnabled(page < pages-1);
}
/**
 * Comment
 */
public void exitMenuItem_ActionPerformed(com.ibm.ulc.application.ULCActionEvent event) {
	closeAction();
}
/**
 * Do the final part initializations here.
 * 
 * Creation date: (31.12.99 13:00:59)
 */
protected void finalInitialize() {
	super.finalInitialize();
	// create and propagate references to the location tree model
	fLocationTreeModel= new LocationTreeModel();
	getPickupForm().setLocationsTreeModel(fLocationTreeModel);
	getReturnForm().setLocationsTreeModel(fLocationTreeModel);

	// propagate references to the ContractSpecFormModel
	getCustomerForm().setContractSpecFormModel(fContractSpecFormModel);
	getPickupForm().setContractSpecFormModel(fContractSpecFormModel);
	getReturnForm().setContractSpecFormModel(fContractSpecFormModel);
	getCarForm().setContractSpecFormModel(fContractSpecFormModel);
	getOptionsForm().setContractSpecFormModel(fContractSpecFormModel);
	getPriceForm().setContractSpecFormModel(fContractSpecFormModel);
	getGuaranteeForm().setContractSpecFormModel(fContractSpecFormModel);

	// propagate references to the receiver shell
	getPickupForm().setShell(this);
	getReturnForm().setShell(this);
	//  the other composites do not need them 
	
	// Own stuff
	setLabel("ULC's Car Rental");
	setUpEnablers();
	doPageDependentEnabling(0);
	getShellULCMenuBar().add(getDebugMenu());
}
/**
 * Save the model and shut the view.
 * Creation date: (11.01.00 18:41:19)
 */
protected void finishAction() {
	saveInput();
	fContractSpecFormModel.getContractSpec().setState(ContractSpec.RESERVATION);
	ULCAlert alert= new ULCAlert(this, "See you soon", "Thank you for your reservation!", "OK");
	alert.ask();
	setVisible(false);
}
/**
 * Comment
 */
public void finishButton_ActionPerformed1(com.ibm.ulc.application.ULCActionEvent event) {
	finishAction();
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	super.free();
	fContractSpecFormModel = null;
	fLocationTreeModel = null;
	fDebugMenu = null;
	fDefaultButton = null;
	ivjVajContext = null;
}
/**
 * Return the AbsoluteMandatoryEnabler property value.
 * @return com.ibm.ulc.application.ULCMandatoryAndEnabler
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMandatoryAndEnabler getAbsoluteMandatoryEnabler() {
	if (ivjAbsoluteMandatoryEnabler == null) {
		try {
			ivjAbsoluteMandatoryEnabler = new com.ibm.ulc.application.ULCMandatoryAndEnabler();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAbsoluteMandatoryEnabler;
}
/**
 * Return the AndEnabler property value.
 * @return com.ibm.ulc.application.ULCAndEnabler
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCAndEnabler getAndEnabler() {
	if (ivjAndEnabler == null) {
		try {
			ivjAndEnabler = new com.ibm.ulc.application.ULCAndEnabler();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAndEnabler;
}
/**
 * 
 * @return com.ibm.ulc.application.ULCApplication
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public com.ibm.ulc.application.ULCApplication getApplication() {
	com.ibm.ulc.util.Assert.isNotNull(ivjVajContext);
	return ivjVajContext.getApplication();
}
/**
 * Return the AwardLabel1 property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getAwardLabel1() {
	if (ivjAwardLabel1 == null) {
		try {
			ivjAwardLabel1 = new com.ibm.ulc.application.ULCLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAwardLabel1;
}
/**
 * Return the BackButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getBackButton() {
	if (ivjBackButton == null) {
		try {
			ivjBackButton = new com.ibm.ulc.application.ULCButton("< ~Previous");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBackButton;
}
/**
 * Return the CancelButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getCancelButton() {
	if (ivjCancelButton == null) {
		try {
			ivjCancelButton = new com.ibm.ulc.application.ULCButton("Close");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjCancelButton;
}
/**
 * Return the CarForm property value.
 * @return com.ibm.ulc.examples.carRental.views.CarForm
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private CarForm getCarForm() {
	if (ivjCarForm == null) {
		try {
			ivjCarForm = new com.ibm.ulc.examples.carRental.views.CarForm(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjCarForm;
}
/**
 * Return the ConditionalMandatoryEnabler property value.
 * @return com.ibm.ulc.application.ULCMandatoryAndEnabler
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMandatoryAndEnabler getConditionalMandatoryEnabler() {
	if (ivjConditionalMandatoryEnabler == null) {
		try {
			ivjConditionalMandatoryEnabler = new com.ibm.ulc.application.ULCMandatoryAndEnabler();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjConditionalMandatoryEnabler;
}
/**
 * Gets the contractSpecFormModel property (com.ibm.ulc.examples.carRental.views.ContractSpecFormModel) value.
 * @return The contractSpecFormModel property value.
 * @see #setContractSpecFormModel
 */
public ContractSpecFormModel getContractSpecFormModel() {
	return fContractSpecFormModel;
}
/**
 * Return the CustomerForm property value.
 * @return com.ibm.ulc.examples.carRental.views.CustomerForm
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private CustomerForm getCustomerForm() {
	if (ivjCustomerForm == null) {
		try {
			ivjCustomerForm = new com.ibm.ulc.examples.carRental.views.CustomerForm(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjCustomerForm;
}
/**
 * Return the debug menu.
 * @return com.ibm.ulc.application.ULCMenu
 */
protected ULCMenu getDebugMenu() {
	if (fDebugMenu == null) {
		fDebugMenu = new ULCMenu("~Debug");

		// inspect model
		ULCMenuItem inspectModel = new ULCMenuItem("Inspect ~model");
		inspectModel.addActionListener(new IActionListener() {
			public void actionPerformed(ULCActionEvent e) {
				inspectModel();
			}
		});
		fDebugMenu.add(inspectModel);
		// user code begin {1}
		// user code end
	}
	return fDebugMenu;
}
/**
 * Return the ExitMenuItem property value.
 * @return com.ibm.ulc.application.ULCMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenuItem getExitMenuItem() {
	if (ivjExitMenuItem == null) {
		try {
			ivjExitMenuItem = new com.ibm.ulc.application.ULCMenuItem("E~xit");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjExitMenuItem;
}
/**
 * Return the FileMenu property value.
 * @return com.ibm.ulc.application.ULCMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenu getFileMenu() {
	if (ivjFileMenu == null) {
		try {
			ivjFileMenu = new com.ibm.ulc.application.ULCMenu("~File");
			ivjFileMenu.add(getPrintScreen());
			ivjFileMenu.add(getPrintScreenD());
			ivjFileMenu.add(getExitMenuItem());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFileMenu;
}
/**
 * Return the Filler1 property value.
 * @return com.ibm.ulc.application.ULCFiller
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCFiller getFiller1() {
	if (ivjFiller1 == null) {
		try {
			ivjFiller1 = new com.ibm.ulc.application.ULCFiller();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFiller1;
}
/**
 * Return the FinishButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getFinishButton() {
	if (ivjFinishButton == null) {
		try {
			ivjFinishButton = new com.ibm.ulc.application.ULCButton("Finish");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFinishButton;
}
/**
 * Return the GoMenu property value.
 * @return com.ibm.ulc.application.ULCMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenu getGoMenu() {
	if (ivjGoMenu == null) {
		try {
			ivjGoMenu = new com.ibm.ulc.application.ULCMenu("~Go");
			ivjGoMenu.add(getNextMenuItem());
			ivjGoMenu.add(getPreviousMenuItem());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGoMenu;
}
/**
 * Return the GuaranteeForm property value.
 * @return com.ibm.ulc.examples.carRental.views.GuaranteeForm
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private GuaranteeForm getGuaranteeForm() {
	if (ivjGuaranteeForm == null) {
		try {
			ivjGuaranteeForm = new com.ibm.ulc.examples.carRental.views.GuaranteeForm(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGuaranteeForm;
}
/**
 * Return the Horizontal Box property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getHorizontalBox() {
	if (ivjHorizontalBox == null) {
		try {
			ivjHorizontalBox = new com.ibm.ulc.application.ULCBox(1, 4);
			ivjHorizontalBox.add(0, 0, getBackButton());
			ivjHorizontalBox.add(1, 0, getNextButton());
			ivjHorizontalBox.add(2, 0, getFinishButton());
			ivjHorizontalBox.add(3, 0, getCancelButton());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjHorizontalBox;
}
/**
 * Return the Horizontal Box1 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getHorizontalBox1() {
	if (ivjHorizontalBox1 == null) {
		try {
			ivjHorizontalBox1 = new com.ibm.ulc.application.ULCBox(1, 3);
			ivjHorizontalBox1.add(0, 0, getLogoLabel());
			ivjHorizontalBox1.add(1, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getFiller1());
			ivjHorizontalBox1.add(2, 0, com.ibm.ulc.base.IDefaults.BOX_RIGHT_CENTER, getAwardLabel1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjHorizontalBox1;
}
/**
 * Return the LogoLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getLogoLabel() {
	if (ivjLogoLabel == null) {
		try {
			ivjLogoLabel = new com.ibm.ulc.application.ULCLabel("");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLogoLabel;
}
/**
 * Return the NextButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButton getNextButton() {
	if (ivjNextButton == null) {
		try {
			ivjNextButton = new com.ibm.ulc.application.ULCButton("~Next >");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjNextButton;
}
/**
 * Return the NextMenuItem property value.
 * @return com.ibm.ulc.application.ULCMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenuItem getNextMenuItem() {
	if (ivjNextMenuItem == null) {
		try {
			ivjNextMenuItem = new com.ibm.ulc.application.ULCMenuItem("~Next");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjNextMenuItem;
}
/**
 * Return the Notebook1 property value.
 * @return com.ibm.ulc.application.ULCNotebook
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCNotebook getNotebook1() {
	if (ivjNotebook1 == null) {
		try {
			ivjNotebook1 = new com.ibm.ulc.application.ULCNotebook();
			ivjNotebook1.setHeight(450);
			ivjNotebook1.setWidth(450);
			ivjNotebook1.setVeto(true);
			ivjNotebook1.addPage(getPage1());
			ivjNotebook1.addPage(getPage2());
			ivjNotebook1.addPage(getPage3());
			ivjNotebook1.addPage(getPage4());
			ivjNotebook1.addPage(getPage5());
			ivjNotebook1.addPage(getPage6());
			ivjNotebook1.addPage(getPage7());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjNotebook1;
}
/**
 * Return the OptionsForm property value.
 * @return com.ibm.ulc.examples.carRental.views.OptionsForm
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private OptionsForm getOptionsForm() {
	if (ivjOptionsForm == null) {
		try {
			ivjOptionsForm = new com.ibm.ulc.examples.carRental.views.OptionsForm(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjOptionsForm;
}
/**
 * Return the OrEnabler property value.
 * @return com.ibm.ulc.application.ULCOrEnabler
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCOrEnabler getOrEnabler() {
	if (ivjOrEnabler == null) {
		try {
			ivjOrEnabler = new com.ibm.ulc.application.ULCOrEnabler();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjOrEnabler;
}
/**
 * Return the Page1 property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getPage1() {
	if (ivjPage1 == null) {
		try {
			ivjPage1 = new com.ibm.ulc.application.ULCPage("Customer", getCustomerForm());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPage1;
}
/**
 * Return the Page2 property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getPage2() {
	if (ivjPage2 == null) {
		try {
			ivjPage2 = new com.ibm.ulc.application.ULCPage("Pickup", getPickupForm());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPage2;
}
/**
 * Return the Page3 property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getPage3() {
	if (ivjPage3 == null) {
		try {
			ivjPage3 = new com.ibm.ulc.application.ULCPage("Return", getReturnForm());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPage3;
}
/**
 * Return the Page4 property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getPage4() {
	if (ivjPage4 == null) {
		try {
			ivjPage4 = new com.ibm.ulc.application.ULCPage("Car", getCarForm());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPage4;
}
/**
 * Return the Page5 property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getPage5() {
	if (ivjPage5 == null) {
		try {
			ivjPage5 = new com.ibm.ulc.application.ULCPage("Options", getOptionsForm());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPage5;
}
/**
 * Return the Page6 property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getPage6() {
	if (ivjPage6 == null) {
		try {
			ivjPage6 = new com.ibm.ulc.application.ULCPage("Price", getPriceForm());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPage6;
}
/**
 * Return the Page7 property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getPage7() {
	if (ivjPage7 == null) {
		try {
			ivjPage7 = new com.ibm.ulc.application.ULCPage("Billing", getGuaranteeForm());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPage7;
}
/**
 * Return the PickupForm property value.
 * @return com.ibm.ulc.examples.carRental.views.PickupForm
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private PickupForm getPickupForm() {
	if (ivjPickupForm == null) {
		try {
			ivjPickupForm = new com.ibm.ulc.examples.carRental.views.PickupForm(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPickupForm;
}
/**
 * Return the PreviousMenuItem property value.
 * @return com.ibm.ulc.application.ULCMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenuItem getPreviousMenuItem() {
	if (ivjPreviousMenuItem == null) {
		try {
			ivjPreviousMenuItem = new com.ibm.ulc.application.ULCMenuItem("~Previous");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPreviousMenuItem;
}
/**
 * Return the PriceForm property value.
 * @return com.ibm.ulc.examples.carRental.views.PriceForm
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private PriceForm getPriceForm() {
	if (ivjPriceForm == null) {
		try {
			ivjPriceForm = new com.ibm.ulc.examples.carRental.views.PriceForm(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPriceForm;
}
/**
 * Return the PrintScreen property value.
 * @return com.ibm.ulc.application.ULCMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenuItem getPrintScreen() {
	if (ivjPrintScreen == null) {
		try {
			ivjPrintScreen = new com.ibm.ulc.application.ULCMenuItem("Print");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPrintScreen;
}
/**
 * Return the PrintScreenD property value.
 * @return com.ibm.ulc.application.ULCMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenuItem getPrintScreenD() {
	if (ivjPrintScreenD == null) {
		try {
			ivjPrintScreenD = new com.ibm.ulc.application.ULCMenuItem("Print...");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPrintScreenD;
}
/**
 * Return the RentsLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getRentsLabel() {
	if (ivjRentsLabel == null) {
		try {
			ivjRentsLabel = new com.ibm.ulc.application.ULCLabel("ULC rents Uolvos and other fine cars");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjRentsLabel;
}
/**
 * 
 * @return java.util.ResourceBundle
 * @param bundleFilename java.lang.String
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public java.util.ResourceBundle getResourceBundle(java.lang.String bundleFilename) {
	com.ibm.ulc.util.Assert.isNotNull(ivjVajContext);
	return ivjVajContext.getResourceBundle(bundleFilename);
}
/**
 * Return the ReturnForm property value.
 * @return com.ibm.ulc.examples.carRental.views.ReturnForm
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ReturnForm getReturnForm() {
	if (ivjReturnForm == null) {
		try {
			ivjReturnForm = new com.ibm.ulc.examples.carRental.views.ReturnForm(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjReturnForm;
}
/**
 * Return the ShellULCMenuBar property value.
 * @return com.ibm.ulc.application.ULCMenuBar
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCMenuBar getShellULCMenuBar() {
	if (ivjShellULCMenuBar == null) {
		try {
			ivjShellULCMenuBar = new com.ibm.ulc.application.ULCMenuBar();
			ivjShellULCMenuBar.add(getFileMenu());
			ivjShellULCMenuBar.add(getGoMenu());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjShellULCMenuBar;
}
/**
 * 
 * @return com.ibm.ulc.application.ULCVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public com.ibm.ulc.application.ULCVajContext getVajContext() {
	return ivjVajContext;
}
/**
 * Return the Vertical Box property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getVerticalBox() {
	if (ivjVerticalBox == null) {
		try {
			ivjVerticalBox = new com.ibm.ulc.application.ULCBox(4, 1);
			ivjVerticalBox.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getHorizontalBox1());
			ivjVerticalBox.add(0, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, getNotebook1());
			ivjVerticalBox.add(0, 2, getHorizontalBox());
			ivjVerticalBox.add(0, 3, getRentsLabel());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjVerticalBox;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 * @exception java.lang.Exception The exception description.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	getFinishButton().addActionListener(this);
	getNextButton().addActionListener(this);
	getBackButton().addActionListener(this);
	getCancelButton().addActionListener(this);
	getNotebook1().addSelectionChangedListener(this);
	getExitMenuItem().addActionListener(this);
	getNextMenuItem().addActionListener(this);
	getPreviousMenuItem().addActionListener(this);
	getPrintScreen().addActionListener(this);
	getPrintScreenD().addActionListener(this);
	this.addWindowClosingListener(this);
	connPtoP1SetTarget();
	connPtoP2SetTarget();
	connPtoP3SetTarget();
	connPtoP4SetTarget();
	connPtoP5SetTarget();
	connPtoP6SetTarget();
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		setVeto(true);
		fContractSpecFormModel.setContractSpec( fgUseTestInstance
			? DataAccessor.instance().getTestInstance1()
			: new ContractSpec());
		// user code end
		com.ibm.ulc.util.Assert.isNotNull(ivjVajContext);
		// user code begin {2}
		// user code end
		setMenuBar(getShellULCMenuBar());
		setDestroyOnClose(true);
		setLabel("Shell");
		add(getVerticalBox());
		getAndEnabler();
		getAbsoluteMandatoryEnabler();
		getOrEnabler();
		getConditionalMandatoryEnabler();
		initConnections();
		// user code begin {3}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {4}
	finalInitialize();
	// user code end
}
/**
 * Print a description of the current model attributes to stdout.
 * Creation date: (27.01.00 15:32:39)
 */
protected void inspectModel() {
	PrintStream ps= System.out;
	ps.println("Model "+fContractSpecFormModel.getContractSpec());
	String[] attrs= ContractSpecFormModel.ALL_ATTRIBUTE_NAMES;
	for (int i= 0; i<attrs.length; i++) {
		ps.print("\t");
		ps.println(attrs[i]+ " = " +fContractSpecFormModel.getValueAt(attrs[i]));
	}
}
/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		ULCVajContext.testULCClass(args, ReservationView.class);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of com.ibm.ulc.examples.carRental.views.AbstractView");
		exception.printStackTrace(System.out);
	}
}
/**
 * Please do not use or rely on this method. It is used by the VAJava test process.
 * It is public only so that the ULCVajContext class can access the method.
 * It can change at any time, or it could be entirely removed in any update 
 * to the VAJava builder. Thank you.
 * @return com.ibm.ulc.application.ULCComponent
 * @param context com.ibm.ulc.application.ULCVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public static com.ibm.ulc.application.ULCComponent mainTestConstruction(com.ibm.ulc.application.ULCVajContext context) {
	return new ReservationView(context);
}
/**
 * Switch to the next notebook page.
 * Creation date: (11.01.00 18:41:19)
 */
protected void nextAction() {
	int currIndex= getNotebook1().getActiveTab();
	int maxIndex= getNotebook1().getPages().size()-1;
	if (currIndex<maxIndex) {
		alignUIAndULC();
		getNotebook1().setActiveTab(currIndex+1);
		doPageDependentEnabling(currIndex+1);
	}
}
/**
 * Comment
 */
public void nextButton_ActionPerformed(com.ibm.ulc.application.ULCActionEvent event) {
	nextAction();
}
/**
 * Comment
 */
public void nextMenuItem_ActionPerformed(com.ibm.ulc.application.ULCActionEvent event) {
	nextAction();
}
/**
 * Comment
 */
public void notebook1_SelectionChanged(com.ibm.ulc.application.ULCSelectionChangedEvent event) {
	tabChangeRequest(event.getLastIndex(), (ULCNotebook)event.getSource());
}
/**
 * Switch to the previous notebook page.
 * Creation date: (11.01.00 18:41:19)
 */
protected void previousAction() {
	int currIndex= getNotebook1().getActiveTab();
	if (currIndex>0) {
		alignUIAndULC();
		getNotebook1().setActiveTab(currIndex-1);
		doPageDependentEnabling(currIndex-1);
	}
}
/**
 * Comment
 */
public void previousMenuItem_ActionPerformed(com.ibm.ulc.application.ULCActionEvent event) {
	previousAction();
}
/**
 * Save the input to the model.
 * Creation date: (11.01.00 13:56:52)
 */
public void saveInput() {
	fContractSpecFormModel.saveInput();
	Vector pages= getNotebook1().getPages();
	for (int i=0; i<pages.size(); i++) {
		ULCPage page= (ULCPage)(pages.elementAt(i));
		NotebookPageComposite composite= (NotebookPageComposite) page.getComponent();
		if (composite!=null) composite.saveInput();
	}
}
/**
 * Method to handle events for the ISelectionChangedListener interface.
 * @param selectionChangedEvent com.ibm.ulc.application.ULCSelectionChangedEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void selectionChanged(com.ibm.ulc.application.ULCSelectionChangedEvent selectionChangedEvent) {
	// user code begin {1}
	// user code end
	if (selectionChangedEvent.getSource() == getNotebook1()) 
		connEtoC1(selectionChangedEvent);
	// user code begin {2}
	// user code end
}
/**
 * Sets the contractSpecFormModel property (com.ibm.ulc.examples.carRental.views.ContractSpecFormModel) value.
 * @param contractSpecFormModel The new value for the property.
 * @see #getContractSpecFormModel
 */
public void setContractSpecFormModel(ContractSpecFormModel contractSpecFormModel) {
	fContractSpecFormModel = contractSpecFormModel;
}
/**
 * Set whether the debug mode (debug menu) should be turned on.
 *
 * Creation date: (25.01.00 15:50:20)
 * @param useDebugMode boolean
 */
public static void setDebugMode(boolean useDebugMode) {
	fgDebugMode= useDebugMode;
}
/**
 * Set up the enablers.
 * Creation date: (11.01.00 17:14:05)
 */
protected void setUpEnablers() {
	ULCAndEnabler absMandEnabler= getAbsoluteMandatoryEnabler();
	absMandEnabler.add(getPickupForm().pGetPickupDateField());
	absMandEnabler.add(getPickupForm().pGetPickupTimeField());
	absMandEnabler.add(getReturnForm().pGetReturnDateField());
	absMandEnabler.add(getReturnForm().pGetReturnTimeField());
	absMandEnabler.add(getCarForm().pGetAvailableCarSpecTable());
	absMandEnabler.add(getGuaranteeForm().pGetCardNumberField());
	absMandEnabler.add(getGuaranteeForm().pGetCardExpirationField());
	absMandEnabler.add(getPickupForm().pGetPickupLocationSelectionForm().pGetLocationTreeTable());

	ULCAndEnabler condMandEnabler= getConditionalMandatoryEnabler();
	condMandEnabler.add(getReturnForm().pGetReturnLocationSelectionForm().pGetLocationTreeTable());

	getOrEnabler().add(getReturnForm().pGetReturnSameAsPickupCheckBox());
	
}
/**
 * Set whether the views should open on test instances, rather than "blank" instances.
 *
 * Creation date: (25.01.00 15:50:20)
 * @param useTest boolean
 */
public static void setUseTestInstance(boolean useTest) {
	fgUseTestInstance= useTest;
}
/**
 * Callback: a switch to notebook page @requested has been requested.
 * Processing a callback from the UI will fire another one, but just once....
 *
 * Creation date: (11.01.00 22:18:39)
 * @param requested int
 */
protected void tabChangeRequest(int requested, ULCNotebook notebook) {
	if (requested != notebook.getActiveTab()) { //the event is being signalled from the UI
		alignUIAndULC();
//	com.ibm.uvm.tools.DebugSupport.inspect(fContractSpecFormModel.getContractSpec());
		getNotebook1().setActiveTab(requested);
		doPageDependentEnabling(requested);
	}
}
/**
 * Method to handle events for the IWindowListener interface.
 * @param windowEvent com.ibm.ulc.application.ULCWindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowActivated(com.ibm.ulc.application.ULCWindowEvent windowEvent) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the IWindowListener interface.
 * @param windowEvent com.ibm.ulc.application.ULCWindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosed(com.ibm.ulc.application.ULCWindowEvent windowEvent) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the IWindowListener interface.
 * @param windowEvent com.ibm.ulc.application.ULCWindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosing(com.ibm.ulc.application.ULCWindowEvent windowEvent) {
	// user code begin {1}
	// user code end
	if (windowEvent.getSource() == this) 
		connEtoC9(windowEvent);
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the IWindowListener interface.
 * @param windowEvent com.ibm.ulc.application.ULCWindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeactivated(com.ibm.ulc.application.ULCWindowEvent windowEvent) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the IWindowListener interface.
 * @param windowEvent com.ibm.ulc.application.ULCWindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowHidden(com.ibm.ulc.application.ULCWindowEvent windowEvent) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the IWindowListener interface.
 * @param windowEvent com.ibm.ulc.application.ULCWindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowMoved(com.ibm.ulc.application.ULCWindowEvent windowEvent) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the IWindowListener interface.
 * @param windowEvent com.ibm.ulc.application.ULCWindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowResized(com.ibm.ulc.application.ULCWindowEvent windowEvent) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
/**
 * Method to handle events for the IWindowListener interface.
 * @param windowEvent com.ibm.ulc.application.ULCWindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowShown(com.ibm.ulc.application.ULCWindowEvent windowEvent) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}
}
