package com.ibm.ulc.examples.carRental.model;

/**
 * Instances hold all the information about the (possible) reservation.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class ContractSpec extends PersistentObject {
	/**
	 * The available information about the customer.
	 */
	 protected CustomerSpec fCustomerSpec= new CustomerSpec();

	/**
	 * The details about the pickup.
	 */ 
	 protected ExchangeDate fPickupDetails= new ExchangeDate();

	/**
	 * The details about the return.
	 */ 
	 protected ExchangeDate fReturnDetails= new ExchangeDate();

	/**
	 * Are the pickup and the return locationthe same?. 
	 */ 
	 protected boolean fIsReturnSameAsPickup= true;
	 
	/**
	 * The specification of the desired car.
	 */ 
	 protected CarSpec fCarSpec= new CarSpec();
	 
	/**
	 * Optional equipment.
	 */ 
	 protected OptionsSpec fOptionsSpec= new OptionsSpec();
	 
	/**
	 * Credit card information.
	 */ 
	 protected Guarantee fGuarantee= new Guarantee();
	 
	/**
	 * The state of the receiver (Possible values below.)
	 */ 
	 protected char fState = INFORMATION_REQUEST;

	/**
	 * The instance is just an information request.
	 */
	 public static final char INFORMATION_REQUEST = 'i';
	/**
	 * The instance is committed by the user.
	 */
	 public static final char RESERVATION = 'r';
	 
/**
 * ContractSpec constructor comment.
 */
public ContractSpec() {
	super();
}
/**
 * ContractSpec constructor comment.
 * @param id java.lang.String
 */
public ContractSpec(String id) {
	super(id);
}
/**
 * Gets the carSpec property (com.ibm.ulc.examples.carRental.model.CarSpec) value.
 * @return The carSpec property value.
 * @see #setCarSpec
 */
public CarSpec getCarSpec() {
	return fCarSpec;
}
/**
 * Gets the customerSpec property (com.ibm.ulc.examples.carRental.model.CustomerSpec) value.
 * @return The customerSpec property value.
 * @see #setCustomerSpec
 */
public CustomerSpec getCustomerSpec() {
	return fCustomerSpec;
}
/**
 * Gets the guarantee property (com.ibm.ulc.examples.carRental.model.Guarantee) value.
 * @return The guarantee property value.
 * @see #setGuarantee
 */
public Guarantee getGuarantee() {
	return fGuarantee;
}
/**
 * Gets the isReturnSameAsPickup property (boolean) value.
 * @return The isReturnSameAsPickup property value.
 * @see #setIsReturnSameAsPickup
 */
public boolean getIsReturnSameAsPickup() {
	return fIsReturnSameAsPickup;
}
/**
 * Gets the optionsSpec property (com.ibm.ulc.examples.carRental.model.OptionsSpec) value.
 * @return The optionsSpec property value.
 * @see #setOptionsSpec
 */
public OptionsSpec getOptionsSpec() {
	return fOptionsSpec;
}
/**
 * Gets the pickupDetails property (com.ibm.ulc.examples.carRental.model.ExchangeDate) value.
 * @return The pickupDetails property value.
 * @see #setPickupDetails
 */
public ExchangeDate getPickupDetails() {
	return fPickupDetails;
}
/**
 * Answer the price of the contract.
 * 
 * Creation date: (27.12.99 13:45:01)
 * @return double
 */
public double getPrice() {
	return newPricer().getPrice();
}
/**
 * Answer the price of the contract per day.
 * 
 * Creation date: (27.12.99 13:45:01)
 * @return double
 */
public double getPricePerDay() {
	return newPricer().getPricePerDay();
}
/**
 * Answer the price of the contract per week.
 * 
 * Creation date: (27.12.99 13:45:01)
 * @return double
 */
public double getPricePerWeek() {
	return newPricer().getPricePerWeek();
}
/**
 * Gets the returnDetails property (com.ibm.ulc.examples.carRental.model.ExchangeDate) value.
 * @return The returnDetails property value.
 * @see #setReturnDetails
 */
public ExchangeDate getReturnDetails() {
	return fReturnDetails;
}
/**
 * Gets the state property (char) value.
 * @return The state property value.
 * @see #setState
 */
public char getState() {
	return fState;
}
/**
 * Answer whether the receiver has enough info about pickup.
 * Creation date: (07.01.00 11:18:58)
 * @return boolean
 */
public boolean hasPickupInfo() {
	return fPickupDetails.isComplete();
}
/**
 * Answer whether the receiver has enough info about return.
 * Creation date: (07.01.00 11:18:58)
 * @return boolean
 */
public boolean hasReturnInfo() {
	return fReturnDetails.isComplete();
}
/**
 * Resolve internal (apparent) inconsistencies, if any.
 * The receiver's 'isReturnSameAsPickup' attribute can be true,
 * while pickup and return locations are different. 
 * Align the two locations if 'isReturnSameAsPickup' requires so.
 *
 * Creation date: (11.01.00 14:46:34)
 */
public void makeConsistent() {
	if (fIsReturnSameAsPickup) {
		fReturnDetails.setLocation(fPickupDetails.getLocation());
	}
}
/**
 * Answer a fresh pricer instance.
 * 
 * Creation date: (27.12.99 13:40:15)
 * @return com.ibm.ulc.examples.carRental.model.Pricer
 */
protected Pricer newPricer() {
	return new Pricer(this);
}
/**
 * Sets the carSpec property (com.ibm.ulc.examples.carRental.model.CarSpec) value.
 * @param carSpec The new value for the property.
 * @see #getCarSpec
 */
public void setCarSpec(CarSpec carSpec) {
	fCarSpec = carSpec;
}
/**
 * Sets the customerSpec property (com.ibm.ulc.examples.carRental.model.CustomerSpec) value.
 * @param customerSpec The new value for the property.
 * @see #getCustomerSpec
 */
public void setCustomerSpec(CustomerSpec customerSpec) {
	fCustomerSpec = customerSpec;
}
/**
 * Sets the guarantee property (com.ibm.ulc.examples.carRental.model.Guarantee) value.
 * @param guarantee The new value for the property.
 * @see #getGuarantee
 */
public void setGuarantee(Guarantee guarantee) {
	fGuarantee = guarantee;
}
/**
 * Sets the isReturnSameAsPickup property (boolean) value.
 * @param isReturnSameAsPickup The new value for the property.
 * @see #getIsReturnSameAsPickup
 */
public void setIsReturnSameAsPickup(boolean isReturnSameAsPickup) {
	fIsReturnSameAsPickup = isReturnSameAsPickup;
}
/**
 * Sets the optionsSpec property (com.ibm.ulc.examples.carRental.model.OptionsSpec) value.
 * @param optionsSpec The new value for the property.
 * @see #getOptionsSpec
 */
public void setOptionsSpec(OptionsSpec optionsSpec) {
	fOptionsSpec = optionsSpec;
}
/**
 * Sets the pickupDetails property (com.ibm.ulc.examples.carRental.model.ExchangeDate) value.
 * @param pickupDetails The new value for the property.
 * @see #getPickupDetails
 */
public void setPickupDetails(ExchangeDate pickupDetails) {
	fPickupDetails = pickupDetails;
}
/**
 * Sets the returnDetails property (com.ibm.ulc.examples.carRental.model.ExchangeDate) value.
 * @param returnDetails The new value for the property.
 * @see #getReturnDetails
 */
public void setReturnDetails(ExchangeDate returnDetails) {
	fReturnDetails = returnDetails;
}
/**
 * Sets the state property (char) value.
 * @param state The new value for the property.
 * @see #getState
 */
public void setState(char state) {
	fState= state;
}
}
