package com.ibm.ulc.examples.Dossier;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.application.*;
import java.net.*;
import java.awt.event.*;

class Editor {
   static String fgTitles[]= { "Mrs.", "Mr.", "Dr.", "Prof.", "" };

	private ULCShell fShell;
	private ULCPagebook fActions= null;
	private Dossier fDossier= null;
Editor(ULCFormModel model, Dossier dossier) {
	fDossier = dossier;

	// set up a model for the combobox
	ULCStringTable st = new ULCStringTable(fgTitles);
	//st.preload("null");

	// create "save changes" button
	ULCButton saveButton = new ULCButton("Save Changes");
	saveButton.setEnabler(model);
	saveButton.setToolTipText("Commit all changes to the customer data base and close the dialog");
	saveButton.addActionListener(new SaveChangesAction(fDossier));

	// create "add customer" button
	ULCButton addButton = new ULCButton("Add New Customer");
	addButton.setEnabler(model);
	addButton.setToolTipText("Add a new customer to the customer data base");
	addButton.addActionListener(new AddAction(fDossier));

	// create the "cancel all changes" button"
	ULCButton cancelButton = new ULCButton("Cancel");
	cancelButton.setToolTipText("Cancel all changes");
	cancelButton.addActionListener(new HideShellAction(this));

	// the following pagebook allows us to switch between the two possible
	// configurations of the editor
	fActions = new ULCPagebook();
	fActions.addPage("Add", addButton, true);
	fActions.addPage("Save", saveButton, true);

	// put all buttons in a horizontal box
	ULCBox buttons = new ULCBox(1, 3);
	buttons.add(fActions);
	buttons.add(cancelButton);

	// the following widgets are all model-based

	//create a non editable mail field
	ULCField eMail = new ULCField(model, "EMail", 20);
	eMail.setEditable(false);

	// create a non readable password field
	ULCField password = new ULCField(model, "Password", 20);
	password.setPassword(true);

	// create the risk radio button group
	ULCBox choice = new ULCHBox();
	choice.add(new ULCRadioButton(model, "Risk", "High", "high"));
	choice.add(new ULCRadioButton(model, "Risk", "Low", "low"));
	// choice.add(new ULCCheckbox(model, "Risk"));

	// create a skill slider and percent field
	ULCBox skillElem = new ULCHBox();
	skillElem.add("ec", new ULCSlider(model, "Skill", 0, 100, true));
	skillElem.add("lc", new ULCField(model, "Skill", new ULCPercentValidator()));

	// create a field which can be made hidden based on
	// the value of another field
	ULCPagebook top = new ULCPagebook(model, "Class");
	top.addPage("public", choice, true);
	top.addPage("secret", new ULCLabel("classified"), true);
	ULCBox gb = new ULCHBox();
	gb.add(new ULCCheckbox(model, "Member"));
	gb.add(new ULCRadioButton(model, "Member", "yes", "true"));
	gb.add(new ULCRadioButton(model, "Member", "no", "false"));

	// now build the notebook pages
	// the name page
	ULCBox namebox = new ULCBox(0, 2);
	namebox.add(new ULCLabel("Last Name:"));
	namebox.add("ec", new ULCField(model, "LastName", 20));
	namebox.add(new ULCLabel("First Name:"));
	namebox.add("ec", new ULCField(model, "FirstName", 20));
	namebox.add(new ULCLabel("Title:"));
	namebox.add("lc", new ULCComboBox(model, "Title", st));
	namebox.add(new ULCLabel("Member:"));
	namebox.add("lc", gb);
	namebox.add(new ULCLabel("Risk Category:"));
	namebox.add("lc", top);
	namebox.add(new ULCLabel("Java Skills:"));
	namebox.add("ec", skillElem);
	ULCBorder name = new ULCBorder("Name", "ee");
	name.add(namebox);

	// the mail page
	ULCBox mail = new ULCBox(0, 2);
	mail.add(new ULCLabel("E-Mail:"));
	mail.add("ec", eMail);
	mail.add(new ULCLabel("Password:"));
	mail.add("ec", password);
	mail.add(new ULCLabel("Photo:"));
	mail.add("ec", new ULCLabel(model, "Icon"));

	// the address page
	ULCBox address = new ULCBox(0, 2);
	address.add(new ULCLabel("Street:"));
	address.add("ec", new ULCField(model, "Street", 20));
	ULCBox city = new ULCHBox();
	city.add("ec", new ULCField(model, "City", 10));
	city.add(new ULCField(model, "State", 2));
	city.add(new ULCField(model, "ZIP", 5));
	address.add(new ULCLabel("City,State,ZIP:"));
	address.add("ec", city);
	address.add(new ULCLabel("Country:"));
	address.add("ec", new ULCField(model, "Country", 20));



	// build the notebook
	ULCNotebook notebook = new ULCNotebook(false, 380, 240);
	notebook.addTab("Name", name);
	notebook.addTab("E-mail", mail);
	notebook.addTab("Address", address);
	notebook.addTab("Note", createNotePane(model));
	notebook.addTab("Split Pane", createSplitPane());
	notebook.addTab("Html Pane", createHtmlPane());

	// now make the overall layout
	fShell = new ULCShell("Details");
	//fShell.setResizable(false);

	ULCVBox vbox = new ULCVBox(10);
	fShell.add(vbox);
	vbox.add("ee", notebook);
	vbox.add(buttons);
}
private ULCComponent createHtmlPane() {
	ULCBox box1 = new ULCVBox();
	ULCBox hbox1 = new ULCHBox();
	String urlString = "http://www.oti.com";
	hbox1.add(new ULCLabel("URL: "));
	ULCField field = new ULCField(urlString,10);
	hbox1.add("ec", field);
	box1.add("ec", hbox1);
	ULCButton button = new ULCButton("Launch Using Browser Context");
	box1.add("ec", button);
	ULCHtmlPane htmlPane = new ULCHtmlPane("Html Pane");
	htmlPane.setVeto(true);
	try {
		URL u = new URL(urlString);
		htmlPane.setUrl(u);
	} catch (Exception e) {
		e.printStackTrace();
	}
	box1.add("ee", htmlPane);
	button.addActionListener(new SetPageAction(getBrowserContext(), field));
	field.addActionListener(new SetPageAction(htmlPane, field));
	htmlPane.addLinkActivatedListener(new SetPageAction(htmlPane, field));
	return box1;
}
private ULCComponent createNotePane(ULCFormModel model) {
	final ULCField note = new ULCField(model, "Note", 10, 30);
	note.setWordWrap(true);
	note.setLineWrap(true);
	ULCMenu m = new ULCMenu("PopUp");
	final ULCCheckboxMenuItem mi = new ULCCheckboxMenuItem("Enable Word Wrap");
	mi.setSelected(true);
	mi.addActionListener(new IActionListener() {
		public void actionPerformed(ULCActionEvent e) {
			note.setWordWrap(mi.isSelected());
		}
	});
	final ULCRadioButtonMenuItem rmi = new ULCRadioButtonMenuItem("Enable Line Wrap");
	rmi.setSelected(true);
	rmi.addActionListener(new IActionListener() {
		public void actionPerformed(ULCActionEvent e) {
			note.setLineWrap(rmi.isSelected());
		}
	});
	m.add(mi);
	m.add(rmi);
	note.setPopupMenu(m);
	return note;
}
private ULCComponent createSplitPane() {
	ULCBox box1 = new ULCVBox();
	box1.add(new ULCField(10));
	ULCCheckbox checkBox1 = new ULCCheckbox("Pane 1 Vertical", true);
	ULCCheckbox checkBox2 = new ULCCheckbox("Pane 2 Vertical", false);
	box1.add(checkBox1);
	box1.add(checkBox2);
	ULCBox box2 = new ULCHBox();
	box2.add(new ULCLabel("Field 1: "));
	box2.add(new ULCField(10));
	box2.add(new ULCLabel("Field 2: "));
	box2.add(new ULCField(10));
	ULCSplitPane nestedSplitPane = new ULCSplitPane(checkBox2.isSelected(), box1, new ULCField(10, 30));
	ULCSplitPane splitPane = new ULCSplitPane(checkBox1.isSelected(), nestedSplitPane, box2);
	checkBox1.addValueChangedListener(new SplitPaneToggleAction(splitPane, checkBox1));
	checkBox2.addValueChangedListener(new SplitPaneToggleAction(nestedSplitPane, checkBox2));
	splitPane.setDividerLocation(0.5);
	return splitPane;
}
private ULCBrowserContext getBrowserContext() {
	return new ULCBrowserContext(fDossier);
}
	ULCShell getShell() {
		return fShell;
	}
	void hide() {
		fShell.setVisible(false);
	}
	void show(String label) {
		fActions.setActivePage(label);
		fShell.setVisible(true);
	}
}
