package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;

/**
 * This is the business-specific application class, which interacts
 * with ULC only via a separate adapter class.
 */
public class Credit {
	private String fNumber;
	private String fType;
	private Account fAccount;
	private double fInterestRate;
	private Date fStartDate;
	private int fDuration;
	private double fInterestTillDate;
/**
 * By default, the credit start-date is always set to the
 * current date...
 */
public Credit() {
	fStartDate= new Date();
}
/**
 * In the current design, one credit can be given from only one
 * account. Of course, the converse is not true. That is, one
 * account can indeed be used for giving out multiple credits.
 */
 
public Credit (String number, String type, Account account) {
	this();
	fNumber= number;
	fType= type;
	setAccount(account);
}
/**
 * We need an 'initial' credit, which is a proper 
 * Credit object containing some dummy data (which 
 * can be edited by the user.
 */
 
public static Credit createInitialDummyCredit ( ) {
	Credit cr= new Credit("", "", Account.createInitialDummyAccount());
	return cr;
}
public static Vector createTestCredits(Vector accounts) {
/**
 * Create some test-instances which can be used for testing
 * out the application.
 *
 * @param 	accounts is the set of accounts from which these test-credits
 *				will be disbursed.
 */
 
	Vector credits= new Vector();
	for (int i= 0; i < accounts.size(); i++)
		credits.addElement(new Credit("CR1", "House Loan " + i, (Account)accounts.elementAt(i)));	
	return credits;
}
/**
 * Answer the value for the attribute corresponding
 * to the given column-Id. Note: This can also be
 * done using the reflection API.
 */
public Object getValueForAttributeName(String colId) {
	if (colId.equals("Number"))
		return fNumber;
	if (colId.equals("Type"))
		return fType;
	if (colId.equals("AccountNumber"))
		return fAccount.getNumber();
	if (colId.equals("InterestRate"))
		return new Double(fInterestRate);
	if (colId.equals("Duration"))
		return new Integer(fDuration);
	if (colId.equals("StartDate"))
		return fStartDate;
	if (colId.equals("InterestTillDate"))
		return new Double(fInterestTillDate);	
	return "";
}
/**
 * Setting the account to a credit, needs the additional task
 * of making sure that the account also holds on to this credit.
 */
public void setAccount (Account account) {
	fAccount= account;
	account.basicAddCredit(this);
}
}
