package com.ibm.ulc.corba;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */
import java.io.*;
import org.omg.CORBA.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.corba.generated.*;


/**
 * A default implemention for ULC transport server using Corba IIOP.
 * Creates UlcCorbaTransports for incoming connections.
 *
 * Override createServantFactory() and createTransport() if you want to
 * use different transports (e.g. for IIOP over SSL). Then put
 * your subclass names in the UlcTransport.properties file instead of
 * the default UlcCorbaTransport and UlcCorbaTransportServer.
 * Override publishServantFactoryIOR() if you want another way to publish
 * the servant factory object's IOR.
 *
 * @see UlcTransportServer
 * @see UlcCorbaTransport
 */
public class UlcCorbaTransportServer extends UlcTransportServer {
/**
 * UlcCorbaTransportServer constructor.
 */
public UlcCorbaTransportServer() {
	if (fDebug)
		System.out.println("UlcCorbaTransportServer().");
}
void createConnection(UlcCorbaTransport transport) {
	getCallingServer().createConnection(transport);
}
protected UlcCorbaServantFactory createServantFactory(int port) {
	// port is ignored (not standard Corba)
	return new UlcCorbaServantFactoryImpl(this);
}
protected UlcCorbaTransport createTransport(UlcCorbaObject sender, UlcCorbaServant receiver, String receiverIOR) {
	return new UlcCorbaTransport(sender,receiver,receiverIOR);
}
protected void publishServantFactoryIOR(String ior) {
	// Currently written as URL to file:
	// - as returned by Server.getServerUrlFileName() if not null
	// - ULCCorbaServerURL.txt in local directory otherwise
	int port= UlcConnection.getPortFromUrlString(getUrlString());
	String urlString=
		"iiop://" + UlcConnection.getLocalHost()
		+ ":" + port + "#" + ior;
	if (fDebug)
		System.out.println("Corba Server's URL: " + urlString);
	String fileName= Server.getServerUrlFileName();
	if (fileName == null)
		fileName= "ULCCorbaServerURL.txt";
	PrintWriter pw = null;
	try {
		pw = new PrintWriter(new FileOutputStream(new File(fileName)));
	}
	catch(IOException e) {
		System.out.println("Exception raised during creation of CORBA server URL file (" + fileName + "): " + e.toString()); 
		return; 
	}
	pw.print(urlString);
	pw.flush();
	pw.close();
}
public void start() throws UlcTransportException {

	// initialize
	ORB orb= UlcCorbaTransport.createOrbSingleton();

	// create factory servant
	UlcCorbaServantFactory factory = null;
	try {
		int port = UlcConnection.getPortFromUrlString(getUrlString());
		factory = createServantFactory(port);
		if (factory != null)
			orb.connect(factory);
	} catch (org.omg.CORBA.SystemException e) {
		System.out.println("Exception raised during creation of UlcCorbaServantFactoryImpl" + e.toString());
		return;
	}

	// Create IOR and publish it
	String ior = orb.object_to_string(factory);
	publishServantFactoryIOR(ior);
	//
	// Hack to find out if we are running in the JDK ORB
	// for some reason the JDK ORB requires a thread.join for the server
	// to run correctly. The ORBIX orb does not require this.
	//
	if (orb.getClass().getName().toString().startsWith("com.sun.CORBA.iiop")) {
		try {
			Thread.currentThread().join();
		} catch (InterruptedException e) {
			System.out.println("Exception raised while waiting for ORB requests on server" + e.toString());
			return;
		}
	}
}
}
