package com.ibm.ulc.comm;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */
import java.util.*;
import com.ibm.ulc.base.IDefaults;

/**
 * An abstraction for ULC transport servers.
 */
public abstract class UlcTransportServer implements IDefaults {
	
	public static boolean fgDebug= false;
	private Server fCallingServer= null;

	protected boolean fDebug= false;
	
	/* Adressing */
	private String fUrlString= null;
	// caches for URL content:
	private String fUrlHost= null;
	private int fUrlPort= UlcConnection.INVALIDPORT;
	private String fUrlFile= null;
	private String fUrlReference= null;
/**
 * UlcTransportServer constructor.
 */
public UlcTransportServer() {
	fDebug= fgDebug;
}
/**
 * The factory method to create a concrete transport server
 * depending on the protocol specified in the URL. The name of
 * the concrete server class is read in from the
 * UlcTransport property file.
 */
public static UlcTransportServer create(String urlString, Server caller) throws UlcTransportException {
	UlcTransportServer server = null;
	String serverClass = null;
	String protocol = UlcConnection.getProtocolFromUrlString(urlString);
	Properties prop = UlcTransport.getProperties();

	// get class name of concrete transport server for desired protocol
	serverClass = prop.getProperty("UlcTransportServer.classForProtocol." + protocol);
	if (serverClass != null) { // to be dynamically created
		try {
			Class cl = Class.forName(serverClass);
			if (cl != null) {
				server = (UlcTransportServer) cl.newInstance();
				server.setUrlString(urlString);
				server.setCallingServer(caller);
			}
			else {
				String msg = "UlcTransportServer.create(): could not find " + serverClass;
				if (fgDebug)
					System.out.println(msg);
				UlcTransportException ex = new UlcTransportException(msg, TRANSPORT_EX_INIT_CONNECTION_EXCEPTION, (Exception) null);
				throw ex;
			}
		}
		catch (ClassNotFoundException e) {
			if (fgDebug)
				System.out.println("UlcTransportSerevr.create(): ClassNotFoundException for " + serverClass + " - " + e.toString());
			UlcTransportException ex = new UlcTransportException(TRANSPORT_EX_INIT_CONNECTION_EXCEPTION, e);
			throw ex;
		}
		catch (InstantiationException e) {
			if (fgDebug)
				System.out.println("UlcTransportServer.create(): InstantiationException for " + serverClass + " - " + e.toString());
			UlcTransportException ex = new UlcTransportException(TRANSPORT_EX_INIT_CONNECTION_EXCEPTION, e);
			throw ex;
		}
		catch (IllegalAccessException e) {
			if (fgDebug)
				System.out.println("UlcTransportServer.create(): IllegalAccessException for " + serverClass + " - " + e.toString());
			UlcTransportException ex = new UlcTransportException(TRANSPORT_EX_INIT_CONNECTION_EXCEPTION, e);
			throw ex;
		}
		catch (ClassCastException e) {
			if (fgDebug)
				System.out.println("UlcTransportServer.create(): ClassCastException for " + serverClass + " - " + e.toString());
			UlcTransportException ex = new UlcTransportException(TRANSPORT_EX_INIT_CONNECTION_EXCEPTION, e);
			throw ex;
		}
	}
	return server;
}
protected Server getCallingServer() {
	return fCallingServer;
}
protected String getUrlString() {
	return fUrlString;
}
/**
 * Is logging of debug information enabled?
 */
public boolean isDebugModeOn() {
	return fDebug;
}
private void setCallingServer(Server caller) {
	fCallingServer= caller;
}
private void setUrlString(String urlString) {
	fUrlString= urlString;
}
public abstract void start() throws UlcTransportException;
public void stop() throws UlcTransportException {
}
}
