package com.ibm.ulc.comm;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */
import java.io.*;
import java.net.*;
import com.ibm.ulc.util.DebugThread;


/**
 * A default implemention for ULC transport server using sockets.
 * Creates UlcSocketTransports for incoming connections.
 *
 * Override createServerSocket() and createTransport() if you want to
 * use subclasses of Socket and ServerSocket (e.g. for SSL). Then put
 * your subclass names in the UlcTransport.properties file instead of
 * the default UlcSocketTransport and UlcSocketTransportServer.
 *
 * @see UlcTransportServer
 * @see UlcSocketTransport
 */
public class UlcSocketTransportServer
extends UlcTransportServer implements Runnable {
	private int fPort= 0;
	private ServerSocket fServerSocket= null;
/**
 * UlcSocketTransportServer constructor.
 */
public UlcSocketTransportServer() {
	if (fDebug)
		System.out.println("UlcSocketTransportServer().");
}
protected ServerSocket createServerSocket(int port) throws IOException {
/*
 Once the SocketFactory stuff has been deprecated we can use the following code:
 -------------------------------------------------------------------------------
	return new ServerSocket(port);
*/

	return Server.getSocketFactory().createServerSocket(getCallingServer(),port);
}
protected UlcTransport createTransport(Socket socket) {
	return new UlcSocketTransport(socket);
}
/**
 * Runs the server and starts accepting connections.
 */
public void run() {
	System.out.println(getCallingServer().getStartedString() + fPort);
	while (fServerSocket != null) {
		Socket socket = null;
		try {
			socket = fServerSocket.accept();
		} catch (IOException e) {
			if (fDebug) {
				System.out.println("UlcSocketTransportServer.run(). could not accept incoming connection...");
				e.printStackTrace();
			}
		}
		if (socket != null) {
			if (fDebug)
				System.out.println("accepted connection on " + socket.getPort());
			UlcTransport transport = createTransport(socket);
			getCallingServer().createConnection(transport);
		}
	}
}
public void start() throws UlcTransportException {
	String urlString= getUrlString();
	fPort= UlcConnection.getPortFromUrlString(urlString);
	try {
		fServerSocket= createServerSocket(fPort);
	} catch (IOException e) {
		if (fDebug)
			System.out.println("UlcSocketTransportServer.start(). Cannot create Server Socket!");
		UlcTransportException ex=
			new UlcTransportException(TRANSPORT_EX_INIT_SERVER_EXCEPTION,e);
		throw ex;
	}
	if (fServerSocket == null) {
		String msg= "Created Server Socket was null!";
		if (fDebug)
			System.out.println("UlcSocketTransportServer.start(). " + msg);
		UlcTransportException ex=
			new UlcTransportException(msg,TRANSPORT_EX_INIT_SERVER_EXCEPTION,(Exception)null);
		throw ex;
	}
		
	Thread t=
		new DebugThread(this,getCallingServer().getName() + " listener");
	t.start();
}
public void stop() throws UlcTransportException {
	if (fServerSocket != null) {
		try {
			fServerSocket.close();
			fServerSocket = null;
		} catch (Exception e) {
			throw new UlcTransportException(TRANSPORT_EX_UNKNOWN_REASON, e);
		}
	}
}
}
