package com.ibm.ulc.comm;

/*
 * (c) Object Technology International 1998.
 */
/**
  * Implement this interface when you want to filter message traffic between the
  * UI and the ULC application at the Request level.
  */
public interface IRequestFilter {
/*
 * (c) Object Technology International 1998.
 */
/**
 * Return the Request to be processed or null if the request should not be processed.
 * This method should be implemented by the developer when the intention is 
 * to intercept the request just before the Request is posted into the
 * requestProcessor for execution.
 * If this method returns null then the request is not posted otherwise the Request
 * returned by this method will be posted into the requestProcessor.
 * 
 * @param conn 		com.ibm.ulc.comm.UlcConnection
 * @param request 	com.ibm.ulc.comm.Request
 *
 * @return 			com.ibm.ulc.comm.Request  or null
 */
public com.ibm.ulc.comm.Request filterReceive(com.ibm.ulc.comm.UlcConnection conn, com.ibm.ulc.comm.Request request);
/*
 * (c) Object Technology International 1998.
 */
/**
 * Return the Request to be sent  or null if the request should not be sent.
 * This method should be implemented by the developer when the intention is 
 * to intercept the request just before the Request is converted into bytes to
 * be sent by the configured Transport.
 * If this method returns null then the request is not sent otherwise the Request
 * returned by this method will be sent using the the configured Transport
 * 
 * @param conn 		com.ibm.ulc.comm.UlcConnection
 * @param request 	com.ibm.ulc.comm.Request
 *
 * @return 			com.ibm.ulc.comm.Request  or null
 */
public com.ibm.ulc.comm.Request filterSend(com.ibm.ulc.comm.UlcConnection conn, com.ibm.ulc.comm.Request request);
}
