package com.ibm.ulc.comm;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;

/**
 * Interface for dispatching or handling a request. There is an object space
 * per connection and a request is therefore executed in the context of a
 * connection.
 *
 * @see ORBConnection
 */
public interface ICallable {
	/**
	 * Frees this object. This is called when an object's object space
	 * is disposed.
	 */
	public void free();
/**
 * Returns the registered id for this proxy or -1 if unregistered
 */
public int getId();
/**
 * The Proxy has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args);
}
