package com.ibm.ulc.application;

import com.ibm.ulc.application.*;
import java.util.*;
/**
 * This is the abstract class for Composite ULC visually generated beans. 
 */
abstract public class ULCVajComposite extends ULCComposite implements IUsesVajContext {
	protected ULCVajContext fVajContext = null;
/**
 * UlcVajComposite constructor comment.
 */
public ULCVajComposite() {
	super();
}
/**
 * UlcVajComposite constructor comment.
 */
public ULCVajComposite(IUsesVajContext usesVajContext) {
	super();
	if (usesVajContext != null)
		fVajContext = usesVajContext.getVajContext();
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	super.free();
	fVajContext = null;
}
/**
 * Get the application from the context.
 */
public ULCApplication getApplication() {
	com.ibm.ulc.util.Assert.isNotNull(fVajContext);
	return fVajContext.getApplication();
}
/**
 * Gets the resource bundle for the filename passed in, using the current locale.
 * It passes it on to the UlcVajContext for this composite.
 *
 * @param bundle <code>String</code> bundle filename.
 * @return <code>ResourceBundle</code>
 * @see ULCContext#getResourceLocale
 */
public ResourceBundle getResourceBundle(String bundleFilename) {
	com.ibm.ulc.util.Assert.isNotNull(fVajContext);
	return fVajContext.getResourceBundle(bundleFilename);
}
/**
 * Answer the context for this bean.
 */
public ULCVajContext getVajContext() {
	com.ibm.ulc.util.Assert.isNotNull(fVajContext);
	return fVajContext;
}
/**
 * @deprecated This new method is now a private method generated when needed.
 */
protected void initializeNls() {
}
/**
 * The component that will be sent up in my place.
 */
protected void setComponent(ULCComponent component) {
	fComponent = component;
}
/**
 * @deprecated No longer needed because ctor does it now.
 * @param newFVajContext com.ibm.ulc.varun.ULCVajContext
 */
protected void setVajContext(ULCVajContext newVajContext) {
	fVajContext = newVajContext;
}
}
