package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * Implements the event that is sent when an error occurs in an ULCProgramStarter.
 *
 * @see		ULCProgramStarter
 * @since	R3.1
 */
public class ULCProgramStarterErrorEvent extends ULCEvent {
	/**
	 * The method called on program starter (exec/start), causing the error on the UI side.
	 * @serial
	 * @since	R3.1
	 */
	protected String fMethod= null;

	/**
	 * The command line which caused the error on the UI side.
	 * @serial
	 * @since	R3.1
	 */
	protected String fCommandLine= null;

	/**
	 * The error on the UI side.	 	 
	 * @serial
	 * @since	R3.1	 
	 */
	protected String fError= null;
/**
 * Contruct an ULCLinkErrorEvent with the specified source and URL and error string.
 *
 * @param	source 		The <code>Object</code> that generated this event.
 * @param	method		The method (exec or start) as a <code>String</code>.
 * @param	commandLine	The commandLine as a <code>String</code>.
 * @param	error		The error that occurred in the UI as <code>String</code>.
 * @since	R3.1
 */
ULCProgramStarterErrorEvent(Object source, String method, String commandLine, String error) {
	super(source);
	fCommandLine= commandLine;
	fMethod= method;
	fError= error;
}
/**
 * Dispatch this event to the specified object if it implements the
 * <code>IProgramStarterErrorListener</code> interface.
 *
 * @param	listener	The object interested in my link activation events.
 * @since	R3.1
 */
public void dispatch(IListener listener) {
	if (listener instanceof IProgramStarterErrorListener) {
		IProgramStarterErrorListener l = (IProgramStarterErrorListener) listener;
		l.programStarterError(this);
	}
}
/**
 * Return the command line
 *
 * @return The URL as a <code>String </code>.
 */
public String getCommandLineString() {
	return fCommandLine;
}
/**
 * Return the error
 *
 * @return	The error as a <code>String </code>.
 * @since	R3.1
 */
public String getErrorString() {
	return fError;
}
/**
 * Return the program starter method (exec/start)
 *
 * @return	The method name (exec/start) as a <code>String </code>.
 * @since	R3.1
 */
public String getMethodString() {
	return fMethod;
}
}
