package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * An implementation of a CheckBox -- an item that can be selected or deselected,
 * and which displays its state to the user.
 */
public class ULCCheckbox extends ULCToggleButton {
/**
 * Construct a checkbox with its selected state set to false.
 */
public ULCCheckbox() {
	super("", false);
}
/**
 * Constructor for a checkbox which tracks the state of the 
 * specified (boolean) attribute of the given FormModel.
 *
 * @param formModel 		The model that will acts as the data source
 * @param formAttributeName	The attribute of the model that will be interpreted as a boolean.
 */
public ULCCheckbox(IForm formModel, String formAttributeName) {
	super(formModel, formAttributeName, "");
}
/**
 * Constructor for a checkbox which tracks the state of the 
 * specified (boolean) attribute of the given FormModel.
 *
 * @param formModel 		The model that will acts as the data source
 * @param formAttributeName	The attribute of the model that will be interpreted as a boolean.
 * @param label				The label for this Checkbox.
 */
public ULCCheckbox(IForm formModel, String formAttributeName, String label) {
	super(formModel, formAttributeName, label);
}
/**
 * Construct a CheckBox with the given label.
 *
 * @param label The string to be displayed 
 */
public ULCCheckbox(String label) {
	super(label, false);
}
/**
 * Construct a CheckBox with the given label and the specified initial state.
 * On state changes the given listener is notified.
 *
 * @param label 	The string to be displayed 
 * @param listener 	The widget interested in my value changes
 * @param state		The initial selection state
 */
public ULCCheckbox(String label, IValueChangedListener listener, boolean state) {
	super(label, listener, state);
}
/**
 * Construct a CheckBox with the given label and the specified initial state.
 *
 * @param label The string to be displayed 
 * @param state	The initial selection state
 */
public ULCCheckbox(String label, boolean state) {
	super(label, state);
}
}
