package com.ibm.ulc.application;

import java.util.Vector;
import java.lang.reflect.*;
import com.ibm.ulc.util.*;
/**
 * ULCAdapter is the root of the hierarchy of adapters used for adapting ULC list
 * elements (e.g. rows in a table) onto the business objects providing the required
 * data.
 *
 * Note: Since this class uses reflection performance can be an issue for large collections.
 */
abstract public class ULCAdapter extends UlcObject {
	/**
	 * For performance reasons we cache each method that has been invoked
	 */
	static private UlcHashtable fgMethodCache = new UlcHashtable();
/**
 * Construct a new instance of the receiver.
 */
public ULCAdapter() {
	super();
}
/**
 * Answer the receiver's methodCache for the specified class name
 */
static protected UlcHashtable getMethodCache(String className) {
	Object found = fgMethodCache.get(className);
	UlcHashtable answer;
	if (found == null) {
		answer = new UlcHashtable();
		fgMethodCache.put(className, answer);
	}
	else {
		answer = (UlcHashtable) found;
	}
	return answer;
}
}
