package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * This interface is used for listening to the events triggered
 * by various ULC widgets. The <code>actionPerformed(ULCActionEvent)</code> method must be overidden
 * for initiating the appropriate action on this event.
 *
 * @see ULCButton#addActionListener(IActionListener)
 * 		which registers this interface for the given button.
 * @see ULCActionEvent  
 *		The type of event which this listener listens to.
 */
public interface IActionListener extends IListener {
/**
 * Notification of a action being performed in the UI.
 * This event will be received only if an actionListener has been registered.
 *
 * @param actionEvent ULCActionEvent
 * @see ULCButton#addActionListener
 */
void actionPerformed(ULCActionEvent actionEvent);
}
