/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ulc.HttpServer;

import com.ibm.ulc.HttpServer.HttpConnection;
import com.ibm.ulc.comm.Server;
import com.ibm.ulc.comm.UlcSocketTransport;
import com.ibm.ulc.comm.UlcTransport;
import com.ibm.ulc.util.UlcConsole;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Properties;

public class HttpServer
extends Server {
    static final String FILESEP = System.getProperty("file.separator");
    public static boolean fgDebug = false;
    public static Properties fgProperties = new Properties();
    public static String fgDocumentRoot = null;
    private static boolean fgCaseWarning = false;
    private static boolean fgEmulateUnix = false;
    private static boolean fgNoResources = false;
    public boolean fDebug = false;
    static /* synthetic */ Class class$com$ibm$ulc$HttpServer$HttpServer;

    public HttpServer(String[] stringArray) {
        super("ULC HttpServer");
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-") && stringArray[n].equals("-debug")) {
                this.fDebug = true;
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void createConnection(UlcTransport ulcTransport) {
        Socket socket;
        if (ulcTransport instanceof UlcSocketTransport && (socket = ((UlcSocketTransport)ulcTransport).getSocket()) != null) {
            new HttpConnection(socket, this);
        }
    }

    protected void createConnection(Socket socket) {
        new HttpConnection(socket, this);
    }

    public static InputStream getDocumentRootResourceStream(String string) {
        if (fgDebug) {
            System.out.println("getDocumentRootResourceStream: " + string);
        }
        BufferedInputStream bufferedInputStream = null;
        if (fgDocumentRoot != null) {
            File file = new File(String.valueOf(fgDocumentRoot) + FILESEP + string);
            try {
                if (file.getCanonicalPath().toLowerCase().startsWith(fgDocumentRoot.toLowerCase())) {
                    if (!file.getCanonicalPath().endsWith(new File(string).getPath())) {
                        if (HttpServer.isCaseWarningActivated()) {
                            System.out.println("HttpServer case-sensitive WARNING: " + string + " should be: " + file.getCanonicalPath());
                        }
                        if (!HttpServer.isUnixEmulationActivated()) {
                            bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getCanonicalPath()));
                        }
                    } else {
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getCanonicalPath()));
                    }
                } else {
                    System.out.println("HttpServer WARNING: Access to file higher than document root requested: DENIED");
                }
            }
            catch (IOException iOException) {}
        }
        if (bufferedInputStream == null && fgDebug) {
            System.out.println("--- not found via document root");
        }
        return bufferedInputStream;
    }

    public static InputStream getResourceStream(String string) {
        InputStream inputStream;
        if (fgDebug) {
            System.out.println("getResourceStream: " + string);
        }
        if ((inputStream = (class$com$ibm$ulc$HttpServer$HttpServer != null ? class$com$ibm$ulc$HttpServer$HttpServer : (class$com$ibm$ulc$HttpServer$HttpServer = HttpServer.class$("com.ibm.ulc.HttpServer.HttpServer"))).getResourceAsStream("resources/" + string)) != null) {
            return inputStream;
        }
        if (fgDebug) {
            System.out.println("--- not found in HttpServer's resources directory");
        }
        if ((inputStream = (class$com$ibm$ulc$HttpServer$HttpServer != null ? class$com$ibm$ulc$HttpServer$HttpServer : (class$com$ibm$ulc$HttpServer$HttpServer = HttpServer.class$("com.ibm.ulc.HttpServer.HttpServer"))).getResourceAsStream(string)) != null) {
            return inputStream;
        }
        if (fgDebug) {
            System.out.println("--- not found as normal resource");
        }
        if ((inputStream = (class$com$ibm$ulc$HttpServer$HttpServer != null ? class$com$ibm$ulc$HttpServer$HttpServer : (class$com$ibm$ulc$HttpServer$HttpServer = HttpServer.class$("com.ibm.ulc.HttpServer.HttpServer"))).getResourceAsStream("/" + string)) == null && fgDebug) {
            System.out.println("--- not found as absolute resource");
        }
        return inputStream;
    }

    public static InputStream getStreamFor(String string) {
        InputStream inputStream = HttpServer.getDocumentRootResourceStream(string);
        if (inputStream != null || !HttpServer.useResources()) {
            return inputStream;
        }
        inputStream = HttpServer.getResourceStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        inputStream = HttpServer.getSystemResourceStream(string);
        return inputStream;
    }

    public static InputStream getSystemResourceStream(String string) {
        if (fgDebug) {
            System.out.println("getSystemResourceStream: " + string);
        }
        (class$com$ibm$ulc$HttpServer$HttpServer != null ? class$com$ibm$ulc$HttpServer$HttpServer : (class$com$ibm$ulc$HttpServer$HttpServer = HttpServer.class$("com.ibm.ulc.HttpServer.HttpServer"))).getClassLoader();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        if (fgDebug) {
            System.out.println("--- not found as relative system resource");
        }
        (class$com$ibm$ulc$HttpServer$HttpServer != null ? class$com$ibm$ulc$HttpServer$HttpServer : (class$com$ibm$ulc$HttpServer$HttpServer = HttpServer.class$("com.ibm.ulc.HttpServer.HttpServer"))).getClassLoader();
        inputStream = ClassLoader.getSystemResourceAsStream("/" + string);
        if (inputStream == null & fgDebug) {
            System.out.println("--- not found as absolute system resource");
        }
        return inputStream;
    }

    public static boolean isCaseWarningActivated() {
        return fgCaseWarning;
    }

    public static boolean isUnixEmulationActivated() {
        return fgEmulateUnix;
    }

    public static void main(String[] stringArray) {
        Object object;
        HttpServer httpServer = new HttpServer(stringArray);
        fgDebug = httpServer.fDebug;
        int n = 80;
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith("-")) {
                if (stringArray[n2].equals("-wincon")) {
                    bl = true;
                } else if (stringArray[n2].equals("-caseWarning")) {
                    fgCaseWarning = true;
                } else if (stringArray[n2].equals("-unix")) {
                    fgEmulateUnix = true;
                } else if (stringArray[n2].equals("-noResources")) {
                    fgNoResources = true;
                } else if (stringArray[n2].equals("-debug")) {
                    fgDebug = true;
                } else {
                    System.out.println("HttpServer WARNING: Illegal option: " + stringArray[n2]);
                }
            } else {
                n = Integer.parseInt(stringArray[n2]);
            }
            ++n2;
        }
        if (bl) {
            UlcConsole.createConsole((String)"ULC HttpServer Console", (Point)new Point(10, 10));
        }
        try {
            object = (class$com$ibm$ulc$HttpServer$HttpServer != null ? class$com$ibm$ulc$HttpServer$HttpServer : (class$com$ibm$ulc$HttpServer$HttpServer = HttpServer.class$("com.ibm.ulc.HttpServer.HttpServer"))).getResourceAsStream("/HttpServer.properties");
            if (object == null) {
                System.out.println("HttpServer: cannot load properties!");
                System.exit(1);
            }
            fgProperties.load((InputStream)object);
        }
        catch (IOException iOException) {
            System.out.println("HttpServer: cannot load properties: " + iOException);
            System.exit(1);
        }
        try {
            object = fgProperties.getProperty("HttpServer.documentroot");
            if (object != null && ((String)object).length() > 0) {
                fgDocumentRoot = new File((String)object).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            System.out.println("HttpServer: cannot create document root path");
        }
        System.out.println("starting http server on port: " + n);
        if (httpServer.fDebug) {
            object = System.getSecurityManager();
            if (object == null) {
                System.out.println("no SecurityManager!");
            } else {
                System.out.println("SecurityManager installed!");
            }
            System.getProperties().list(System.out);
            System.out.println("user.dir = " + System.getProperty("user.dir"));
            System.out.println("java.class.path = " + System.getProperty("java.class.path"));
            HttpServer.test("uiengine.jar");
            HttpServer.test("start.html");
            HttpServer.test("UIApplet/UIApplet.class");
        }
        httpServer.start("ulc://localhost:" + n);
    }

    static void test(String string) {
        InputStream inputStream = null;
        Object var2_2 = null;
        System.out.println();
        System.out.println("***** " + string + ": ");
        inputStream = HttpServer.getDocumentRootResourceStream(string);
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            System.out.println("+++++ could open via document root");
        }
        if ((inputStream = HttpServer.getResourceStream(string)) != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            System.out.println("+++++ could open as resource");
        }
        if ((inputStream = HttpServer.getSystemResourceStream(string)) != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            System.out.println("+++++ could open as system resource");
        }
    }

    public static boolean useResources() {
        return fgNoResources ^ true;
    }
}

