#ifndef ESITRC_H
#define ESITRC_H

#include "escomp.h"

/* Execution Modes */
#define EsInsTrcModeCooked 0
#define EsInsTrcModeRaw 131072

/* Execution Types */
#define EsInsTrcTypeGCOff 0
#define EsInsTrcTypeExeOff 0
#define EsInsTrcTypeExeOnLight 1048576
#define EsInsTrcTypeExeOn 3145728
#define EsInsTrcTypeGCOnLight 4194304
#define EsInsTrcTypeGCOn 12582912

/* Event Flags */
#define EsInsTrcFlagClass 0
#define EsInsTrcFlagMetaclass 1

/* Events */
#define EsInsTrcEventMethodEnter 1
#define EsInsTrcEventMethodLeave 2
#define EsInsTrcEventBlockEnter 3
#define EsInsTrcEventBlockLeave 4
#define EsInsTrcEventOIDRename 5
#define EsInsTrcEventOIDRangeRename 6
#define EsInsTrcEventOIDDelete 7
#define EsInsTrcEventOIDRangeDelete 8
#define EsInsTrcEventScavengeStart 9
#define EsInsTrcEventScavengeEnd 10
#define EsInsTrcEventGGCStart 11
#define EsInsTrcEventGGCEnd 12
#define EsInsTrcEventUserEvent 21

/* Instrument tracing support routines */
U_32 VMCALL EsISupMethodDetails PROTOTYPE((struct ESVMContext *vmStruct, U_32 method, struct ESClass **methodClass, char **classSelector, U_32 *classSelectorLength, char **methodSelector, U_32 *methodSelectorLength));
U_32 VMCALL EsISupMethodClassSelector PROTOTYPE((struct ESVMContext *vmStruct, U_32 method, char **classSelector, U_32 *classSelectorLength));
U_32 VMCALL EsISupMethodSelector PROTOTYPE((struct ESVMContext *vmStruct, U_32 method, char **methodSelector, U_32 *methodSelectorLength));
U_32 VMCALL EsISupMethodClass PROTOTYPE((struct ESVMContext *vmStruct, U_32 method, struct ESClass **classObject));
U_32 VMCALL EsISupStartup PROTOTYPE((struct ESVMContext *vmStruct));

#endif /* ESITRC_H */
