
#ifndef escomp_h
#define escomp_h

/*
USE_PROTOTYPES:			Use full ANSI prototypes.

CLOCK_PRIMS:					We want the timer/clock prims to be used

LITTLE_ENDIAN:				This is for the intel machines or other
											little endian processors. Defaults to big endian.

NO_LVALUE_CASTING:	This is for compilers that don't like the left side
											of assigns to be cast.  It hacks around to do the
											right thing.

ATOMIC_FLOAT_ACCESS:	For the hp720 so that float operations will work.

LINKED_USER_PRIMITIVES:	Indicates that user primitives are statically linked
													with the VM executeable.

OLD_SPACE_SIZE_DIFF:	The 68k uses a different amount of old space.
											This "legitimizes" the change.

SIMPLE_SIGNAL:		For machines that don't use real signals in C.
									(eg: PC, 68k)

OS_NAME_LOOKUP:		Use nlist to lookup user primitive addresses.

VMCALL:			Tag for all functions called by the VM.

VMAPICALL:		Tag for all functions called via the PlatformFunction
							callWith: mechanism.
			
SYS_FLOAT:	For the MPW C compiler on MACintosh. Most of the math functions 
						there return extended type which has 80 or 96 bits depending on 68881 option.
						On All other platforms it is double

FLOAT_EXTENDED: If defined, the type name for extended precision floats.

PLATFORM_IS_ASCII: Must be defined if the platform is ASCII
PLATFORM_IS_IEEE_FLOAT: Must be defined if the platform uses IEEE floats

EXE_EXTENSION_CHAR: the executable has a delimiter that we want to stop at as part of argv[0].

*/

/* RS6000 */

/* The AIX platform has the define AIXPPC and RS6000,
	this means AIXPPC inherits from the RS6000.*/

#if defined(RS6000) || defined(OSOPEN)
#define I_64 long long
#define USE_PROTOTYPES
#define	NO_LVALUE_CASTING
#define U_32    unsigned int
#define U_16    unsigned short
#define U_8     unsigned char
#define	I_32	signed int
#define	I_16	signed short
#define	I_8	signed char
#define	BOOLEAN U_32
#define SYS_FLOAT double
#define	LINKED_USER_PRIMITIVES
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define PLATFORM_LINE_DELIMITER	"\012"
#define BREAK_HANDLER
#define CLOCK_PRIMS
#define SWAPPER
#define PROCESS_PRIMS
#define EMSRV
#define DECIMAL
#define DIR_SEPARATOR '/'
#endif

/* Sun3 non-ANSI compiler */

#ifdef SUN3
#define UNIX_CLOCK
#define	NO_LVALUE_CASTING
#define OS_NAME_LOOKUP
#define UNISTD_H_PRESENT
#define SYS_FLOAT double
#define	LINKED_USER_PRIMITIVES
#define PLATFORM_LINE_DELIMITER	"\012"
#define DIR_SEPARATOR '/'
#endif
 
/* Sparc non-ANSI compiler */

#ifdef SPARC
#define I_64 long long
#define UNIX_CLOCK
#define	NO_LVALUE_CASTING
#define OS_NAME_LOOKUP
#define UNISTD_H_PRESENT
#define SYS_FLOAT double
#define	LINKED_USER_PRIMITIVES
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define PLATFORM_LINE_DELIMITER	"\012"
#define BREAK_HANDLER
#define CLOCK_PRIMS
#define SWAPPER
#define PROCESS_PRIMS
#define EMSRV
#define DIR_SEPARATOR '/'
#endif 
/* Solaris ANSI compiler */

#ifdef SOLARIS
#define I_64 long long
#define USE_PROTOTYPES
#define UNIX_CLOCK
#define	NO_LVALUE_CASTING
#define OS_NAME_LOOKUP
#define UNISTD_H_PRESENT
#define SYS_FLOAT double
#define	LINKED_USER_PRIMITIVES
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define PLATFORM_LINE_DELIMITER	"\012"
#define BREAK_HANDLER
#define CLOCK_PRIMS
#define SWAPPER
#define PROCESS_PRIMS
#define EMSRV
#define DECIMAL
#define DIR_SEPARATOR '/'
#endif

/* HP720 ANSI compiler */

#ifdef HP720
#define I_64 long long
#define USE_PROTOTYPES
#define UNIX_CLOCK
#define BREAK_HANDLER
#define CLOCK_PRIMS
#define PROCESS_PRIMS
#define	NO_LVALUE_CASTING
#define	ATOMIC_FLOAT_ACCESS
#define OS_NAME_LOOKUP
#define UNISTD_H_PRESENT
#define SYS_FLOAT double
#define	LINKED_USER_PRIMITIVES
#define FLOAT_EXTENDED	long double
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define PLATFORM_LINE_DELIMITER	"\012"
#define EMSRV
#define DIR_SEPARATOR '/'
#endif

/* OS2 */

#ifdef OS2
#define USE_PROTOTYPES
#define	NO_LVALUE_CASTING
#define	LITTLE_ENDIAN
#define SIMPLE_SIGNAL
#define CLOCK_PRIMS
#define BREAK_HANDLER
#define OS2PM
#include "headers.h"
#define	VMCALL _Optlink
#define VMAPICALL _System
#define SYS_FLOAT double
#define FLOAT_EXTENDED	long double
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define EXE_EXTENSION_CHAR	'.'
#define DIR_SEPARATOR '\\'
typedef struct { unsigned long lo; unsigned long hi; } _os2_i64;
#define I_64 _os2_i64
#endif

/* POWEROS2 */

#ifdef POWEROS2
#define USE_PROTOTYPES
#define	NO_LVALUE_CASTING
#define	LITTLE_ENDIAN
#define SYS_FLOAT double
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define EXE_EXTENSION_CHAR	'.'
#define DIR_SEPARATOR '\\'
#endif

/* OS216 */

#ifdef	OS216
#define USE_PROTOTYPES
#define U_32    unsigned long
#define U_16    unsigned int
#define U_8     unsigned char
#define	I_32	long
#define	I_16	int
#define	I_8		char
#define	BOOLEAN	U_16
#define	LITTLE_ENDIAN
#define PASCAL _pascal
#define	VMAPICALL FAR _cdecl
#define	VMCALL
#define SYS_FLOAT double
#define	FLOAT_EXTENDED long double
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#endif

/* HighC for the 386 */

#ifdef HIGHC
#define	NO_LVALUE_CASTING
#define	LITTLE_ENDIAN
#define SIMPLE_SIGNAL
#define SYS_FLOAT double
#define	LINKED_USER_PRIMITIVES
#define DIR_SEPARATOR '\\'
#endif

/* DOS TTY, with Watcom C */

#ifdef DOS
#define USE_PROTOTYPES
#define	NO_LVALUE_CASTING
#define	LITTLE_ENDIAN
#define SIMPLE_SIGNAL
#define	LINKED_USER_PRIMITIVES
#define SYS_FLOAT double
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define BREAK_HANDLER
#define SWAPPER
#define CLOCK_PRIMS
#define DECIMAL 
#define EXE_EXTENSION_CHAR	'.'
#define DIR_SEPARATOR '\\'
#endif

/* QNX */

#ifdef QNX
#define LINKED_USER_PRIMITIVES
#define USE_PROTOTYPES
#define	NO_LVALUE_CASTING
#define	LITTLE_ENDIAN
#define SIMPLE_SIGNAL
#define SYS_FLOAT double
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define BREAK_HANDLER
#define PLATFORM_LINE_DELIMITER	"\012"
#define CLOCK_PRIMS
#define SWAPPER
#define DECIMAL 
#define DIR_SEPARATOR '/'
#endif

/* Win32 - Windows 3.1 & NT using Win32 */

#ifdef WIN32
#define I_64 __int64
#define USE_PROTOTYPES
#define BREAK_HANDLER
#define CLOCK_PRIMS
#define	NO_LVALUE_CASTING
#define	LITTLE_ENDIAN
#define SIMPLE_SIGNAL
#define	VMAPICALL _stdcall
#define	VMCALL _cdecl
#define SYS_FLOAT double
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define EXE_EXTENSION_CHAR	'.'
#define DIR_SEPARATOR '\\'
#endif

/* Modifications for the Alpha running WIN-NT */
#ifdef _ALPHA_
#undef small  /* defined as char in rpcndr.h */
#define FLOAT_EXTENDED double
#endif

/* WIN16 */

#ifdef	WIN16
#define USE_PROTOTYPES
#define U_32    unsigned long
#define U_16    unsigned int
#define U_8     unsigned char
#define	I_32	long
#define	I_16	int
#define	I_8		char
#define	BOOLEAN	U_16
#define	LITTLE_ENDIAN
#define	VMAPICALL FAR _cdecl
#define	VMCALL
#define SYS_FLOAT double
#define	FLOAT_EXTENDED long double
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#endif

/* InterMetrics compiler for the 68k */

#ifdef INTER
#define	NO_LVALUE_CASTING
#define SIMPLE_SIGNAL
#define OLD_SPACE_SIZE_DIFF
#define CLOCK_PRIMS
#define ACTRA_PRIMS
#define BABEL
#define SYS_FLOAT double
#define	LINKED_USER_PRIMITIVES
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#endif

/* Mac68K MPW compiler */

#ifdef MAC68K
#define	MAC
#define	NO_LVALUE_CASTING
#define SIMPLE_SIGNAL
#define CLOCK_PRIMS
#define USE_PROTOTYPES
#define SYS_FLOAT extended
#define FLOAT_EXTENDED	extended
#define	LINKED_USER_PRIMITIVES
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define PLATFORM_LINE_DELIMITER	"\015"
#define BREAK_HANDLER
#define EMSRV
#define SWAPPER
#define DECIMAL
#define DIR_SEPARATOR ':'
#endif

/* MacPPC MPW compiler */

#ifdef MACPPC
#define	MAC
#define	NO_LVALUE_CASTING
#define SIMPLE_SIGNAL
#define CLOCK_PRIMS
#define USE_PROTOTYPES
#define SYS_FLOAT extended
#define FLOAT_EXTENDED	extended
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define PLATFORM_LINE_DELIMITER	"\015"
#define BREAK_HANDLER
#define DIR_SEPARATOR ':'
#endif

/* MIPS */

#ifdef MIPS
#define USE_PROTOTYPES
#define SYS_FLOAT double 
#define LINKED_USER_PRIMITIVES
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define SWAPPER
#define EMSRV
#define CLOCK_PRIMS
#define BREAK_HANDLER
#define PROCESS_PRIMS
#define DIR_SEPARATOR '/' 
#endif
/* MVS compiler */

#ifdef MVS
#include "esmap.h"
#define	NO_LVALUE_CASTING
#define SIMPLE_SIGNAL
/* #define CLOCK_PRIMS  - removed JD - until clock tick available */
#define USE_PROTOTYPES
#define SYS_FLOAT double 
#define FLOAT_EXTENDED	long double
#define	LINKED_USER_PRIMITIVES
#define U_32	unsigned int
#define U_16	unsigned short
#define U_8	unsigned char
#define I_32	signed int
#define I_16	signed short
#define I_8	signed char
#define BOOLEAN	I_32
#define PLATFORM_LINE_DELIMITER	"\025"
#define DIR_SEPARATOR '.'
#endif

/* VXWorks */
#ifdef VXWORKS
#include <vxWorks.h>
#undef SPARC		/* vxworks defines SPARC and conflicts with our shared unix C source */
#define USE_PROTOTYPES
#define U_32	unsigned int
#define U_16	unsigned short
#define U_8		unsigned char
#define I_32	int
#define I_16	short
#define I_8		char
#define BOOLEAN	U_32
#define SYS_FLOAT	double
/* #define FLOAT_EXTENDED	long double
????*/
#define PLATFORM_IS_IEEE_FLOAT
#define PLATFORM_IS_ASCII
#define LINKED_USER_PRIMITIVES
#define PLATFORM_LINE_DELIMITER	"\012"
#define BREAK_HANDLER
#define CLOCK_PRIMS
#define DIR_SEPARATOR '/'
#ifdef VXL
#define	LITTLE_ENDIAN
#endif
#endif

/* Microtec compiler for the 68k */

#ifdef MICROTEC
#define USE_PROTOTYPES
#define NO_LVALUE_CASTING
#define SIMPLE_SIGNAL
#define OLD_SPACE_SIZE_DIFF
#define CLOCK_PRIMS
#define BREAK_HANDLER
#define SYS_FLOAT double
#define LINKED_USER_PRIMITIVES
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define ASYNCIO_PRIMS
#define PLATFORM_LINE_DELIMITER	"\012"
#define DIR_SEPARATOR '\\'
#endif



/* OS9 - Fastrak compiler for the 68k under OS9 */

#ifdef OS9
#define USE_PROTOTYPES
#define NO_LVALUE_CASTING
#define SIMPLE_SIGNAL
#define OLD_SPACE_SIZE_DIFF
#define CLOCK_PRIMS
#define BREAK_HANDLER
#define SYS_FLOAT double
#define LINKED_USER_PRIMITIVES
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#endif
/* Linux 386 ANSI compiler (gcc) */

#ifdef LINUX
#define USE_PROTOTYPES
#define UNIX_CLOCK
#define LITTLE_ENDIAN
#define BREAK_HANDLER
#define CLOCK_PRIMS
#define PROCESS_PRIMS
#define NO_LVALUE_CASTING
#define OS_NAME_LOOKUP
#define UNISTD_H_PRESENT
#define SYS_FLOAT double
#define LINKED_USER_PRIMITIVES
#define FLOAT_EXTENDED	long double
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define PLATFORM_LINE_DELIMITER	"\012"
#define EMSRV
#define DIR_SEPARATOR '/'
#endif

/* AS400 */

#ifdef AS400
#define class aClass		/* work around C++ compiler treating class specially */
#define USE_PROTOTYPES
#define	NO_LVALUE_CASTING
#define U_32    unsigned int			/* 64bits */
#define U_16    unsigned short
#define U_8     unsigned char
#define	I_32	signed int			/* 64bits */
#define	I_16	signed short
#define	I_8	signed char
#define	BOOLEAN U_32
#define SYS_FLOAT double
#define	LINKED_USER_PRIMITIVES
#define PLATFORM_IS_IEEE_FLOAT
#define PLATFORM_LINE_DELIMITER	"\012"
#define DIR_SEPARATOR '/'
#endif

/* PILOT MPW compiler */

#ifdef PILOT
#define	NO_LVALUE_CASTING
#define USE_PROTOTYPES
#define SYS_FLOAT	float
#define	LINKED_USER_PRIMITIVES
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define PLATFORM_LINE_DELIMITER	"\015"
#define DIR_SEPARATOR ':'
#endif

/* NEUTRINO */

#ifdef NEUTRINO
#define LINKED_USER_PRIMITIVES
#define USE_PROTOTYPES
#define	NO_LVALUE_CASTING
#define	LITTLE_ENDIAN
#define SIMPLE_SIGNAL
#define SYS_FLOAT double
#define PLATFORM_IS_ASCII
#define PLATFORM_IS_IEEE_FLOAT
#define BREAK_HANDLER
#define PLATFORM_LINE_DELIMITER	"\012"
#define CLOCK_PRIMS
#define SWAPPER
#define DECIMAL 
#define DIR_SEPARATOR '/'

#define UDATA		unsigned int
#define U_32			unsigned int
#define U_16			unsigned short
#define U_8				unsigned char

#define IDATA			int
#define I_32			int
#define I_16			short
#define I_8				signed char

#define BOOLEAN	UDATA

#endif


#ifndef	VMCALL
#define	VMCALL
#define	VMAPICALL
#endif

#ifndef	U_32
#define U_32    unsigned int
#define U_16    unsigned short
#define U_8     unsigned char
#define	I_32	int
#define	I_16	short
#define	I_8	char
#define BOOLEAN         U_32
#endif

#ifndef	FALSE
#define	FALSE		((BOOLEAN) 0)
#endif

#ifndef TRUE
#define	TRUE		((BOOLEAN) (!FALSE))
#endif

#ifndef NULL
#define NULL    ((void *)0)
#endif

#ifdef	USE_PROTOTYPES
#define	PROTOTYPE(x)	x
#define	VARARGS		, ...
#else
#define	PROTOTYPE(x)	()
#define	VARARGS
#endif

/* Macros for addressing the words in a long */

#ifdef	LITTLE_ENDIAN
#define	EsLowWord(l)	(*((U_16 *) &(l)))
#define	EsHighWord(l)	(*(((U_16 *) &(l)) + 1))
#else
#define	EsHighWord(l)	(*((U_16 *) &(l)))
#define	EsLowWord(l)	(*(((U_16 *) &(l)) + 1))
#endif

/* Assign the default line delimiter if it was not set */
#ifndef PLATFORM_LINE_DELIMITER
#define PLATFORM_LINE_DELIMITER	"\015\012"
#endif

/* Set the max path length if it was not set */
#ifndef MAX_IMAGE_PATH_LENGTH
#define MAX_IMAGE_PATH_LENGTH	(2048)
#endif

#endif /* escomp_h */

