
/*
 * NAME:        abt_emp_tdq.h - Monitoring TD Queue Format Definitions
 * VERSION:     1.0
 *
 * COPYRIGHT:                                                        
 * 
 *   (C) COPYRIGHT International Business Machines Corp. 1993, 1999
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *  
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 * 
 *                                                                   
 *
 *
 * DESCRIPTION: This header provides the data declarations required to
 *              access the Monitoring Transient Data Queue.
 */

#ifndef CICS_EMP_TDQ_H

#define CICS_EMP_TDQ_H                  /* prevent recursive inclusion  */



#include <cicstype.h>                   /* CICS-supplied datatypes      */

#if !defined(_ERZ_cics_emp_clk_h_LOCK_)
#define _ERZ_cics_emp_clk_h_LOCK_
#include <cics_emp_clk.h>               /* Monitoring clocks            */
#endif


/*
 * OBJECT: CICS_EMP_GROUP - Monitoring Record Field Group.
 */

#define CICS_EMP_GROUP_MASK   0xFF000000 /* See Mask in CICS_EMP_Map    */

enum CICS_EMP_GroupType
{
    CICS_EMP_GROUP_CICSCOMS = 0x01000000,
    CICS_EMP_GROUP_CICSCICS = 0x02000000,
    CICS_EMP_GROUP_CICSDEST = 0x03000000,
    CICS_EMP_GROUP_CICSFILE = 0x04000000,
    CICS_EMP_GROUP_CICSJOUR = 0x05000000,
    CICS_EMP_GROUP_CICSMAPP = 0x06000000,
    CICS_EMP_GROUP_CICSPROG = 0x07000000,
    CICS_EMP_GROUP_CICSSTOR = 0x08000000,
    CICS_EMP_GROUP_CICSSYNC = 0x09000000,
    CICS_EMP_GROUP_CICSTASK = 0x0A000000,
    CICS_EMP_GROUP_CICSTEMP = 0x0B000000,
    CICS_EMP_GROUP_CICSTERM = 0x0C000000,
    CICS_EMP_GROUP_CICSUSER = 0x0D000000
};

/*
 * OBJECT: CICS_EMP_TDQ_DetailType - Monitoring Record Field Type.
 */

#define CICS_EMP_TDQ_DETAIL_TYPE_MASK      0x00FF0000
    /* See Mask in CICS_EMP_Map */

enum CICS_EMP_TDQ_DetailType
{
     CICS_EMP_TDQ_DETAIL_TYPE_COUNTER    = 0x00010000,
     /* CICS_EMP_PerformanceClass          cics_ulong_t                       */
     /* TDQ                                cics_ulong_t                       */

     CICS_EMP_TDQ_DETAIL_TYPE_TIME_STAMP = 0x00020000,
     /* CICS_EMP_PerformanceClass          CICS_EMP_Time                      */
     /* TDQ                                CICS_EMP_Time                      */

     CICS_EMP_TDQ_DETAIL_TYPE_TIMER      = 0x00030000,
     /* CICS_EMP_PerformanceClass          CICS_EMP_EventTime                 */
     /* TDQ                                CICS_EMP_Clock                     */

     CICS_EMP_TDQ_DETAIL_TYPE_OCCUPANCY  = 0x00040000,
     /* CICS_EMP_PerformanceClass          CICS_EMP_Occupancy                 */
     /* TDQ                                cics_uxlong_t                      */

     CICS_EMP_TDQ_DETAIL_TYPE_STRING     = 0x00050000,
     /* CICS_EMP_PerformanceClass          cics_char_t                        */
     /* TDQ                                cics_char_t                        */

     CICS_EMP_TDQ_DETAIL_TYPE_ABEND_CODE = 0x00060000,
     /* CICS_EMP_PerformanceClass          cics_char_t                        */
     /* TDQ                                cics_char_t                        */

     CICS_EMP_TDQ_DETAIL_TYPE_HIGH_WATER = 0x00070000,
     /* CICS_EMP_PerformanceClass          CICS_EMP_HighWater                 */
     /* TDQ                                cics_ulong_t                       */

     CICS_EMP_TDQ_DETAIL_TYPE_OS_COUNT   = 0x00080000,
     /* CICS_EMP_PerformanceClass          CICS_EMP_OS_Count                  */
     /* TDQ                                cics_ulong_t                       */

     CICS_EMP_TDQ_DETAIL_TYPE_OS_CLOCK   = 0x00090000, /* CICS_EMP_OS_Clock   */
     /* CICS_EMP_PerformanceClass          CICS_EMP_OS_Clock                  */
     /* TDQ                                CICS_EMP_Time_t                    */

     CICS_EMP_TDQ_DETAIL_TYPE_USER       = 0x000A0000  /* User defined        */
};

/*
 * DESCRIPTION:
 * This enum describes the types of field in a monitoring record.
 */

/*
 * OBJECT: CICS_EMP_TDQ_DetailValue - A monitoring field value.
 */

#include "abt_emp.h"

union CICS_EMP_TDQ_DetailValue
{
    cics_ulong_t        Counter;
    CICS_EMP_Time_t     TimeStamp;
    CICS_EMP_Clock_t    Timer;
    cics_uxlong_t       Occupancy;
    cics_char_t         String[1];
    cics_char_t         AbendCode[CICS_EMP_ABEND_SIZE];
    cics_ulong_t		HighWater;
    cics_ulong_t		OsCount;
    CICS_EMP_Time_t		OsClock;
    struct CICS_EMP_Record	UserRecord;
};

/*
 * DESCRIPTION:
 * This union is used to hold a monitoring field in the appropriate value.
 * :ul.
 * :li.
 * :hp2.Counter:ehp2. - A counter.
 * :li.
 * :hp2.TimeStamp:ehp2. - A time stamp.
 * :li.
 * :hp2.Timer:ehp2. - A timer/clock.
 * :li.
 * :hp2.Occupancy:ehp2. - A memory occupancy value.
 * :li.
 * :hp2.String:ehp2. - A string.
 * :li.
 * :hp2.AbendCode:ehp2. - An abend code.
 * :eul.
 *
 * Added:
 *  HighWater - An integer.
 *  OsCount   - The Counter for the OS
 *  OsClock   - The OS Clock
 *  UserRecord - The ULM used in the user exit monitoring program
 */

/*
 * OBJECT: CICS_EMP_TDQ_RecordDetails - The description and value of a
 * monitoring field in a Performance/Exception record.
 */

struct CICS_EMP_TDQ_RecordDetails
{
    cics_ulong_t                        FieldID;
    cics_ulong_t                        FieldSize;
    enum CICS_EMP_TDQ_DetailType        Type;
    union CICS_EMP_TDQ_DetailValue      Value;
};

typedef struct CICS_EMP_TDQ_RecordDetails       CICS_EMP_TDQ_RecordDetails_t;

/*
 * DESCRIPTION:
 * This structure describes the individual fields in a monitoring record.
 * :ul.
 * :li.
 * :hp2.FieldID:ehp2. - This is the ID number of the value.
 *
 *
 * :li.
 * :hp2.FieldSize:ehp2. -  This is the size of the value (in bytes).  In
 * all cases exception string fields, this is the size of
 * :hp4.CICS_EMP_TDQ_DetailValue:ehp4. structure.  In the case of strings, this
 * field contains the length of the string, which is always even (having
 * been rounded by if necessary).
 * :li.
 * :hp2.Type:ehp2. - This is the type of the value.
 * :li.
 * :hp2.Value:ehp2. - The value itself.
 * :eul.
 */

/*
 * OBJECT: CICS_EMP_TDQ_MonitoringRecord - A Monitoring Record in the Transient
 * Data Queue.
 */

#define CICS_EMP_TDQ_SIGNATURE_LEN      8       /* Must be even         */

struct CICS_EMP_TDQ_MonitoringRecord
{
    size_t                              RecordLength;
    cics_char_t                         Signature[CICS_EMP_TDQ_SIGNATURE_LEN];
    CICS_EMP_TDQ_RecordDetails_t        Records[1];
};

#define CICS_EMP_TDQ_SIGNATURE          "ERZ50TDQ"

/*
 * DESCRIPTION:
 * This structure describes the structure of each record written to the
 * Monitoring Transient Data Queue.
 * :ul.
 * :li.
 * :hp2.RecordLength:ehp2. -  The length of the record (in bytes) including
 * the header field.
 * :li.
 * :hp2.Signature:ehp2. - The signature (defined by
 * :hp4.CICS_EMP_TDQ_SIGNATURE:ehp4.) to identify the record as a monitoring
 * record.
 * :li.
 * :hp2.Records:ehp2. -  The Self Describing fields in the record.
 * :eul.
 *
 * :note. Both this structure and the records in the structure are variable
 * length.
 */

/*
 * OBJECT: CICS_EMP_FID_* - Monitoring Field ID numbers
 */

#define CICS_EMP_FID_MASK               0x00000FFF
    /* See Mask in CICS_EMP_Map */

#define CICS_EMP_FID_USER_SPACE         0       /* ULM data             */
#define CICS_EMP_FID_TRANS_ID           1       /* Transaction ID       */
#define CICS_EMP_FID_TERM_ID            2       /* Terminal ID          */
#define CICS_EMP_FID_OPERATOR_ID        3       /* Operator ID          */
#define CICS_EMP_FID_TRANS_TYPE         4       /* Transaction Type     */
#define CICS_EMP_FID_START_TIME         5       /* Recording start time */
#define CICS_EMP_FID_STOP_TIME          6       /* Recording stop time  */
#define CICS_EMP_FID_TASK_ET            7       /* Elapsed time whilst  */
                                                /* task was executing   */
#define CICS_EMP_FID_TASK_UT            8       /* CPU time used by task */
#define CICS_EMP_FID_ET_TERM_IO         9       /* Elapsed time waiting */
                                                /* for Terminal I/O.    */
#define CICS_EMP_FID_ET_JOURNAL_IO      10      /* Elapsed time waiting */
                                                /* for Journal I/O      */
#define CICS_EMP_FID_ET_TS_IO           11      /* Elapsed time waiting */
                                                /* for Temporary        */
                                                /* Storage I/O          */
#define CICS_EMP_FID_ET_TERM_MGR        15      /* Elapsed time spent   */
                                                /* in Terminal Manager. */
#define CICS_EMP_FID_SUT_TERM_MGR       16      /* System time spent in */
                                                /* Terminal Manager.    */
#define CICS_EMP_FID_ET_TRANS_SCH       24      /* Elapsed time in      */
                                                /* Transaction scheduler.*/
#define CICS_EMP_FID_ET_SUSPENDED       27      /* Elapsed time during  */
                                                /* which voluntarily    */
                                                /* suspended.           */
#define CICS_EMP_FID_PAGE_COUNT         29      /* Non-IO Page fault    */
                                                /* count                */
#define CICS_EMP_FID_PAGE_IO_COUNT      30      /* IO Page fault count  */
#define CICS_EMP_FID_TCASEQ_NO          31      /* TCA Sequence number  */
#define CICS_EMP_FID_DSEGMENT_SIZE      33      /* Maximum Data Segment */
                                                /* size                 */
#define CICS_EMP_FID_PTF_MESS_IN        34      /* Primary Terminal     */
                                                /* Facility message in  */
                                                /* count                */
#define CICS_EMP_FID_PTF_MESS_OUT       35      /* Primary Terminal     */
                                                /* Facility message out */
                                                /* count                */
#define CICS_EMP_FID_FILE_GET           36      /* File GET count       */
#define CICS_EMP_FID_FILE_PUT           37      /* File PUT count       */
#define CICS_EMP_FID_FILE_BROWSE        38      /* File BROWSE count    */
#define CICS_EMP_FID_FILE_ADD           39      /* File ADD count       */
#define CICS_EMP_FID_FILE_DELETE        40      /* File DELETE count    */
#define CICS_EMP_FID_TD_GET             41      /* Transient Data GET   */
                                                /* count                */
#define CICS_EMP_FID_TD_PUT             42      /* Transient Data PUT   */
                                                /* count                */
#define CICS_EMP_FID_TD_PURGE           43      /* Transient Data PURGE */
                                                /* count                */
#define CICS_EMP_FID_TS_GET             44      /* Temporary Storage GET*/
                                                /* count                */
#define CICS_EMP_FID_TS_AUX_PUT         46      /* Auxiliary Temporary  */
                                                /* Storage PUT count    */
#define CICS_EMP_FID_TS_MAIN_PUT        47      /* Main Temporary       */
                                                /* Storage PUT count    */
#define CICS_EMP_FID_BMS_MAP            50      /* BMS MAP count        */
#define CICS_EMP_FID_BMS_IN             51      /* BMS IN count         */
#define CICS_EMP_FID_BMS_OUT            52      /* BMS OUT count        */
#define CICS_EMP_FID_GETMAIN_COUNT      54      /* GETMAIN requests     */
                                                /* count                */
#define CICS_EMP_FID_LINK               55      /* LINK requests count  */
#define CICS_EMP_FID_XCTL               56      /* XCTL requests count  */
#define CICS_EMP_FID_LOAD               57      /* LOAD requests count  */
#define CICS_EMP_FID_JOURNAL_OUT        58      /* Journal output       */
                                                /* requests count       */
#define CICS_EMP_FID_START_REQS         59      /* START/INITIATE       */
                                                /* requests count       */
#define CICS_EMP_FID_SYNCPOINT          60      /* SYNCPOINT requests   */
                                                /* count                */
#define CICS_EMP_FID_SWAP_COUNT         61      /* Swap Out count       */
#define CICS_EMP_FID_ET_FILE_IO         63      /* Elapsed time waiting */
                                                /* for File I/O         */
#define CICS_EMP_FID_TASK_FLAGS         64      /* Task Condition flags */
#define CICS_EMP_FID_ATF_MESS_IN        67      /* Alternate Terminal   */
                                                /* Facility message in  */
                                                /* count                */
#define CICS_EMP_FID_ATF_MESS_OUT       68      /* Alternate Terminal   */
                                                /* Facility message out */
                                                /* count                */
#define CICS_EMP_FID_PROGRAM            71      /* Program name         */
#define CICS_EMP_FID_PTF_CHARS_IN       83      /* Primary Terminal     */
                                                /* Facility characters  */
                                                /* in count             */
#define CICS_EMP_FID_PTF_CHARS_OUT      84      /* Primary Terminal     */
                                                /* Facility characters  */
                                                /* out count            */
#define CICS_EMP_FID_ATF_CHARS_IN       85      /* Alternate Terminal   */
                                                /* Facility characters  */
                                                /* in count             */
#define CICS_EMP_FID_ATF_CHARS_OUT      86      /* Alternate Terminal   */
                                                /* Facility characters  */
                                                /* out count            */
#define CICS_EMP_FID_TSEGMENT_SIZE      87      /* Maximum Text Segment */
                                                /* size                 */
#define CICS_EMP_FID_FREEMAIN_SIZE      88      /* Total memory released*/
#define CICS_EMP_FID_USER_ID            89      /* User ID              */
#define CICS_EMP_FID_BMS_TOTAL          90      /* Total BMS requests   */
#define CICS_EMP_FID_TD_TOTAL           91      /* Total Transient Data */
                                                /* requests             */
#define CICS_EMP_FID_TS_TOTAL           92      /* Total Temporary      */
                                                /* Storage requests     */
#define CICS_EMP_FID_FILE_TOTAL         93      /* Total File requests  */
#define CICS_EMP_FID_ET_COMPRESS        94      /* Elapsed time waiting */
                                                /* for memory to be     */
                                                /* released             */
#define CICS_EMP_FID_DSEG_OCCUPANCY     95      /* The Data Segment     */
                                                /* occupancy            */
#define CICS_EMP_FID_ET_CICSSPACE       96      /* Elapsed time in CICS */
                                                /* space                */
#define CICS_EMP_FID_NETWORK_NAME       97      /* Originating System   */
                                                /* or Local Terminal    */
                                                /* name                 */
#define CICS_EMP_FID_UOW_ID             98      /* The Unit of Work ID  */
#define CICS_EMP_FID_ET_TD_IO           101     /* Elapsed time waiting */
                                                /* for Transient Data IO*/
#define CICS_EMP_FID_ET_EXCEPTION       103     /* Elapsed time spent   */
                                                /* waiting for Temporary*/
                                                /* Storage space        */
                                                /* or Memory            */
#define CICS_EMP_FID_TSEG_OCCUPANCY     108     /* Text Segment         */
                                                /* occupancy            */
#define CICS_EMP_FID_TRANS_PRIOR        109     /* Transaction priority */
#define CICS_EMP_FID_RECORD_TYPE        112     /* Record Type          */
#define CICS_EMP_FID_FIRST_ABEND        113     /* First abend code     */
                                                /* recorded             */
#define CICS_EMP_FID_LATEST_ABEND       114     /* The most recent abend*/
                                                /* code                 */
#define CICS_EMP_FID_ET_PROG_LOAD       115     /* Elapsed time waiting */
                                                /* for program load     */
#define CICS_EMP_FID_ET_FILE_MGR        200     /* Elapsed time spent   */
                                                /* in Filemanager (SFS) */
#define CICS_EMP_FID_FREEMAIN_CNT       202     /* Total FREEMAIN       */
                                                /* requests             */
#define CICS_EMP_FID_GETMAIN_SIZE       203     /* Total memory obtained*/
                                                /* via GETMAIN requests */
#define CICS_EMP_FID_ET_PPC_SNA_LINK    207     /* Elapsed time waiting */
                                                /* on PPC/SNA link      */
#define CICS_EMP_FID_ET_TCP_LINK        208     /* Elapsed time waiting */
                                                /* on TCP/IP link       */
#define CICS_EMP_FID_ISCMESS_IN         209     /* ISC messages         */
                                                /* received count       */
#define CICS_EMP_FID_ISCMESS_OUT        210     /* ISC messages send    */
                                                /* count                */
#define CICS_EMP_FID_TASK_ST            211     /* Task CPU time        */
#define CICS_EMP_FID_CON_SWITCH         212     /* Voluntarily Context  */
                                                /* Switch count         */
#define CICS_EMP_FID_ICON_SWITCH        213     /* Involuntarily Context*/
                                                /* Switch count         */
#define CICS_EMP_FID_SIGNALS            214     /* Signals received     */
                                                /* count                */
#define CICS_EMP_FID_IO_ACTIONS         215     /* File system I/O      */
                                                /* actions count        */
#define CICS_EMP_FID_SUT_CICSSPACE      216     /* System/User time     */
                                                /* spent in CICS space  */
#define CICS_EMP_FID_ULM_TIME           217     /* Elapsed Time spent in*/
                                                /* monitoring ULM       */
#define CICS_EMP_FID_ET_LOCAL_SNA_LINK  218     /* Elapsed time waiting */
                                                /* on Local SNA link    */

/*
 * DESCRIPTION:
 * These macros define the Monitoring Field ID numbers for each field.
 */

#endif


