/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.imstoc;

import com.ibm.connector.ConnectionSpec;
import com.ibm.connector.imstoc.IMSLogonInfoItems;
import com.ibm.connector.imstoc.IMSLogonInfoResource;
import com.ibm.connector.infrastructure.LogonInfo;
import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.connector.internal.LogonInfoItems;
import java.io.PrintWriter;
import java.util.Hashtable;

public class IMSLogonInfo
implements LogonInfo {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    public static final byte MAX_LEN_IMS_PASSWORD = 8;
    public static final byte MAX_LEN_IMS_USERID = 8;
    public static final byte MAX_LEN_IMS_GROUP = 8;
    private Hashtable _table;
    private IMSLogonInfoResource _res = new IMSLogonInfoResource();

    public IMSLogonInfo() {
        this._table = new Hashtable();
    }

    public Object getGroup() {
        String methodName = String.valueOf(super.toString()) + ".getGroup()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        IMSLogonInfoItems lii = new IMSLogonInfoItems(this);
        return lii.getGroup();
    }

    public Object getItem(ConnectionSpec aConnectionSpec, String itemName) {
        String methodName = String.valueOf(super.toString()) + ".getItem(LogonInfoItems, String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._table.get(itemName);
    }

    public Object getItem(LogonInfoItems logonInfoItems, String itemName) {
        String methodName = String.valueOf(super.toString()) + ".getItem(LogonInfoItems, String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._table.get(itemName);
    }

    public String getPassword() {
        String methodName = String.valueOf(super.toString()) + ".getPassword()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        IMSLogonInfoItems lii = new IMSLogonInfoItems(this);
        return lii.getPassword();
    }

    public String getUser() {
        String methodName = String.valueOf(super.toString()) + ".getUser()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        IMSLogonInfoItems lii = new IMSLogonInfoItems(this);
        return lii.getUser();
    }

    public void setGroup(String aGroup) {
        String methodName = String.valueOf(super.toString()) + ".setGroup(String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        if (aGroup.length() > 8) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, new Integer(aGroup.length()), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        IMSLogonInfoItems lii = new IMSLogonInfoItems(this);
        lii.setGroup(aGroup);
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setItem(ConnectionSpec aConnectionSpec, String itemName, Object item) {
        String methodName = String.valueOf(super.toString()) + ".getItem(LogonInfoItems, String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        this._table.put(itemName, item);
    }

    public void setItem(LogonInfoItems logonInfoItems, String itemName, Object item) {
        String methodName = String.valueOf(super.toString()) + ".setItem(LogonInfoItems, String, Object)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        this._table.put(itemName, item);
    }

    public void setPassword(String aPassword) {
        String methodName = String.valueOf(super.toString()) + ".setPassword(String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        if (aPassword.length() > 8) {
            String errMsg = this._res.getString("0002E", new Object[]{methodName, new Integer(aPassword.length()), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        IMSLogonInfoItems lii = new IMSLogonInfoItems(this);
        lii.setPassword(aPassword);
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setUser(String aUser) {
        String methodName = String.valueOf(super.toString()) + ".setUser(String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        if (aUser.length() > 8) {
            String errMsg = this._res.getString("0003E", new Object[]{methodName, new Integer(aUser.length()), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        IMSLogonInfoItems lii = new IMSLogonInfoItems(this);
        lii.setUser(aUser);
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public String toString() {
        return "\t[" + super.toString() + "]" + "\n\t\t\t\tuserID: [" + this.getUser() + "]" + "\n\t\t\t\tpassword: [" + this.getPassword() + "]" + "\n\t\t\t\tgroup: [" + this.getGroup() + "]";
    }
}

