/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.imstoc;

import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.imstoc.IMSOTMAMsgProperties;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IMSUSDSeg
implements IMSOTMAMsgProperties {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private short dataLength;
    private byte[] ZZ;
    private byte[] destID;
    private byte[] origID;
    private byte[] portID;
    private byte[] LToken;
    private int retCode;
    private byte[] resCode;
    private int resToken;
    private byte[] password;
    private byte flag1;
    private byte flag2;
    private byte[] reserve;
    private byte[] filler;
    protected RuntimeContext _RuntimeContext = RuntimeContext.getCurrent();

    public IMSUSDSeg() {
        this.dataLength = this.sizeOfUSDSeg();
        this.ZZ = new byte[2];
        int i = 0;
        while (i < this.ZZ.length) {
            this.ZZ[i] = 0;
            ++i;
        }
        this.destID = new byte[8];
        i = 0;
        while (i < this.destID.length) {
            this.destID[i] = 64;
            ++i;
        }
        this.origID = new byte[8];
        i = 0;
        while (i < this.origID.length) {
            this.origID[i] = 64;
            ++i;
        }
        this.portID = new byte[8];
        i = 0;
        while (i < this.portID.length) {
            this.portID[i] = 0;
            ++i;
        }
        this.LToken = new byte[8];
        i = 0;
        while (i < this.LToken.length) {
            this.LToken[i] = 0;
            ++i;
        }
        this.retCode = 0;
        this.resCode = new byte[8];
        i = 0;
        while (i < this.resCode.length) {
            this.resCode[i] = 0;
            ++i;
        }
        this.resToken = 0;
        this.password = new byte[8];
        i = 0;
        while (i < this.password.length) {
            this.password[i] = 0;
            ++i;
        }
        this.flag1 = (byte)16;
        this.flag2 = 0;
        this.reserve = new byte[2];
        i = 0;
        while (i < this.reserve.length) {
            this.reserve[i] = 0;
            ++i;
        }
        this.filler = new byte[192];
        i = 0;
        while (i < this.filler.length) {
            this.filler[i] = 0;
            ++i;
        }
    }

    public byte[] export() throws IOException {
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        bos = new ByteArrayOutputStream();
        dos = new DataOutputStream(bos);
        byte[] newByteArray = null;
        String methodName = String.valueOf(super.toString()) + ".export()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        dos.writeShort(this.dataLength);
        int i = 0;
        while (i < this.ZZ.length) {
            dos.writeByte(this.ZZ[i]);
            ++i;
        }
        i = 0;
        while (i < this.destID.length) {
            dos.writeByte(this.destID[i]);
            ++i;
        }
        i = 0;
        while (i < this.origID.length) {
            dos.writeByte(this.origID[i]);
            ++i;
        }
        i = 0;
        while (i < this.portID.length) {
            dos.writeByte(this.portID[i]);
            ++i;
        }
        i = 0;
        while (i < this.LToken.length) {
            dos.writeByte(this.LToken[i]);
            ++i;
        }
        dos.writeInt(this.retCode);
        i = 0;
        while (i < this.resCode.length) {
            dos.writeByte(this.resCode[i]);
            ++i;
        }
        dos.writeInt(this.resToken);
        i = 0;
        while (i < this.password.length) {
            dos.writeByte(this.password[i]);
            ++i;
        }
        dos.writeByte(this.flag1);
        dos.writeByte(this.flag2);
        i = 0;
        while (i < this.reserve.length) {
            dos.writeByte(this.reserve[i]);
            ++i;
        }
        i = 0;
        while (i < this.filler.length) {
            dos.writeByte(this.filler[i]);
            ++i;
        }
        newByteArray = bos.toByteArray();
        return newByteArray;
    }

    public void setBitONFlag1(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONFlag1(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.flag1 = (byte)(this.flag1 | bitValue);
    }

    public void setBitONFlag2(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONFlag2(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.flag2 = (byte)(this.flag2 | bitValue);
    }

    public void setDestID(byte[] aDName) {
        String methodName = String.valueOf(super.toString()) + ".setDestID(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (aDName != null && aDName.length <= 8) {
            int i = 0;
            while (i < aDName.length) {
                this.destID[i] = aDName[i];
                ++i;
            }
        }
    }

    public void setOriginalID(byte[] aOrigID) {
        String methodName = String.valueOf(super.toString()) + ".setOriginalID(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (aOrigID != null && aOrigID.length <= 8) {
            int i = 0;
            while (i < aOrigID.length) {
                this.origID[i] = aOrigID[i];
                ++i;
            }
        }
    }

    public void setPassword(byte[] aPwd) {
        String methodName = String.valueOf(super.toString()) + ".setPassword(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (aPwd != null && aPwd.length <= 8) {
            int i = 0;
            while (i < aPwd.length) {
                this.password[i] = aPwd[i];
                ++i;
            }
        }
    }

    public short sizeOfUSDSeg() {
        short size = 0;
        String methodName = String.valueOf(super.toString()) + ".sizeOfUSDSeg()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        size = (short)(size + 2 + 2 + 8 + 8 + 8 + 8 + 4 + 8 + 4 + 8 + 1 + 1 + 2 + 192);
        return size;
    }

    public String toString() {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        byte[] newByteArray = null;
        String hexString = null;
        String retString = "0x";
        char[] h = new char[]{' ', ' '};
        String methodName = String.valueOf(super.toString()) + ".toString()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        try {
            newByteArray = this.export();
            int i = 0;
            while (i < newByteArray.length) {
                h[0] = hex[newByteArray[i] >> 4 & 0xF];
                h[1] = hex[newByteArray[i] & 0xF];
                hexString = new String(h);
                retString = String.valueOf(retString) + hexString;
                ++i;
            }
        }
        catch (IOException iOException) {}
        return retString;
    }
}

