/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.imstoc;

import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.imstoc.IMSOTMAMsgProperties;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IMSSECSeg
implements IMSOTMAMsgProperties {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private short dataLength;
    private byte secType;
    private byte secDataLength;
    private byte secUserIdLen;
    private byte secUserIdType;
    private byte[] secUserId;
    private byte secGroupIdLen;
    private byte secGroupIdType;
    private byte[] secGroupId;
    private byte[] filler;
    protected RuntimeContext _RuntimeContext = RuntimeContext.getCurrent();

    public IMSSECSeg() {
        this.dataLength = this.sizeOfSECSeg();
        this.secType = (byte)-58;
        this.secDataLength = (byte)20;
        this.secUserIdLen = (byte)9;
        this.secUserIdType = (byte)2;
        this.secUserId = new byte[8];
        int i = 0;
        while (i < this.secUserId.length) {
            this.secUserId[i] = 64;
            ++i;
        }
        this.secGroupIdLen = (byte)9;
        this.secGroupIdType = (byte)3;
        this.secGroupId = new byte[8];
        i = 0;
        while (i < this.secGroupId.length) {
            this.secGroupId[i] = 64;
            ++i;
        }
        this.filler = new byte[82];
        i = 0;
        while (i < this.filler.length) {
            this.filler[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.filler[i] = 0;
            ++i;
        }
    }

    public byte[] export() throws IOException {
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        bos = new ByteArrayOutputStream();
        dos = new DataOutputStream(bos);
        byte[] newByteArray = null;
        char[] cArray = new char[]{' ', ' '};
        String methodName = String.valueOf(super.toString()) + ".export()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        dos.writeShort(this.dataLength);
        dos.writeByte(this.secType);
        dos.writeByte(this.secDataLength);
        dos.writeByte(this.secUserIdLen);
        dos.writeByte(this.secUserIdType);
        int i = 0;
        while (i < this.secUserId.length) {
            dos.writeByte(this.secUserId[i]);
            ++i;
        }
        dos.writeByte(this.secGroupIdLen);
        dos.writeByte(this.secGroupIdType);
        i = 0;
        while (i < this.secGroupId.length) {
            dos.writeByte(this.secGroupId[i]);
            ++i;
        }
        i = 0;
        while (i < this.filler.length) {
            dos.writeByte(this.filler[i]);
            ++i;
        }
        newByteArray = bos.toByteArray();
        return newByteArray;
    }

    public void setSecGroupId(byte[] aGNM) {
        String methodName = String.valueOf(super.toString()) + ".setSecGroupId(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (aGNM != null && aGNM.length <= 8) {
            int i = 0;
            while (i < aGNM.length) {
                this.secGroupId[i] = aGNM[i];
                ++i;
            }
        }
    }

    public void setSecUserId(byte[] aUID) {
        String methodName = String.valueOf(super.toString()) + "setSecUserId(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (aUID != null && aUID.length <= 8) {
            int i = 0;
            while (i < aUID.length) {
                this.secUserId[i] = aUID[i];
                ++i;
            }
        }
    }

    public short sizeOfSECSeg() {
        short size = 0;
        String methodName = String.valueOf(super.toString()) + ".sizeOfSECSeg()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        size = (short)(size + 2 + 1 + 1 + 1 + 1 + 8 + 1 + 1 + 8 + 82);
        return size;
    }

    public String toString() {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        byte[] newByteArray = null;
        String hexString = null;
        String retString = "0x";
        char[] h = new char[]{' ', ' '};
        String methodName = String.valueOf(super.toString()) + ".toString()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        try {
            newByteArray = this.export();
            int i = 0;
            while (i < newByteArray.length) {
                h[0] = hex[newByteArray[i] >> 4 & 0xF];
                h[1] = hex[newByteArray[i] & 0xF];
                hexString = new String(h);
                retString = String.valueOf(retString) + hexString;
                ++i;
            }
        }
        catch (IOException iOException) {}
        return retString;
    }
}

