/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.imstoc;

import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.imstoc.IMSAPPSegResource;
import com.ibm.imstoc.IMSException;
import com.ibm.imstoc.IMSOTMAMsgProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class IMSAPPSeg
implements IMSOTMAMsgProperties {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private short _dataLength;
    private short _zzField;
    private byte[] _segmentData;
    protected RuntimeContext _RuntimeContext = RuntimeContext.getCurrent();
    private IMSAPPSegResource _resBundle = new IMSAPPSegResource();

    public IMSAPPSeg(byte[] segData, boolean hasLLZZ) throws IMSException, IOException {
        ByteArrayInputStream bis = null;
        DataInputStream dis = null;
        this._RuntimeContext = RuntimeContext.getCurrent();
        RASService rasService = this._RuntimeContext.getRASService();
        String methodName = super.toString();
        if (!hasLLZZ) {
            this._dataLength = (short)(segData.length + 2 + 2);
            this._zzField = 0;
            this._segmentData = new byte[this._dataLength];
            int i = 0;
            while (i < segData.length) {
                this._segmentData[i] = segData[i];
                ++i;
            }
        } else {
            bis = new ByteArrayInputStream(segData);
            dis = new DataInputStream(bis);
            this._dataLength = dis.readShort();
            this._zzField = dis.readShort();
            try {
                this._segmentData = new byte[this._dataLength - 4];
                int i = 0;
                while (i < this._dataLength - 4) {
                    this._segmentData[i] = segData[i + 4];
                    ++i;
                }
            }
            catch (Exception exception) {
                String errMsg = this._resBundle.getString("0001E", new Object[]{methodName});
                IMSException imsException = new IMSException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                    rasService.logTraceInfo(exception.toString());
                    exception.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(exception.toString());
                exception.printStackTrace(printErrorWriter);
                throw imsException;
            }
        }
    }

    public byte[] export() throws IOException {
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        byte[] newByteArray = null;
        bos = new ByteArrayOutputStream();
        dos = new DataOutputStream(bos);
        String methodName = String.valueOf(super.toString()) + ".export()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        dos.writeShort(this._dataLength);
        dos.writeShort(this._zzField);
        int i = 0;
        while (i < this._segmentData.length) {
            dos.writeByte(this._segmentData[i]);
            ++i;
        }
        newByteArray = bos.toByteArray();
        return newByteArray;
    }

    public short sizeOfAPPSeg() {
        String methodName = String.valueOf(super.toString()) + ".sizeOfAPPSeg()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        return this._dataLength;
    }

    public String toString() {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        byte[] newByteArray = null;
        String hexString = null;
        String retString = "0x";
        char[] h = new char[]{' ', ' '};
        String methodName = String.valueOf(super.toString()) + ".toString()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        try {
            newByteArray = this.export();
            if (newByteArray != null) {
                int i = 0;
                while (i < newByteArray.length) {
                    h[0] = hex[newByteArray[i] >> 4 & 0xF];
                    h[1] = hex[newByteArray[i] & 0xF];
                    hexString = new String(h);
                    retString = String.valueOf(retString) + hexString;
                    ++i;
                }
            }
        }
        catch (IOException iOException) {}
        return retString;
    }
}

