/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.record.cobol;

import com.ibm.ivj.eab.record.cobol.CobolArrayType;
import com.ibm.ivj.eab.record.cobol.CobolDynamicRecordType;
import com.ibm.ivj.eab.record.cobol.CobolOverlayType;
import com.ibm.ivj.eab.record.cobol.CobolRecordAttributes;
import com.ibm.ivj.eab.record.cobol.CobolRecordResource;
import com.ibm.ivj.eab.record.cobol.CobolType;
import com.ibm.ivj.eab.record.cobol.CodePageConversionException;
import com.ibm.record.DynamicRecord;
import com.ibm.record.IAnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IAnyFixedLengthRecordType;
import com.ibm.record.IAnyType;
import com.ibm.record.IArrayField;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.IFixedLengthComposedType;
import com.ibm.record.IFixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.IRecordAttributes;
import com.ibm.record.Record;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class CobolRecord
extends DynamicRecord
implements Serializable {
    private static String copyrights = "(c) Copyright IBM Corporation 1998.";
    protected boolean initialized_ = false;
    protected static final short CODEPAGE_TYPE = 0;
    protected static final short COMPILER_TYPE = 1;
    protected static final short FLOATINGPOINT_TYPE = 2;
    protected static final short MACHINE_TYPE = 3;
    protected static final short REMOTEENDIAN_TYPE = 4;
    protected static final short REMOTEINTENDIAN_TYPE = 5;

    protected CobolRecord() {
        this.setRecordAttributes(new CobolRecordAttributes("037", 0, 0, 0, 0, 0));
    }

    public CobolRecord(IAnyFixedLengthRecordType recordType) {
        super((IAnyDynamicRecordType)recordType);
        this.setRecordAttributes(new CobolRecordAttributes("037", 0, 0, 0, 0, 0));
    }

    public CobolRecord(IAnyFixedLengthRecordType recordType, byte[] bytes) {
        super((IAnyDynamicRecordType)recordType, bytes);
        this.setRecordAttributes(new CobolRecordAttributes("037", 0, 0, 0, 0, 0));
    }

    public CobolRecord(IAnyFixedLengthRecordType recordType, byte[] bytes, IRecordAttributes attributes, int startingOffset, int alignmentOffset) throws IllegalArgumentException, RecordException {
        super((IAnyDynamicRecordType)recordType, bytes, attributes, startingOffset, alignmentOffset);
    }

    public CobolRecord(IAnyFixedLengthRecordType recordType, IRecordAttributes attributes, int startingOffset, int alignmentOffset) throws IllegalArgumentException, RecordException {
        super((IAnyDynamicRecordType)recordType, attributes, startingOffset, alignmentOffset);
    }

    private void convertArrayValues(IArrayField field, IAnyType type, int offset, int size, short conversionType, String newCodePage, int newValue) throws RecordException {
        block53: {
            block0 : switch (conversionType) {
                case 0: {
                    if (!((CobolType)type).convertCodePage()) break;
                    String oldCodePage = ((CobolRecordAttributes)((Record)this).recordAttributes_).getCodePage();
                    int index = 0;
                    while (index < size) {
                        String stringValue = (String)field.getObject((IRecord)this, offset, index);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setCodePage(newCodePage);
                        field.setObject((IRecord)this, offset, index, (Object)stringValue);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setCodePage(oldCodePage);
                        ++index;
                    }
                    break;
                }
                case 1: {
                    if (!((CobolType)type).convertCompiler()) break;
                    int oldCompilerType = ((CobolRecordAttributes)((Record)this).recordAttributes_).getCompiler();
                    switch (((CobolType)type).getJavaEquivalentCobolType()) {
                        case 7: {
                            int index = 0;
                            while (index < size) {
                                double doubleValue = field.getDouble((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(newValue);
                                field.setDouble((IRecord)this, offset, index, doubleValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(oldCompilerType);
                                ++index;
                            }
                            break block0;
                        }
                        case 5: {
                            int index = 0;
                            while (index < size) {
                                long longValue = field.getLong((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(newValue);
                                field.setLong((IRecord)this, offset, index, longValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(oldCompilerType);
                                ++index;
                            }
                            break block0;
                        }
                        case 3: {
                            int index = 0;
                            while (index < size) {
                                short shortValue = field.getShort((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(newValue);
                                field.setShort((IRecord)this, offset, index, shortValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(oldCompilerType);
                                ++index;
                            }
                            break block0;
                        }
                        case 4: {
                            int index = 0;
                            while (index < size) {
                                int intValue = field.getInt((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(newValue);
                                field.setInt((IRecord)this, offset, index, intValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(oldCompilerType);
                                ++index;
                            }
                            break block8;
                        }
                    }
                    break;
                }
                case 3: {
                    if (!((CobolType)type).convertMachine()) break;
                    int oldMachine = ((CobolRecordAttributes)((Record)this).recordAttributes_).getMachine();
                    switch (((CobolType)type).getJavaEquivalentCobolType()) {
                        case 7: {
                            int index = 0;
                            while (index < size) {
                                double doubleValue = field.getDouble((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(newValue);
                                field.setDouble((IRecord)this, offset, index, doubleValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(oldMachine);
                                ++index;
                            }
                            break block0;
                        }
                        case 5: {
                            int index = 0;
                            while (index < size) {
                                long longValue = field.getLong((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(newValue);
                                field.setLong((IRecord)this, offset, index, longValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(oldMachine);
                                ++index;
                            }
                            break block0;
                        }
                        case 4: {
                            int index = 0;
                            while (index < size) {
                                int intValue = field.getInt((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(newValue);
                                field.setInt((IRecord)this, offset, index, intValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(oldMachine);
                                ++index;
                            }
                            break block0;
                        }
                        case 3: {
                            int index = 0;
                            while (index < size) {
                                short shortValue = field.getShort((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(newValue);
                                field.setShort((IRecord)this, offset, index, shortValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(oldMachine);
                                ++index;
                            }
                            break block14;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!((CobolType)type).convertFloatingPoint()) break;
                    int oldFormat = ((CobolRecordAttributes)((Record)this).recordAttributes_).getFloatingPointFormat();
                    switch (((CobolType)type).getJavaEquivalentCobolType()) {
                        case 7: {
                            int index = 0;
                            while (index < size) {
                                double doubleValue = field.getDouble((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setFloatingPointFormat(newValue);
                                field.setDouble((IRecord)this, offset, index, doubleValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setFloatingPointFormat(oldFormat);
                                ++index;
                            }
                            break block0;
                        }
                        case 6: {
                            int index = 0;
                            while (index < size) {
                                float floatValue = field.getFloat((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setFloatingPointFormat(newValue);
                                field.setFloat((IRecord)this, offset, index, floatValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setFloatingPointFormat(oldFormat);
                                ++index;
                            }
                            break block20;
                        }
                    }
                    break;
                }
                case 4: {
                    if (!((CobolType)type).convertEndian()) break;
                    int oldRemoteEndian = ((CobolRecordAttributes)((Record)this).recordAttributes_).getEndian();
                    switch (((CobolType)type).getJavaEquivalentCobolType()) {
                        case 7: {
                            int index = 0;
                            while (index < size) {
                                double doubleValue = field.getDouble((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(newValue);
                                field.setDouble((IRecord)this, offset, index, doubleValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian((short)oldRemoteEndian);
                                ++index;
                            }
                            break block0;
                        }
                        case 6: {
                            int index = 0;
                            while (index < size) {
                                float floatValue = field.getFloat((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(newValue);
                                field.setFloat((IRecord)this, offset, index, floatValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian((short)oldRemoteEndian);
                                ++index;
                            }
                            break block0;
                        }
                        case 5: {
                            int index = 0;
                            while (index < size) {
                                long longValue = field.getLong((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(newValue);
                                field.setLong((IRecord)this, offset, index, longValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian((short)oldRemoteEndian);
                                ++index;
                            }
                            break block0;
                        }
                        case 3: {
                            int index = 0;
                            while (index < size) {
                                short shortValue = field.getShort((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(newValue);
                                field.setShort((IRecord)this, offset, index, shortValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian((short)oldRemoteEndian);
                                ++index;
                            }
                            break block0;
                        }
                        case 4: {
                            int index = 0;
                            while (index < size) {
                                int intValue = field.getInt((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(newValue);
                                field.setInt((IRecord)this, offset, index, intValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian((short)oldRemoteEndian);
                                ++index;
                            }
                            break block24;
                        }
                    }
                    break;
                }
                case 5: {
                    if (!((CobolType)type).convertIntEndian()) break;
                    int oldRemoteIntEndian = ((CobolRecordAttributes)((Record)this).recordAttributes_).getRemoteIntEndian();
                    switch (((CobolType)type).getJavaEquivalentCobolType()) {
                        case 3: {
                            int index = 0;
                            while (index < size) {
                                short shortValue = field.getShort((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setRemoteIntEndian(newValue);
                                field.setShort((IRecord)this, offset, index, shortValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setRemoteIntEndian(oldRemoteIntEndian);
                                ++index;
                            }
                            break block53;
                        }
                        case 4: {
                            int index = 0;
                            while (index < size) {
                                int intValue = field.getInt((IRecord)this, offset, index);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setRemoteIntEndian(newValue);
                                field.setInt((IRecord)this, offset, index, intValue);
                                ((CobolRecordAttributes)((Record)this).recordAttributes_).setRemoteIntEndian(oldRemoteIntEndian);
                                ++index;
                            }
                            break block0;
                        }
                    }
                }
            }
        }
    }

    private void convertRecord(CobolDynamicRecordType myType, int absoluteOffset, short conversionType, String newCodePage, int newValue) throws RecordException {
        int nextOffset_ = 0;
        IFieldEnumeration cursor = myType.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            IAnyType type = field.getType();
            nextOffset_ = absoluteOffset + field.getRelativeOffset();
            if (type instanceof IFixedLengthComposedType) {
                if (type instanceof CobolDynamicRecordType) {
                    this.convertRecord((CobolDynamicRecordType)type, nextOffset_, conversionType, newCodePage, newValue);
                    continue;
                }
                if (type instanceof CobolArrayType) {
                    int[] dimensions = ((CobolArrayType)type).getDimensions();
                    IFixedLengthType elementType = ((CobolArrayType)type).getBaseType();
                    if (elementType instanceof CobolType) {
                        this.convertArrayValues((IArrayField)field, (IAnyType)elementType, absoluteOffset, dimensions[0], conversionType, newCodePage, newValue);
                        continue;
                    }
                    if (!(elementType instanceof CobolDynamicRecordType)) continue;
                    int elementSize = ((CobolDynamicRecordType)elementType).getSize();
                    int index = 0;
                    while (index < dimensions[0]) {
                        this.convertRecord((CobolDynamicRecordType)elementType, nextOffset_ + elementSize * index, conversionType, newCodePage, newValue);
                        ++index;
                    }
                    continue;
                }
                boolean cfr_ignored_0 = type instanceof CobolOverlayType;
                continue;
            }
            this.convertValue(field, type, absoluteOffset, conversionType, newCodePage, newValue);
        }
    }

    private void convertRecord(short conversionType, String newCodePage, int newValue) throws RecordException {
        int nextOffset_ = 0;
        IFieldEnumeration cursor = this.recordType_.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            IAnyType type = field.getType();
            nextOffset_ = field.getRelativeOffset();
            if (type instanceof IFixedLengthComposedType) {
                if (type instanceof CobolDynamicRecordType) {
                    this.convertRecord((CobolDynamicRecordType)type, nextOffset_, conversionType, newCodePage, newValue);
                    continue;
                }
                if (type instanceof CobolArrayType) {
                    int[] dimensions = ((CobolArrayType)type).getDimensions();
                    IFixedLengthType elementType = ((CobolArrayType)type).getBaseType();
                    if (elementType instanceof CobolType) {
                        this.convertArrayValues((IArrayField)field, (IAnyType)elementType, 0, dimensions[0], conversionType, newCodePage, newValue);
                        continue;
                    }
                    if (!(elementType instanceof CobolDynamicRecordType)) continue;
                    int elementSize = ((CobolDynamicRecordType)elementType).getSize();
                    int index = 0;
                    while (index < dimensions[0]) {
                        this.convertRecord((CobolDynamicRecordType)elementType, nextOffset_ + elementSize * index, conversionType, newCodePage, newValue);
                        ++index;
                    }
                    continue;
                }
                boolean cfr_ignored_0 = type instanceof CobolOverlayType;
                continue;
            }
            this.convertValue(field, type, 0, conversionType, newCodePage, newValue);
        }
    }

    private void convertValue(IAnyField field, IAnyType type, int offset, short conversionType, String newCodePage, int newValue) throws RecordException {
        switch (conversionType) {
            case 0: {
                if (!((CobolType)type).convertCodePage()) break;
                String strValue = (String)field.getObject((IRecord)this, offset);
                String oldCodePage = ((CobolRecordAttributes)((Record)this).recordAttributes_).getCodePage();
                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCodePage(newCodePage);
                field.setObject((IRecord)this, offset, (Object)strValue);
                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCodePage(oldCodePage);
                break;
            }
            case 1: {
                if (!((CobolType)type).convertCompiler()) break;
                int oldCompilerType = ((CobolRecordAttributes)((Record)this).recordAttributes_).getCompiler();
                switch (((CobolType)type).getJavaEquivalentCobolType()) {
                    case 7: {
                        double ctDouble = field.getDouble((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(newValue);
                        field.setDouble((IRecord)this, offset, ctDouble);
                        break;
                    }
                    case 5: {
                        long ctLong = field.getLong((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(newValue);
                        field.setLong((IRecord)this, offset, ctLong);
                        break;
                    }
                    case 3: {
                        short ctShort = field.getShort((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(newValue);
                        field.setShort((IRecord)this, offset, ctShort);
                        break;
                    }
                    case 4: {
                        int ctInt = field.getInt((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(newValue);
                        field.setInt((IRecord)this, offset, ctInt);
                    }
                }
                ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(oldCompilerType);
                break;
            }
            case 3: {
                if (!((CobolType)type).convertMachine()) break;
                int oldMachine = ((CobolRecordAttributes)((Record)this).recordAttributes_).getMachine();
                switch (((CobolType)type).getJavaEquivalentCobolType()) {
                    case 7: {
                        double mDouble = field.getDouble((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(newValue);
                        field.setDouble((IRecord)this, offset, mDouble);
                        break;
                    }
                    case 5: {
                        long mLong = field.getLong((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(newValue);
                        field.setLong((IRecord)this, offset, mLong);
                        break;
                    }
                    case 4: {
                        int mInt = field.getInt((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(newValue);
                        field.setInt((IRecord)this, offset, mInt);
                        break;
                    }
                    case 3: {
                        short mShort = field.getShort((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(newValue);
                        field.setShort((IRecord)this, offset, mShort);
                    }
                }
                ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(oldMachine);
                break;
            }
            case 2: {
                if (!((CobolType)type).convertFloatingPoint()) break;
                int oldFormat = ((CobolRecordAttributes)((Record)this).recordAttributes_).getFloatingPointFormat();
                switch (((CobolType)type).getJavaEquivalentCobolType()) {
                    case 7: {
                        double mDouble = field.getDouble((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setFloatingPointFormat(newValue);
                        field.setDouble((IRecord)this, offset, mDouble);
                        break;
                    }
                    case 6: {
                        float mFloat = field.getFloat((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setFloatingPointFormat(newValue);
                        field.setFloat((IRecord)this, offset, mFloat);
                    }
                }
                ((CobolRecordAttributes)((Record)this).recordAttributes_).setFloatingPointFormat(oldFormat);
                break;
            }
            case 4: {
                if (!((CobolType)type).convertEndian()) break;
                int oldRemoteEndian = ((CobolRecordAttributes)((Record)this).recordAttributes_).getEndian();
                switch (((CobolType)type).getJavaEquivalentCobolType()) {
                    case 7: {
                        double reDouble = field.getDouble((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(newValue);
                        field.setDouble((IRecord)this, offset, reDouble);
                        break;
                    }
                    case 6: {
                        float reFloat = field.getFloat((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(newValue);
                        field.setFloat((IRecord)this, offset, reFloat);
                        break;
                    }
                    case 5: {
                        long reLong = field.getLong((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(newValue);
                        field.setLong((IRecord)this, offset, reLong);
                        break;
                    }
                    case 3: {
                        short reShort = field.getShort((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(newValue);
                        field.setShort((IRecord)this, offset, reShort);
                        break;
                    }
                    case 4: {
                        int reInt = field.getInt((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(newValue);
                        field.setInt((IRecord)this, offset, reInt);
                    }
                }
                ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian((short)oldRemoteEndian);
                break;
            }
            case 5: {
                if (!((CobolType)type).convertIntEndian()) break;
                int oldRemoteIntEndian = ((CobolRecordAttributes)((Record)this).recordAttributes_).getRemoteIntEndian();
                switch (((CobolType)type).getJavaEquivalentCobolType()) {
                    case 3: {
                        short rieShort = field.getShort((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setRemoteIntEndian(newValue);
                        field.setShort((IRecord)this, offset, rieShort);
                        break;
                    }
                    case 4: {
                        int rieInt = field.getInt((IRecord)this, offset);
                        ((CobolRecordAttributes)((Record)this).recordAttributes_).setRemoteIntEndian(newValue);
                        field.setInt((IRecord)this, offset, rieInt);
                    }
                }
                ((CobolRecordAttributes)((Record)this).recordAttributes_).setRemoteIntEndian(oldRemoteIntEndian);
            }
        }
    }

    public String getCodePage() {
        return ((CobolRecordAttributes)((Record)this).recordAttributes_).getCodePage();
    }

    public int getCompiler() {
        return ((CobolRecordAttributes)((Record)this).recordAttributes_).getCompiler();
    }

    public int getEndian() {
        return ((CobolRecordAttributes)((Record)this).recordAttributes_).getEndian();
    }

    public int getFloatingPointFormat() {
        return ((CobolRecordAttributes)((Record)this).recordAttributes_).getFloatingPointFormat();
    }

    public int getMachine() {
        return ((CobolRecordAttributes)((Record)this).recordAttributes_).getMachine();
    }

    public int getRemoteIntEndian() {
        return ((CobolRecordAttributes)((Record)this).recordAttributes_).getRemoteIntEndian();
    }

    protected void initialized() {
        this.initialized_ = true;
    }

    public void setCodePage(String codePage) throws RecordException, IllegalArgumentException {
        try {
            byte[] byteArray = new byte[]{12, 34};
            new String(byteArray, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(CobolRecordResource.instance().getString("IVJC0224E", codePage));
        }
        if (this.initialized_ && !codePage.equals(this.getCodePage())) {
            try {
                this.convertRecord((short)0, codePage, 0);
            }
            catch (RecordException recordException) {
                throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
            }
        }
        if (((Record)this).recordAttributes_ != null) {
            ((CobolRecordAttributes)((Record)this).recordAttributes_).setCodePage(codePage);
        }
    }

    public void setCompiler(int compiler) throws RecordException {
        if (compiler < 0 || compiler > 2) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0220E", new Integer(compiler).toString()));
        }
        if (this.initialized_ && compiler != this.getCompiler()) {
            this.convertRecord((short)1, "", compiler);
        }
        if (((Record)this).recordAttributes_ != null) {
            ((CobolRecordAttributes)((Record)this).recordAttributes_).setCompiler(compiler);
        }
    }

    public void setEndian(int endian) throws RecordException {
        if (endian < 0 || endian > 1) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0222E", new Integer(endian).toString()));
        }
        if (this.initialized_ && endian != this.getEndian()) {
            this.convertRecord((short)4, "", endian);
        }
        if (((Record)this).recordAttributes_ != null) {
            ((CobolRecordAttributes)((Record)this).recordAttributes_).setEndian(endian);
        }
    }

    public void setFloatingPointFormat(int format) throws RecordException {
        if (format < 0 || format > 1) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0244E", new Integer(format).toString()));
        }
        if (this.initialized_ && format != this.getFloatingPointFormat()) {
            this.convertRecord((short)2, "", format);
        }
        if (((Record)this).recordAttributes_ != null) {
            ((CobolRecordAttributes)((Record)this).recordAttributes_).setFloatingPointFormat(format);
        }
    }

    public void setInitialValues() throws RecordConversionFailureException, RecordConversionUnsupportedException {
        super.setInitialValues();
        this.initialized();
    }

    public void setMachine(int machine) throws RecordException {
        if (machine < 0 || machine > 3) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0221E", new Integer(machine).toString()));
        }
        if (this.initialized_ && machine != this.getMachine() && (machine == 0 || this.getMachine() == 0)) {
            this.convertRecord((short)3, "", machine);
        }
        if (((Record)this).recordAttributes_ != null) {
            ((CobolRecordAttributes)((Record)this).recordAttributes_).setMachine(machine);
        }
    }

    public void setRemoteIntEndian(int remoteIntEndian) throws RecordException {
        if (remoteIntEndian < 0 || remoteIntEndian > 1) {
            throw new RecordConversionUnsupportedException(CobolRecordResource.instance().getString("IVJC0223E", new Integer(remoteIntEndian).toString()));
        }
        if (this.initialized_ && remoteIntEndian != this.getRemoteIntEndian()) {
            this.convertRecord((short)5, "", remoteIntEndian);
        }
        if (((Record)this).recordAttributes_ != null) {
            ((CobolRecordAttributes)((Record)this).recordAttributes_).setRemoteIntEndian(remoteIntEndian);
        }
    }
}

