-- -----------------------------------------------------------
--
--  IBM(R) VisualAge(TM) for Java(TM) Version 1 and others
--   - Licensed Material - Program-Property of IBM
--  (C) Copyright IBM Corp. 1997 - All Rights Reserved.
--  US Government Users Restricted Rights - Use, duplication or disclosure
--  restricted by GSA ADP Schedule Contract with IBM Corp.
--
-- -----------------------------------------------------------

--
-- This template file contains common procedures used in the other
-- template files
--

package()
{
  Sub class
  if (class->fullPackageName != "") { /*package $class->fullPackageName$;*/ }
}

setBuffer(map, isAttribute, obj, index, stmt, spaces)
{
  Var name

  if (isAttribute) {
    name = obj + "get" + map->Name + "()"
  } else {
    name = map->name
    if ((map->isOutput || map->isResultCol) && map->isParameter) { name += "[0]" }
  }

  -- validate the parameter
  if ((!map->isNullable) && (!isPrimitive(map->type))) {
    spaces /*if ($name$ == null) throw new DAException(DAResource.COLUMN_NOT_NULLABLE, "$map->name$");*/ endl
  }

  -- set the buffer
  if ( isPrimitive(map->type) ) {
    spaces /*$stmt$.setObject($index$, $getPrimitiveClass(map->type, name)$, $getDBType(&map, name)$);*/ endl
  }
  else if ( map->type == "BigDecimal" ) {
    if (map->isNullable) {
      spaces /*if ($name$ == null) $stmt$.setNull($index$, $getSQLType(map->SQLType)$);*/ endl
      spaces /*else $stmt$.setObject($index$, $getNumericClass(map->type,name)$, $getDBType(&map, name)$); */ endl
    } else {
      spaces /*$stmt$.setObject($index$, $getNumericClass(map->type,name)$, $getDBType(&map, name)$); */ endl
    }
  }
  else if ( isNumericClass(map->type) ) {
    if (map->isNullable) {
      spaces /*if ($name$ == null) $stmt$.setNull($index$, $getSQLType(map->SQLType)$);*/ endl
      spaces /*else $stmt$.setObject($index$, $getNumericClass(map->type,name)$, $getDBType(&map, name)$); */ endl
    } else {
      spaces /*$stmt$.setObject($index$, $getNumericClass(map->type,name)$, $getDBType(&map, name)$); */ endl
    }
  }
  else if (map->type == "DAIOStream") {
    spaces /*$stmt$.set$map->JDBCAccessType$($index$, $name$.getInputStreamOrFile(), $name$.getReadLength()); */ endl
  }
  else if (map->type == "String") {
    if (map->isNullable) {
      spaces /*if ($name$ == null) $stmt$.setNull($index$, $getSQLType(map->SQLType)$);*/ endl
      if (map->length != "0") {
        spaces /*else if ($name$.length() > $map->length$) throw new DAException(DAResource.INVALID_LENGTH, "$map->name$"); */ endl
      }
      spaces /*else $stmt$.setObject($index$, $name$, $getDBType(&map, name)$); */ endl
    } else {
      if (map->length != "0") {
        spaces /*if ($name$.length() > $map->length$) throw new DAException(DAResource.INVALID_LENGTH, "$map->name$"); */ endl
      }
      spaces /*$stmt$.setObject($index$, $name$, $getDBType(&map, name)$); */ endl
    }
  }
  else {
    if (map->isNullable) {
      spaces /*if ($name$ == null) $stmt$.setNull($index$, $getSQLType(map->SQLType)$);*/ endl
      spaces /*else $stmt$.setObject($index$, $name$, $getDBType(&map, name)$); */ endl
    } else {
      spaces /*$stmt$.setObject($index$, $name$, $getDBType(&map, name)$); */ endl
    }
  }
}

DBAccessName(type)
{
  if (type contains "Date") /*Date*/
  else if (type == "Integer") /*Int*/
  else if (type == "byte[]") /*Bytes*/
  else type|upperCase(1,1)
}

getPrimitiveClass(type, name)
{
  if (type == "byte" || type == "short") {
    /*new Integer((int)$name$)*/
  }
  else { /*new $primitiveClass(type)$($name$)*/ }
}

getNumericClass(type, name)
{
  if (type == "Byte" || type == "Short") { /*new Integer($name$.intValue())*/ }
  else name
}

getSQLType(SQLType)
{
  /*Types.*/

  if (SQLType == "BLOB") /*LONGVARBINARY*/
  else if (SQLType == "DBCLOB") /*LONGVARBINARY*/
  else if (SQLType == "CLOB") /*LONGVARCHAR*/
  else if (SQLType == "GRAPHIC") /*CHAR*/
  else if (SQLType == "VARGRAPHIC") /*VARCHAR*/
  else if (SQLType == "LONGVARGRAPHIC") /*LONGVARCHAR*/
  else if (SQLType == "UTINYINT") /*TINYINT*/
  else if (SQLType == "USMALLINT") /*TINYINT*/
  else if (SQLType == "UINTEGER") /*INTEGER*/
  else if (SQLType == "UBIGINT") /*BIGINT*/
  else if (SQLType == "CHAR_FOR_BIT_DATA") /*CHAR*/
  else if (SQLType == "VARCHAR_FOR_BIT_DATA") /*VARCHAR*/
  else if (SQLType == "LONGVARCHAR_FOR_BIT_DATA") /*LONGVARCHAR*/
  else SQLType
}

getDBType(map, name)
{
  getSQLType(map->SQLType)

  if (map->type == "BigDecimal") { /*, $name$.scale()*/ }
  else if (map->SQLType == "DECIMAL" ||
           map->SQLType == "NUMERIC" ) { /*, $map->scale$*/ }
}

getBuffer(attr, obj, index, stmt, spaces, saveStream)
{
 if (attr->isAttribute) {
   if ( isPrimitive(attr->type) ) {
     spaces /*$obj$_set$attr->Name$($stmt$.get$DBAccessName(attr->type)$($index$)); */ endl
   }
   else if (attr->type == "DAIOStream") {
     spaces /*$obj$get$attr->Name$().getFromLob($stmt$.get$attr->JDBCAccessType$($index$), $saveStream$); */ endl
   }
   else if ( isNumericClass(attr->type) ) {
     spaces /*$obj$_set$attr->Name$(new $attr->type$($stmt$.get$DBAccessName(attr->type)$($index$)));*/ endl
     spaces /*if ($stmt$.wasNull()) $obj$_set$attr->Name$(null);*/ endl
   }
   else {
     spaces /*$obj$_set$attr->Name$($stmt$.get$DBAccessName(attr->type)$($index$$checkNumeric(&attr)$));*/ endl
     spaces /*if ($stmt$.wasNull()) $obj$_set$attr->Name$(null);*/ endl
   }
 }
 else {
   Var name

   name = attr->name
   if ((attr->isOutput || attr->isResultCol) && attr->isParameter) { name += "[0]" }

   if ( isPrimitive(attr->type) ) {
     spaces /*$name$ = $stmt$.get$DBAccessName(attr->type)$($index$); */ endl
   }
   else if ( isNumericClass(attr->type) ) {
     spaces /*$name$ = new $attr->type$($stmt$.get$DBAccessName(attr->type)$($index$));*/ endl
     spaces /*if ($stmt$.wasNull()) $name$ = null; */ endl
   }
   else if (attr->type == "DAIOStream") {
     spaces /*$name$.getFromLob($stmt$.get$attr->JDBCAccessType$($index$), $saveStream$); */ endl
   }
   else {
     spaces /*$name$ = $stmt$.get$DBAccessName(attr->type)$($index$$checkNumeric(&attr)$); */ endl
     spaces /*if ($stmt$.wasNull()) $name$ = null; */ endl
   }
 }
}

checkNumeric(map)
{
  if (map->type == "Numeric") { /*, $map->scale$*/ }
  else if (map->type == "BigDecimal") { /*, $map->scale$*/ }
}

equals(dataid, obj)
{
  Sub class

  repeat (class->attr |  condition (attr->isDataId == dataid) ) {
    if ( isPrimitive(attr->type) ) {
      /*    if ( i$attr->Name$ != $obj$.i$attr->Name$ ) return false; */ endl
    }
    else {
     /*    if ( i$attr->Name$ != $obj$.i$attr->Name$ ) {
       if ( i$attr->Name$ == null || $obj$.i$attr->Name$ == null) return false;
       else if ( !i$attr->Name$.equals( $obj$.i$attr->Name$ ) ) return false;
     } */ endl
    }
  }

}

attributeDeclaration(dataid)
{
 Sub class
 Counter index(0,1)

 index|reset()
 repeat (class->attr | condition (attr->isDataId == dataid) ) {
   set escape "~"
   /*
  ~/*--------------------------------------------------------------
     $class->name$*/ if (dataid) /*DataId*/ /* $attr->name$ access methods
     $attr->usrcomment$
    --------------------------------------------------------------*~/*/ endl
   if (attr->currentUpdate) {
     attributeImpl(&attr, index, "false", "false")
   } else {
     attributeImpl(&attr, index, "true", "false")
     index|increment()
   }

     /*
   public boolean is$attr->Name$Nullable() { return $attr->isNullable$; } */ endl
 } -- repeat

}

attributeImpl(attr, index, modify, isManager)
{
  Sub class

  /*   private $attr->type$ i$attr->Name$ $initialize(&attr->type)$

   public $attr->type$ get$attr->Name$() { return i$attr->Name$; }
   public void set$attr->Name$($attr->type$ a$attr->Name$) { */ endl

  /*     $attr->type$ temp = i$attr->Name$; */ endl

   if (modify) {
     /*     modified[$index$] = true;*/ endl
   }

   if (attr->type == "DAIOStream") {
    /*     if (a$attr->Name$ != null) i$attr->Name$ = a$attr->Name$; */
   } else {
    /*     i$attr->Name$ = a$attr->Name$; */
   }

  /*
     setModified(true);
     _changes.firePropertyChange("$attr->name$", */
   if ( isPrimitive(attr->type) ) {
     /* new $primitiveClass(attr->type)$(temp), new $primitiveClass(attr->type)$(a$attr->Name$) ); */
   }
   else {
     /* temp, a$attr->Name$); */
   }

  /*
   } */ endl

  if (!isManager) { /*
   void _set$attr->Name$($attr->type$ a$attr->Name$) {
     if (_sendingAttributeEvents) {
       $attr->type$ temp = i$attr->Name$; */ endl

    if (attr->type == "DAIOStream") {
      /*       if (a$attr->Name$ != null) i$attr->Name$ = a$attr->Name$; */
    } else {
      /*       i$attr->Name$ = a$attr->Name$; */
    }

    /*
       _changes.firePropertyChange("$attr->name$", */
    if ( isPrimitive(attr->type) ) {
      /* new $primitiveClass(attr->type)$(temp), new $primitiveClass(attr->type)$(a$attr->Name$) ); */
    }
    else {
      /* temp, a$attr->Name$); */
    }
   /*
     } else {
       i$attr->Name$ = a$attr->Name$;
     }
   } */ endl
  }
}

initialize(type)
{
  if ( type == "DAIOStream" ) /*= new DAIOStream();*/
  else if ( type == "byte" || type == "short" ||
            type == "int" || type == "long" ||
            type == "double" || type == "float" )  { /*= 0;*/  }
  else if (type == "boolean" ) { /*= false;*/  }
  else /*= null;*/
}


isPrimitive(type)
{
  if (type == "short" || type == "byte" ||
      type == "int" || type == "float" ||
      type == "double" || type == "boolean" ||
      type == "long") {
    /*true*/
  }
  else { /*false*/ }

}

primitiveType(type)
{
  if (type == "Integer") /*int*/
  else type|lowerCase()
}

primitiveClass(type)
{
  if (type == "int") /*Integer*/
  else if (type contains "java.") type
  else type|upperCase(1,1)
}

isNumericClass(type)
{
  if (type == "Short" || type == "Byte" ||
      type == "Integer" || type == "Float" ||
      type == "Double" || type == "Boolean" ||
      type == "Long") {
    /*true*/
  }
  else { /*false*/ }

}

putOnThread(method, methodID, returnVal)
{
  /*
    if ( !_onBackground() && isAsynchronous() ) {
      Object[] params = { */
  --
  -- Add parameters to the vector
  --
  repeat (method->arg | condition (arg->isParameter) middle { /*, */ }  ) {
    if ( isPrimitive(arg->type) && !(arg->isOutput || arg->isResultCol) ) { /* new $primitiveClass(arg->type)$($arg->name$)*/ }
    else { /* $arg->name$*/ }
  }
  /*  };
      _putOnBackgroundThread( "$methodID$", params );
      return $returnVal$;
    } */ endl

}

callAStaticMethod(className, method, methodName, methodID, returnType, elseif)
{
  Sub class

  /*    $elseif$ ( _methodName.equals("$methodID$") ) {
*/
  if (returnType == "void")
  {
/*      $className$.$methodName$( */
  }
  else if (isPrimitive(returnType))
  {
/*      _result = new $primitiveClass(returnType)$( $className$.$methodName$( */
  }
  else
  {
/*      _result = $className$.$methodName$( */
  }


  --
  -- output arguments
  --
  Counter parmCounter(0,1)

  parmCounter|reset()
  repeat ( method->arg | condition (arg->isParameter) middle { /*, */ } ) {
    if ( isPrimitive(arg->type) && !(arg->isOutput || arg->isResultCol) ) {
      /*(($primitiveClass(arg->type)$)_params[$parmCounter$]).$arg->type$Value()*/
    }
    else {
      if (arg->isOutput || arg->isResultCol) { /*($arg->type$[])*/ }
      else { /*($arg->type$)*/ }

      /*_params[$parmCounter$]*/
    }
    parmCounter|increment()
  }

  if (returnType != "void" && isPrimitive(returnType))
  {
   /* ) */
  }
   /* );
    } */ endl

}

callAMethodOnThread(method, methodName, methodID, elseif)
{
  Sub class

  /*    $elseif$ ( _methodName.equals("$methodID$") ) {
      $methodName$( */

  --
  -- output arguments
  --
  Counter parmCounter(0,1)

  parmCounter|reset()
  repeat ( method->arg | condition (arg->isParameter) middle { /*, */ } ) {
    if ( isPrimitive(arg->type) && !(arg->isOutput || arg->isResultCol) ) {
      /*(($primitiveClass(arg->type)$)_params[$parmCounter$]).$arg->type$Value()*/
    }
    else {
      if (arg->isOutput || arg->isResultCol) { /*($arg->type$[])*/ }
      else { /*($arg->type$)*/ }

      /*_params[$parmCounter$]*/
    }
    parmCounter|increment()
  }


   /* );
    } */ endl

}

methodID(method)
{
  /*$method->name$(*/
  repeat (method->arg | condition(arg->isParameter) middle { /*, */ } ) {
    /*$arg->type$*/
    if (arg->isOutput || arg->isResultCol) { /*[]*/ }
  }
  /*)*/
}

varAsObject(varName, varType)
{
  if (varType == "void") /*null*/
  else if (isPrimitive(varType)) {
    /*new $primitiveClass(varType)$($varName$)*/
  }
  else {
    /*$varName$*/
  }
}

AttributeClass(type)
{
  if (isPrimitive(type)) {
    /*      java.lang.$primitiveClass(type)$.class */
  } else {
    /*      $type$.class */
  }
}

GetFromEditor(type,editor)
{
  if (isPrimitive(type))
  {
     /*(($primitiveClass(type)$)$editor$.getValue()).$type$Value()*/
  }
  else
  {
     /*($type$)$editor$.getValue()*/
  }
}

AttributeIsNullable(type,dbNullable)
{
  if (isPrimitive(type))
     /*false*/
  else if ( ! dbNullable )
     /*false*/
  else
     /*true*/
}

attrToString(attr)
{
  if (attr->type == "DAIOStream") { /*""*/ }
  else if (attr->type == "String") { /*get$attr->Name$()*/ }
  else { /*String.valueOf(get$attr->Name$())*/ }
}

format(comment, indent)
{
  comment|change("\r\n","\n")|change("\r", " ")|change("\n","\n" + indent + "* ")
}
