
package COM.ibm.ivj.javabeans;

import java.beans.*;
import java.util.*;

public class IVector implements java.io.Serializable, PropertyChangeListener {

  private transient IVectorListener _listeners[] = null;
  private Vector myVector;

  public IVector ()
  {
    myVector = new Vector ();
  }

  public IVector (IObjectInterface o[]) {
    myVector = new Vector ();
    replaceAllElements (o);
  }

  public IVector (Object o[]) {
    myVector = new Vector ();
    replaceAllElements (o);
  }

  public IVector(int capacity, int capacityInc) {
    myVector = new Vector(capacity, capacityInc);
  }

  public IVector (Vector v) {
    myVector = v;
    for (int i = 0; i <size(); i++) {
      Object aObject = myVector.elementAt(i);

      if ( aObject instanceof IObjectInterface) {
        ((IObjectInterface) aObject).addPropertyChangeListener (this);
      }
    }
  }

  public void addIVectorListener(IVectorListener listener) {
    synchronized(this) {
      if (_listeners == null) {
        _listeners = new IVectorListener[1];
        _listeners[0] = listener;
      } else {
        IVectorListener targets[] = new IVectorListener[_listeners.length + 1];

        int i;
        for (i=0; i < _listeners.length; i++) {
          targets[i] = _listeners[i];
        }
        targets[i] = listener;

        _listeners = targets;
      }
    }
  }

  public synchronized void addOneElement (Object o) {
    myVector.addElement (o);

    if (o instanceof IObjectInterface) {
     // create a listener for this new vector element
     ((IObjectInterface) o).addPropertyChangeListener (this);
    }

    // signal a bean event
    fireAddEvent(o);
  }

  public synchronized void addOneElementAt (Object o, int index) {
    myVector.insertElementAt (o, index);

    if (o instanceof IObjectInterface) {
      // create a listener for this new vector element
      ((IObjectInterface) o).addPropertyChangeListener (this);
    }

    // signal a bean event
    fireAddEvent(index);
  }

  public boolean contains (Object elem) {
    return myVector.contains (elem);
  }

  public Object elementAt (int index) {
    return  myVector.elementAt (index);
  }

  public Enumeration elements () {
    return myVector.elements ();
  }

  private void fireAddEvent(Object o) {
    if (_listeners == null) return;
    fireAddEvent(myVector.indexOf(o));
  }

  private void fireAddEvent(int index) {
    IVectorListener temp[] = _listeners;

    if (temp == null) return;
    IVectorEvent evt = new IVectorEvent(this, index);

    for (int i=0; i < temp.length; i++) {
      temp[i].vectorElementAdded(evt);
    }
  }

  private void fireRemoveEvent(Object o) {
    if (_listeners == null) return;
    fireRemoveEvent(myVector.indexOf(o));
  }

  private void fireRemoveEvent(int index) {
    IVectorListener temp[] = _listeners;

    if (temp == null) return;
    IVectorEvent evt = new IVectorEvent(this, index);

    for (int i=0; i < temp.length; i++) {
      temp[i].vectorElementRemoved(evt);
    }
  }

  public void fireVectorChangeEvent (int index) {
    IVectorListener temp[] = _listeners;

    if (temp == null) return;
    IVectorEvent evt = new IVectorEvent(this, index);

    for (int i=0; i < temp.length; i++) {
      temp[i].vectorElementChanged(evt);
    }
  }

  public void fireVectorChangeEvent(Object o) {
    if (_listeners == null) return;
    fireVectorChangeEvent (myVector.indexOf(o));
  }

  public void fireVectorModifiedEvent() {
    IVectorListener temp[] = _listeners;

    if (temp == null) return;
    IVectorEvent evt = new IVectorEvent(this);

    for (int i=0; i < temp.length; i++) {
      temp[i].vectorModified(evt);
    }
  }

  public Object firstElement () {
    return myVector.firstElement ();
  }

  public Vector getVector () {
    return myVector;
  }

  public int indexOf (Object elem) {
    return myVector.indexOf (elem);
  }

  public int indexOf (Object elem, int index) {
    return myVector.indexOf (elem, index);
  }

  public Object lastElement () {
    return myVector.lastElement ();
  }

  public int lastIndexOf (Object elem) {
    return myVector.lastIndexOf (elem);
  }

  public int lastIndexOf (Object elem, int index) {
    return myVector.lastIndexOf (elem, index);
  }

  public void propertyChange (PropertyChangeEvent evt) {
    // get which element is changed
    Object o = evt.getSource ();
    int index = myVector.indexOf (o);

    // make sure that the elemet is an IObjectInterface
    if ( (o instanceof IObjectInterface) && (index > -1) ) {
      fireVectorChangeEvent (index);
    }
  }

  public synchronized void removeAllElements () {

    // remove all listeners
    for (int i = 0; i < size(); i++) {
      Object o =  myVector.elementAt(i);
      if ( o instanceof IObjectInterface) {
        ((IObjectInterface) o).removePropertyChangeListener (this);
      }
    }
    myVector.removeAllElements ();
    fireRemoveEvent(-1);
  }

  public void removeIVectorListener(IVectorListener listener) {
    synchronized(this) {
      if (_listeners == null) return;

      // check to make sure the ConnectionListener is in the list
      boolean flag = false;
      for(int i=0; i < _listeners.length; i++) {
        if (_listeners[i] == listener) {
          flag = true;
          break;
        }
      }

      if (!flag) return;  // listener is not in the list

      if (_listeners.length == 1) {
        _listeners = null;
        return;
      }

      IVectorListener targets[] = new IVectorListener[_listeners.length - 1];
      boolean removed = false;

      int j=0;
      for(int i=0; i< _listeners.length; i++) {
        if (!removed && _listeners[i] == listener) {
          removed = true;
        } else {
          targets[j++] = _listeners[i];
        }
      }

      _listeners = targets;
    }
  }

  public synchronized void removeOneElement (Object o) {

    int index = myVector.indexOf (o);

    // if element exists
    if ( index > -1 ) {
      if ( o instanceof IObjectInterface) {
        ((IObjectInterface) o).removePropertyChangeListener (this);
      }
      myVector.removeElement (o);
      fireRemoveEvent(o);
    }
  }

  public synchronized void removeOneElementAt (int a) {
    if ( a < myVector.size() ) {
      Object o = myVector.elementAt (a);
      if ( o instanceof IObjectInterface) {
        ((IObjectInterface )o).removePropertyChangeListener (this);
      }
      myVector.removeElementAt (a);
      fireRemoveEvent(a);
    }
  }

  public synchronized void replaceAllElements (Object o[]) {
    int i;

    // remove all previous listeners
    for (i = 0; i < size (); i++) {
      Object aObject = myVector.elementAt(i);
      if ( aObject instanceof IObjectInterface)
        ((IObjectInterface) aObject ).removePropertyChangeListener (this);
    }

    myVector.removeAllElements ();

    for (i = 0; i <o.length; i++) {
      myVector.addElement (o[i]);
      if ( o[i] instanceof IObjectInterface)
        ((IObjectInterface)o[i]).addPropertyChangeListener (this);
    }

    fireAddEvent(-1);
  }

  public synchronized void replaceOneElement (Object o, int index) {

    // remove the previous listener if the element exists
    if ( (elementAt (index) != null) &&
         (myVector.elementAt(index) instanceof IObjectInterface) ) {
      ((IObjectInterface) myVector.elementAt (index)).removePropertyChangeListener (this);
    }

    myVector.setElementAt (o, index);
    fireVectorChangeEvent (index);
    if ( o instanceof IObjectInterface) {
      ((IObjectInterface) o).addPropertyChangeListener (this);
    }
  }

  public void setSize (int newSize) {
    myVector.setSize (newSize);
  }

  public int size () {
    return myVector.size ();
  }

  public String toString ()
  {
    return myVector.toString();
  }
}
