
package COM.ibm.ivj.javabeans;

import java.awt.*;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;

public class IDialog extends java.lang.Object
                     implements java.awt.event.ActionListener
                              , java.awt.event.WindowListener
{
   private static String copywrite = "IBM(R) VisualAge(TM) for Java(TM), Version 1 and others\n - Licensed Material - Program-Property of IBM\n(C) Copyright IBM Corp. 1997 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
   private static java.util.ResourceBundle resources = null;
   static {
      try {
         resources = ResourceBundle.getBundle("COM.ibm.ivj.javabeans.IDialogResources");
      }
      catch(Throwable exc) {
         resources = null;
      }
   }
   private java.awt.TextArea textArea = new java.awt.TextArea();
   private String result = null;
   private String title = null;
   private Component parent = null;
   private static boolean printStackTrace = false;
   private java.awt.Dimension size = null;
   private String[] buttons = null;
   private Button[] bButtons = null;
   private Dialog dialog = null;

   /**
    * IDialog - modal dialog displaying a message, reporting
    * the option (button) the user selects.  This Dialog is always
    * modal.
    * The dialog is shown modally upon construction.  Use getResult()
    * to determine the users action, eg: new IDialog(...).getResult()
    * @return IDialog
    * @param parent java.awt.Component Parent of the dialog
    * @param title java.lang.String Title of the of the dialog
    * @param event java.lang.String Event to display
    * @param buttons java.lang.String[] Buttons to display
    */
   public IDialog( Component aParent
                 , String aTitle
                 , java.util.EventObject event
                 , String[] buttons )
   {
      this(aParent,aTitle,buttons);
      showEvent(event);
   }

   /**
    * IDialog - modal dialog displaying a message, reporting
    * the option (button) the user selects.  This Dialog is always
    * modal.
    * The dialog is shown modally upon construction.  Use getResult()
    * to determine the users action, eg: new IDialog(...).getResult()
    * @return IDialog
    * @param parent java.awt.Component Parent of the dialog
    * @param title java.lang.String Title of the of the dialog
    * @param exception java.lang.Throwable Exception to display
    * @param buttons java.lang.String[] Buttons to display
    */
   public IDialog( Component aParent
                 , String aTitle
                 , Throwable exception
                 , String[] buttons )
   {
      this(aParent,aTitle,buttons);
      showException(exception);
   }

   /**
    * IDialog - modal dialog displaying a message, reporting
    * the option (button) the user selects.  This Dialog is always
    * modal.
    * The dialog is shown modally upon construction.  Use getResult()
    * to determine the users action, eg: new IDialog(...).getResult()
    * @return IDialog
    * @param parent java.awt.Component Parent of the dialog
    * @param title java.lang.String Title of the of the dialog
    * @param message java.lang.String Message to display
    * @param buttons java.lang.String[] Buttons to display
    */
   public IDialog( Component aParent
                 , String aTitle
                 , String message
                 , String[] buttons )
   {
      this(aParent,aTitle,buttons);
      show(message);
   }

   /**
    * IDialog - modal dialog displaying a message, reporting
    * the option (button) the user selects.  This Dialog is always
    * modal.
    * Use a show(...) method, then getResult() to modally show then determine
    * the users action, eg: new IDialog(...).getResult()
    * @return IDialog
    */
   public IDialog()
   {
      this(null,null);
   }

   /**
    * IDialog - modal dialog displaying a message, reporting
    * the option (button) the user selects.  This Dialog is always
    * modal.
    * Use a show(...) method, then getResult() to modally show then determine
    * the users action, eg: new IDialog(...).getResult()
    * @return IDialog
    * @param parent java.awt.Component Parent of the dialog
    */
   public IDialog( Component aParent )
   {
      this(aParent,null);
   }


   /**
    * IDialog - modal dialog displaying a message, reporting
    * the option (button) the user selects.  This Dialog is always
    * modal.
    * The dialog is shown modally upon construction.  Use getResult()
    * to determin the users action.
    * @return IDialog
    * @param parent java.awt.Frame Parent of the dialog
    * @param buttons java.lang.String[] Buttons to display
    */
   public IDialog( Component aParent
                 , String[] buttons )
   {
      parent = aParent;
      setButtons(buttons);
   }

   /**
    * IDialog - modal dialog displaying a message, reporting
    * the option (button) the user selects.  This Dialog is always
    * modal.
    * Use a show() method, then getResult() to modally show then determine
    * the users action.
    * @return IDialog
    * @param parent java.awt.Frame Parent of the dialog
    * @param title java.lang.String Title of the of the dialog
    * @param buttons java.lang.String[] Buttons labels to display
    */
   public IDialog( Component aParent
                 , String aTitle
                 , String[] buttons )
   {
      setParent(aParent);
      setTitle(aTitle);
      setButtons(buttons);
   }

   private void _setDialog(java.awt.Dialog aDialog,Component aComponent)
   {
      if ( dialog != null )
         dialog.removeWindowListener(this);
      dialog = aDialog;
      if (dialog == null)
         return;
      dialog.addWindowListener(this);
      java.awt.GridBagConstraints c;
      dialog.setLayout(new java.awt.GridBagLayout());
      c = new java.awt.GridBagConstraints();
      c.fill = java.awt.GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 1.0;
      c.gridwidth = java.awt.GridBagConstraints.REMAINDER; //end row
      dialog.add(aComponent,c);
      if ( bButtons != null )
      {
         java.awt.Panel controlPanel = new java.awt.Panel(new java.awt.FlowLayout());
         for ( int i = 0; i < buttons.length; i++ )
            controlPanel.add(bButtons[i]);
         c = new java.awt.GridBagConstraints();
         c.fill = java.awt.GridBagConstraints.BOTH;
         c.weightx = 0.0;
         c.weighty = 0.0;
         c.gridwidth = java.awt.GridBagConstraints.REMAINDER; //end row
         dialog.add(controlPanel,c);
      }
      dialog.pack();
      if ( getSize() != null )
         dialog.setSize(getSize());
   }

   /**
    * getButtons - get current button settings
    * @return String[]
    */
   public String[] getButtons() { return buttons; }
   /**
    * setButtons - set row of buttons for the dialog.
    * @param buttons java.lang.String[] Buttons labels to display
    */
   public synchronized void setButtons(String[] newButtons)
   {
      buttons = newButtons;
      if ( bButtons != null )
      {
         for ( int i = 0; i < bButtons.length; i++ )
            bButtons[i].removeActionListener(this);
         bButtons = null;
      }
      if ( buttons != null )
      {
         bButtons = new Button[buttons.length];
         for ( int i = 0; i < buttons.length; i++ )
         {
            bButtons[i] = new Button(buttons[i]);
            bButtons[i].addActionListener(this);
         }
      }
   }

   /**
    * Return the first Frame parent of a component.  null if none.
    * @return java.awt.Frame
    * @param c java.awt.Component
    */
   public static Frame getFrame(java.awt.Component c)
   {
      if ( c == null )
         return new java.awt.Frame();
      else if ( c instanceof Frame )
         return (Frame) c;
      else
         return getFrame(c.getParent());
   }

   /**
    * Return the button label selected by the user to close the Dialog.
    * null is returned if button was not used to close dialog
    * @return java.lang.String
    */
   public String getResult() { return result; }

   /**
    * Method to handle events for the ActionListener interface.
    * @param e java.awt.event.ActionEvent
    */
   public void actionPerformed(java.awt.event.ActionEvent e)
   {
      result = ((Button)e.getSource()).getLabel();
      try { dialog.setVisible(false); }
      catch (java.lang.Throwable exception) {}
   }
//       if (evt.getID() == java.awt.Event.WINDOW_DESTROY)
   public void windowClosing(WindowEvent e) { dialog.dispose(); }
   public void windowClosed(WindowEvent e) {}
   public void windowActivated(WindowEvent e) {}
   public void windowDeactivated(WindowEvent e) {}
   public void windowDeiconified(WindowEvent e) {}
   public void windowIconified(WindowEvent e) {}
   public void windowOpened(WindowEvent e) {}
   /**
    * Show a component
    * @param evt java.awt.Component
    */
   public String showComponent(java.awt.Component aComponent)
   {
      result = null;
      Frame parentFrame = getFrame(parent);
      _setDialog(new Dialog( parentFrame
                           , getTitle()
                           , true )
                , aComponent );
      if ( parentFrame != null )
         dialog.setLocation(parentFrame.getLocation());
      dialog.show();
      return result;
   }
   /**
    * Show an event
    * @param evt java.util.EventObject
    */
   public String showEvent(java.util.EventObject evt)
   {
      if ( evt instanceof IParameterEvent &&
            ((IParameterEvent)evt).getParameter() != null &&
            ((IParameterEvent)evt).getParameter() instanceof Throwable )
         return showException( (Throwable) ((IParameterEvent)evt).getParameter() );
      else
      {
         if ( getTitle() == null )
            setTitle(getString("Event"));
         return show(evt.toString());
      }
   }
   /**
    * Show a message
    * @param text java.lang.String
    */
   public synchronized String show(String text)
   {
      if ( getTitle() == null )
         setTitle(getString("Information"));
      textArea.setText( text );
      textArea.setEditable(false); // don't allow input
      return showComponent(textArea);
   }
   /**
    * Show a Throwable
    * @param e java.lang.Throwable
    */
   public String showException(Throwable e)
   {
      if ( printStackTrace ) e.printStackTrace();
      if ( getTitle() == null )
         setTitle(getString("Exception"));
      return show(IMessageBox.stringFor(e));
   }

   /**
    * report state of printStackTrace when exception thrown mode
    * @return boolean
    */
   public static boolean isPrintStackTrace() { return printStackTrace; }
   /**
    * enable/disable printStackTrace when exception thrown
    * @param enable boolean
    */
   public static void setPrintStackTrace(boolean enable)
   {
      printStackTrace = enable;
   }

   // resource access
   private static String getString( String id )
   {
      if ( resources != null )
         return resources.getString(id);
      else
         return id;
   }

   /**
    * get size when Dialog shown
    * @return java.awt.Dimension
    */
   public java.awt.Dimension getSize()
   {
      return size;
   }
   /**
    * set size when Dialog shown
    * @param newSize java.awt.Dimension
    */
   public void setSize(java.awt.Dimension newSize)
   {
      size = newSize;
   }

   /**
    * get dialog title
    * @return java.lang.String
    */
   public String getTitle() { return title; }
   /**
    * set dialog title
    * @param aTitle java.lang.String
    */
   public void setTitle(String aTitle) { title = aTitle; }

   /**
    * get dialog parent
    * @return java.awt.Component
    */
   public Component getParent() { return parent; }
   /**
    * Set dialog parent.  When shown, the dialog attempts to find
    * a frame that is the parent of this dialog.  If not found,
    * a new frame is constructed (and the dialog is not modal to that owner).
    * @param java.awt.Component aParent
    */
   public void setParent(Component aParent) { parent = aParent; }

}
