// Please refer to the readme on how to run this sample.

package COM.ibm.ivj.examples.database.minisamp.DB2;
import DB2gen.*;

import java.lang.*;
import java.util.*;

public class arud
{
   public static void main(String args[])
   {
      try
      {
         // Create the Datastore and Manager objects
         DepartmentDatastore theDepartmentDatastore = new DepartmentDatastore();
         DepartmentManager   theDeptMgr             = new DepartmentManager();
         Department          theDept                = new Department();

         // Connect to database
         System.out.println("Connecting to DEPARTMENT database...");
         if ( args.length > 1 )
            theDepartmentDatastore.connect( args[0], args[1] );
         else
            theDepartmentDatastore.connect();
         System.out.println("...Connected");

         // List all departments as they are
         System.out.println("Listing of all departments, sorted by name:");
         theDeptMgr.open( "ORDER BY DEPTNAME" );
         while( theDeptMgr.fetchNext() )
         {
            System.out.println( theDeptMgr.element().toString() );
         }
         theDeptMgr.close();

         // Add a new Department
         theDept.setDeptno(   "031" );
         theDept.setDeptname( "Data Access Builder Team    " );
         theDept.setMgrno(    "154326" );
         theDept.setAdmrdept(   "" );
         theDept.setLocation( "North York" );
         theDept.add();

         // delete department A00
         theDept.setDeptno(   "A00" );
         theDept.delete();

         // retrieve department D11 and change its location
         theDept.setDeptno(   "D11" );
         theDept.retrieve();
         theDept.setLocation( "Thornhill" );
         theDept.update();

         // List all departments again to show changes
         System.out.println("");
         System.out.println("Listing of all departments, sorted by name, after changes:");
         theDeptMgr.open( "ORDER BY DEPTNAME" );
         while( theDeptMgr.fetchNext() )
         {
            System.out.println( theDeptMgr.element().toString() );
         }
         theDeptMgr.close();


         // Rollback the changes so this sample can run again
         theDepartmentDatastore.rollback();

         // Disconnect from the database
         theDepartmentDatastore.disconnect();

         // All done
         System.out.println();
         System.out.println("Done");
       }

       // Catch all Throwables here and print out what information we can.
       catch (Throwable s)
       {
          System.out.println( "Throwable caught:" );
          System.out.println( "message: " + s.getMessage() );
          System.out.println( "Stack Trace:" );
          s.printStackTrace();
       }
   }
}
