/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.view;

import com.objectshare.base.util.OSIArray;
import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIInt2DHashtable;
import com.objectshare.base.util.OSIIntEnumeration;
import com.objectshare.base.util.OSIIntHashtable;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKModelChangedEvent;
import com.objectshare.grid.data.JKModelColsAddedEvent;
import com.objectshare.grid.data.JKModelColsChangedEvent;
import com.objectshare.grid.data.JKModelColsRemovedEvent;
import com.objectshare.grid.data.JKModelColsReorderEvent;
import com.objectshare.grid.data.JKModelRowsAddedEvent;
import com.objectshare.grid.data.JKModelRowsChangedEvent;
import com.objectshare.grid.data.JKModelRowsRemovedEvent;
import com.objectshare.grid.data.JKModelRowsReorderEvent;
import com.objectshare.grid.draw.JKDrawingContext;
import com.objectshare.grid.view.JKTableView;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class JKDisplayPolicy
implements Serializable {
    protected JKTableView owner;
    public JKDrawingContext tableDC;
    public JKDrawingContext topLeftHdrDC;
    public JKDrawingContext columnHdrDC;
    public JKDrawingContext rowHdrDC;
    public JKDrawingContext cellAreaDC;
    protected OSIIntHashtable columnDCs;
    protected OSIIntHashtable rowDCs;
    protected OSIInt2DHashtable cellDCs;
    protected Hashtable templates;

    public JKDisplayPolicy(JKTableView jKTableView) {
        this.owner = jKTableView;
        this.tableDC = new JKDrawingContext();
        this.topLeftHdrDC = this.tableDC.newChild();
        this.columnHdrDC = this.tableDC.newChild();
        this.rowHdrDC = this.tableDC.newChild();
        this.cellAreaDC = this.tableDC.newChild();
        this.resetDrawingAttributes();
    }

    public synchronized JKDrawingContext existingCellDrawingContext(int n, int n2) {
        JKDrawingContext jKDrawingContext = (JKDrawingContext)this.cellDCs.get(n, n2);
        if (jKDrawingContext != null) {
            return jKDrawingContext;
        }
        if (n > 0) {
            if (n2 > 0) {
                jKDrawingContext = (JKDrawingContext)this.rowDCs.get(n);
                if (jKDrawingContext != null) {
                    return jKDrawingContext;
                }
                jKDrawingContext = (JKDrawingContext)this.columnDCs.get(n2);
                if (jKDrawingContext != null) {
                    return jKDrawingContext;
                }
                return this.cellAreaDC;
            }
            return this.rowHdrDC;
        }
        if (n2 > 0) {
            return this.columnHdrDC;
        }
        return this.topLeftHdrDC;
    }

    public synchronized JKDrawingContext getCellDrawingContext(int n, int n2) {
        return this.basicGetCellDrawingContext(n, n2);
    }

    JKDrawingContext basicGetCellDrawingContext(int n, int n2) {
        JKDrawingContext jKDrawingContext = (JKDrawingContext)this.cellDCs.get(n, n2);
        if (jKDrawingContext != null) {
            return jKDrawingContext;
        }
        if (n > 0) {
            if (n2 > 0) {
                jKDrawingContext = this.cellAreaDC.newChild();
                JKDrawingContext jKDrawingContext2 = (JKDrawingContext)this.columnDCs.get(n2);
                if (jKDrawingContext2 != null) {
                    jKDrawingContext2.applyTo(jKDrawingContext);
                }
                if ((jKDrawingContext2 = (JKDrawingContext)this.rowDCs.get(n)) != null) {
                    jKDrawingContext2.applyTo(jKDrawingContext);
                }
            } else {
                jKDrawingContext = this.rowHdrDC.newChild();
            }
        } else {
            jKDrawingContext = n2 > 0 ? this.columnHdrDC.newChild() : this.topLeftHdrDC.newChild();
        }
        this.cellDCs.put(n, n2, (Object)jKDrawingContext);
        return jKDrawingContext;
    }

    public synchronized void setCellDrawingContext(int n, int n2, JKDrawingContext jKDrawingContext) {
        this.cellDCs.put(n, n2, (Object)jKDrawingContext);
    }

    public synchronized void applyCellTemplate(int n, int n2, String string) {
        this.applyCellTemplate(n, n2, this.getTemplate(string));
    }

    public synchronized void applyCellTemplate(int n, int n2, JKDrawingContext jKDrawingContext) {
        if (jKDrawingContext != null) {
            jKDrawingContext.applyTo(this.basicGetCellDrawingContext(n, n2));
        }
    }

    public synchronized OSIEnumeration getCellDrawingContexts(JKTableArea jKTableArea) {
        OSIArray oSIArray = new OSIArray();
        OSIEnumeration oSIEnumeration = jKTableArea.cells(this.owner.getCoordinator().getFirstRowNumber(), this.owner.getCoordinator().getFirstColumnNumber(), this.owner.getCoordinator().getNumberOfRows() + 1, this.owner.getCoordinator().getNumberOfColumns() + 1);
        while (oSIEnumeration.hasMoreElements()) {
            Point point = (Point)oSIEnumeration.nextElement();
            oSIArray.add((Object)this.basicGetCellDrawingContext(point.y, point.x));
        }
        return oSIArray.elements();
    }

    public synchronized OSIEnumeration existingCellAreaDrawingContexts() {
        OSIArray oSIArray = new OSIArray();
        oSIArray.add((Object)this.cellAreaDC);
        oSIArray.addAll((Enumeration)this.columnDCs.elements());
        oSIArray.addAll((Enumeration)this.rowDCs.elements());
        OSIEnumeration oSIEnumeration = this.cellDCs.keys();
        while (oSIEnumeration.hasMoreElements()) {
            Point point = (Point)oSIEnumeration.nextElement();
            if (point.x <= 0 || point.y <= 0) continue;
            oSIArray.add(this.cellDCs.get(point.y, point.x));
        }
        return oSIArray.elements();
    }

    public synchronized void applyCellTemplate(JKTableArea jKTableArea, String string) {
        this.applyCellTemplate(jKTableArea, this.getTemplate(string));
    }

    public synchronized void applyCellTemplate(JKTableArea jKTableArea, JKDrawingContext jKDrawingContext) {
        if (jKDrawingContext != null) {
            OSIEnumeration oSIEnumeration = this.getCellDrawingContexts(jKTableArea);
            while (oSIEnumeration.hasMoreElements()) {
                jKDrawingContext.applyTo((JKDrawingContext)oSIEnumeration.nextElement());
            }
        }
    }

    public synchronized JKDrawingContext existingRowDrawingContext(int n) {
        Object object = this.rowDCs.get(n);
        if (object != null) {
            return (JKDrawingContext)object;
        }
        return this.cellAreaDC;
    }

    public synchronized JKDrawingContext getRowDrawingContext(int n) {
        return this.basicGetRowDrawingContext(n);
    }

    JKDrawingContext basicGetRowDrawingContext(int n) {
        JKDrawingContext jKDrawingContext = (JKDrawingContext)this.rowDCs.get(n);
        if (jKDrawingContext != null) {
            return jKDrawingContext;
        }
        OSIIntEnumeration oSIIntEnumeration = this.columnDCs.keys();
        while (oSIIntEnumeration.hasMoreElements()) {
            int n2 = oSIIntEnumeration.nextElement();
            if (n2 <= 0) continue;
            this.basicGetCellDrawingContext(n, n2);
        }
        jKDrawingContext = this.cellAreaDC.newChild();
        this.rowDCs.put(n, (Object)jKDrawingContext);
        return jKDrawingContext;
    }

    public synchronized void setRowDrawingContext(int n, JKDrawingContext jKDrawingContext) {
        this.rowDCs.put(n, (Object)jKDrawingContext);
    }

    public synchronized void applyRowTemplate(int n, String string) {
        this.applyRowTemplate(n, this.getTemplate(string));
    }

    public synchronized void applyRowTemplate(int n, JKDrawingContext jKDrawingContext) {
        if (jKDrawingContext != null) {
            OSIEnumeration oSIEnumeration = this.getRowAndCellDrawingContexts(n);
            while (oSIEnumeration.hasMoreElements()) {
                jKDrawingContext.applyTo((JKDrawingContext)oSIEnumeration.nextElement());
            }
        }
    }

    public synchronized OSIEnumeration getRowAndCellDrawingContexts(JKTableArea jKTableArea) {
        OSIArray oSIArray = new OSIArray();
        OSIIntEnumeration oSIIntEnumeration = jKTableArea.rows(1, this.owner.getModel().getNumberOfRows());
        while (oSIIntEnumeration.hasMoreElements()) {
            oSIArray.addAll((Enumeration)this.getRowAndCellDrawingContexts(oSIIntEnumeration.nextElement()));
        }
        return oSIArray.elements();
    }

    public synchronized OSIEnumeration getRowAndCellDrawingContexts(int n) {
        OSIArray oSIArray = new OSIArray();
        oSIArray.add((Object)this.basicGetRowDrawingContext(n));
        OSIIntEnumeration oSIIntEnumeration = this.cellDCs.keysInRow(n);
        while (oSIIntEnumeration.hasMoreElements()) {
            int n2 = oSIIntEnumeration.nextElement();
            if (n2 <= 0) continue;
            oSIArray.add(this.cellDCs.get(n, n2));
        }
        return oSIArray.elements();
    }

    public synchronized void applyRowTemplate(JKTableArea jKTableArea, String string) {
        this.applyRowTemplate(jKTableArea, this.getTemplate(string));
    }

    public synchronized void applyRowTemplate(JKTableArea jKTableArea, JKDrawingContext jKDrawingContext) {
        if (jKDrawingContext != null) {
            OSIEnumeration oSIEnumeration = this.getRowAndCellDrawingContexts(jKTableArea);
            while (oSIEnumeration.hasMoreElements()) {
                jKDrawingContext.applyTo((JKDrawingContext)oSIEnumeration.nextElement());
            }
        }
    }

    public synchronized OSIEnumeration existingRowHeaderDrawingContexts() {
        OSIArray oSIArray = new OSIArray();
        oSIArray.add((Object)this.rowHdrDC);
        int n = this.owner.getCoordinator().getFirstColumnNumber();
        while (n < 1) {
            OSIIntEnumeration oSIIntEnumeration = this.cellDCs.keysInColumn(n);
            while (oSIIntEnumeration.hasMoreElements()) {
                int n2 = oSIIntEnumeration.nextElement();
                if (n2 <= 0) continue;
                oSIArray.add(this.cellDCs.get(n2, n));
            }
            ++n;
        }
        return oSIArray.elements();
    }

    public synchronized void applyRowHeaderTemplate(String string) {
        this.applyRowHeaderTemplate(this.getTemplate(string));
    }

    public synchronized void applyRowHeaderTemplate(JKDrawingContext jKDrawingContext) {
        if (jKDrawingContext != null) {
            OSIEnumeration oSIEnumeration = this.existingRowHeaderDrawingContexts();
            while (oSIEnumeration.hasMoreElements()) {
                jKDrawingContext.applyTo((JKDrawingContext)oSIEnumeration.nextElement());
            }
        }
    }

    public synchronized JKDrawingContext existingColumnDrawingContext(int n) {
        Object object = this.columnDCs.get(n);
        if (object != null) {
            return (JKDrawingContext)object;
        }
        return this.cellAreaDC;
    }

    public synchronized JKDrawingContext getColumnDrawingContext(int n) {
        return this.basicGetColumnDrawingContext(n);
    }

    JKDrawingContext basicGetColumnDrawingContext(int n) {
        JKDrawingContext jKDrawingContext = (JKDrawingContext)this.columnDCs.get(n);
        if (jKDrawingContext != null) {
            return jKDrawingContext;
        }
        OSIIntEnumeration oSIIntEnumeration = this.rowDCs.keys();
        while (oSIIntEnumeration.hasMoreElements()) {
            int n2 = oSIIntEnumeration.nextElement();
            if (n2 <= 0) continue;
            this.basicGetCellDrawingContext(n2, n);
        }
        jKDrawingContext = this.cellAreaDC.newChild();
        this.columnDCs.put(n, (Object)jKDrawingContext);
        return jKDrawingContext;
    }

    public synchronized void setColumnDrawingContext(int n, JKDrawingContext jKDrawingContext) {
        this.columnDCs.put(n, (Object)jKDrawingContext);
    }

    public synchronized void applyColumnTemplate(int n, String string) {
        this.applyColumnTemplate(n, this.getTemplate(string));
    }

    public synchronized void applyColumnTemplate(int n, JKDrawingContext jKDrawingContext) {
        if (jKDrawingContext != null) {
            OSIEnumeration oSIEnumeration = this.getColumnAndCellDrawingContexts(n);
            while (oSIEnumeration.hasMoreElements()) {
                jKDrawingContext.applyTo((JKDrawingContext)oSIEnumeration.nextElement());
            }
        }
    }

    public synchronized OSIEnumeration getColumnAndCellDrawingContexts(JKTableArea jKTableArea) {
        OSIArray oSIArray = new OSIArray();
        OSIIntEnumeration oSIIntEnumeration = jKTableArea.columns(1, this.owner.getModel().getNumberOfColumns());
        while (oSIIntEnumeration.hasMoreElements()) {
            oSIArray.addAll((Enumeration)this.getColumnAndCellDrawingContexts(oSIIntEnumeration.nextElement()));
        }
        return oSIArray.elements();
    }

    public synchronized OSIEnumeration getColumnAndCellDrawingContexts(int n) {
        OSIArray oSIArray = new OSIArray();
        oSIArray.add((Object)this.basicGetColumnDrawingContext(n));
        OSIIntEnumeration oSIIntEnumeration = this.cellDCs.keysInColumn(n);
        while (oSIIntEnumeration.hasMoreElements()) {
            int n2 = oSIIntEnumeration.nextElement();
            if (n2 <= 0) continue;
            oSIArray.add(this.cellDCs.get(n2, n));
        }
        return oSIArray.elements();
    }

    public synchronized void applyColumnTemplate(JKTableArea jKTableArea, String string) {
        this.applyColumnTemplate(jKTableArea, this.getTemplate(string));
    }

    public synchronized void applyColumnTemplate(JKTableArea jKTableArea, JKDrawingContext jKDrawingContext) {
        if (jKDrawingContext != null) {
            OSIEnumeration oSIEnumeration = this.getColumnAndCellDrawingContexts(jKTableArea);
            while (oSIEnumeration.hasMoreElements()) {
                jKDrawingContext.applyTo((JKDrawingContext)oSIEnumeration.nextElement());
            }
        }
    }

    public synchronized OSIEnumeration existingColumnHeaderDrawingContexts() {
        OSIArray oSIArray = new OSIArray();
        oSIArray.add((Object)this.columnHdrDC);
        int n = this.owner.getCoordinator().getFirstRowNumber();
        while (n < 1) {
            OSIIntEnumeration oSIIntEnumeration = this.cellDCs.keysInRow(n);
            while (oSIIntEnumeration.hasMoreElements()) {
                int n2 = oSIIntEnumeration.nextElement();
                if (n2 <= 0) continue;
                oSIArray.add(this.cellDCs.get(n, n2));
            }
            ++n;
        }
        return oSIArray.elements();
    }

    public synchronized void applyColumnHeaderTemplate(String string) {
        this.applyColumnHeaderTemplate(this.getTemplate(string));
    }

    public synchronized void applyColumnHeaderTemplate(JKDrawingContext jKDrawingContext) {
        if (jKDrawingContext != null) {
            OSIEnumeration oSIEnumeration = this.existingColumnHeaderDrawingContexts();
            while (oSIEnumeration.hasMoreElements()) {
                jKDrawingContext.applyTo((JKDrawingContext)oSIEnumeration.nextElement());
            }
        }
    }

    public synchronized OSIEnumeration existingTopLeftHeaderDrawingContexts() {
        OSIArray oSIArray = new OSIArray();
        oSIArray.add((Object)this.topLeftHdrDC);
        int n = this.owner.getCoordinator().getFirstRowNumber();
        while (n < 1) {
            int n2 = this.owner.getCoordinator().getFirstColumnNumber();
            while (n2 < 1) {
                oSIArray.addOnce((Object)this.existingCellDrawingContext(n, n2));
                ++n2;
            }
            ++n;
        }
        return oSIArray.elements();
    }

    public synchronized void applyTopLeftHeaderTemplate(String string) {
        this.applyTopLeftHeaderTemplate(this.getTemplate(string));
    }

    public synchronized void applyTopLeftHeaderTemplate(JKDrawingContext jKDrawingContext) {
        if (jKDrawingContext != null) {
            OSIEnumeration oSIEnumeration = this.existingTopLeftHeaderDrawingContexts();
            while (oSIEnumeration.hasMoreElements()) {
                jKDrawingContext.applyTo((JKDrawingContext)oSIEnumeration.nextElement());
            }
        }
    }

    public synchronized OSIEnumeration existingHeaderDrawingContexts() {
        OSIArray oSIArray = new OSIArray();
        oSIArray.addAll((Enumeration)this.existingTopLeftHeaderDrawingContexts());
        oSIArray.addAll((Enumeration)this.existingColumnHeaderDrawingContexts());
        oSIArray.addAll((Enumeration)this.existingRowHeaderDrawingContexts());
        return oSIArray.elements();
    }

    public synchronized void applyHeaderTemplate(String string) {
        this.applyHeaderTemplate(this.getTemplate(string));
    }

    public synchronized void applyHeaderTemplate(JKDrawingContext jKDrawingContext) {
        if (jKDrawingContext != null) {
            OSIEnumeration oSIEnumeration = this.existingHeaderDrawingContexts();
            while (oSIEnumeration.hasMoreElements()) {
                jKDrawingContext.applyTo((JKDrawingContext)oSIEnumeration.nextElement());
            }
        }
    }

    public synchronized void resetDrawingAttributes() {
        this.tableDC.reset();
        this.topLeftHdrDC.reset();
        this.topLeftHdrDC.initHeaderDrawingAttributes();
        this.columnHdrDC.reset();
        this.columnHdrDC.initButtonDrawingAttributes();
        this.rowHdrDC.reset();
        this.rowHdrDC.initButtonDrawingAttributes();
        this.cellAreaDC.reset();
        this.cellDCs = new OSIInt2DHashtable();
        this.columnDCs = new OSIIntHashtable();
        this.rowDCs = new OSIIntHashtable();
    }

    public synchronized OSIEnumeration existingDrawingContexts() {
        OSIArray oSIArray = new OSIArray();
        oSIArray.add((Object)this.tableDC);
        oSIArray.add((Object)this.topLeftHdrDC);
        oSIArray.add((Object)this.columnHdrDC);
        oSIArray.add((Object)this.rowHdrDC);
        oSIArray.add((Object)this.cellAreaDC);
        oSIArray.addAll((Enumeration)this.columnDCs.elements());
        oSIArray.addAll((Enumeration)this.rowDCs.elements());
        oSIArray.addAll((Enumeration)this.cellDCs.elements());
        return oSIArray.elements();
    }

    public synchronized OSIEnumeration getDrawingContexts(JKTableArea jKTableArea) {
        if (jKTableArea == JKTableArea.full) {
            return this.existingDrawingContexts();
        }
        OSIArray oSIArray = new OSIArray();
        oSIArray.addAllOnce((Enumeration)this.getColumnAndCellDrawingContexts(jKTableArea));
        oSIArray.addAllOnce((Enumeration)this.getRowAndCellDrawingContexts(jKTableArea));
        oSIArray.addAllOnce((Enumeration)this.getCellDrawingContexts(jKTableArea));
        return oSIArray.elements();
    }

    public void modelChanged(JKModelChangedEvent jKModelChangedEvent) {
    }

    public void modelRowsChanged(JKModelRowsChangedEvent jKModelRowsChangedEvent) {
    }

    public void modelRowsAdded(JKModelRowsAddedEvent jKModelRowsAddedEvent) {
        this.cellDCs.insertRows(jKModelRowsAddedEvent.getFirst(), jKModelRowsAddedEvent.getSize());
        this.rowDCs.insertAll(jKModelRowsAddedEvent.getFirst(), jKModelRowsAddedEvent.getSize());
    }

    public void modelRowsRemoved(JKModelRowsRemovedEvent jKModelRowsRemovedEvent) {
        this.cellDCs.removeRows(jKModelRowsRemovedEvent.getFirst(), jKModelRowsRemovedEvent.getSize());
        this.rowDCs.removeKeys(jKModelRowsRemovedEvent.getFirst(), jKModelRowsRemovedEvent.getSize());
    }

    public void modelRowsReordered(JKModelRowsReorderEvent jKModelRowsReorderEvent) {
        this.cellDCs.reorderRows(jKModelRowsReorderEvent.getFirst(), jKModelRowsReorderEvent.getReorderMap());
        this.rowDCs.reorderKeys(jKModelRowsReorderEvent.getFirst(), jKModelRowsReorderEvent.getReorderMap());
    }

    public void modelColumnsChanged(JKModelColsChangedEvent jKModelColsChangedEvent) {
    }

    public void modelColumnsAdded(JKModelColsAddedEvent jKModelColsAddedEvent) {
        this.cellDCs.insertColumns(jKModelColsAddedEvent.getFirst(), jKModelColsAddedEvent.getSize());
        this.columnDCs.insertAll(jKModelColsAddedEvent.getFirst(), jKModelColsAddedEvent.getSize());
    }

    public void modelColumnsRemoved(JKModelColsRemovedEvent jKModelColsRemovedEvent) {
        this.cellDCs.removeColumns(jKModelColsRemovedEvent.getFirst(), jKModelColsRemovedEvent.getSize());
        this.columnDCs.removeKeys(jKModelColsRemovedEvent.getFirst(), jKModelColsRemovedEvent.getSize());
    }

    public void modelColumnsReordered(JKModelColsReorderEvent jKModelColsReorderEvent) {
        this.cellDCs.reorderColumns(jKModelColsReorderEvent.getFirst(), jKModelColsReorderEvent.getReorderMap());
        this.columnDCs.reorderKeys(jKModelColsReorderEvent.getFirst(), jKModelColsReorderEvent.getReorderMap());
    }

    public void addTemplate(String string, JKDrawingContext jKDrawingContext) {
        this.templates.put(string, jKDrawingContext);
    }

    public void removeTemplate(String string) {
        this.templates.remove(string);
    }

    public JKDrawingContext getTemplate(String string) {
        JKDrawingContext jKDrawingContext;
        if (this.templates != null && (jKDrawingContext = (JKDrawingContext)this.templates.get(string)) != null) {
            return jKDrawingContext;
        }
        return JKDrawingContext.getTemplate(string);
    }
}

