/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.tool;

import com.objectshare.grid.list.JKTableList;
import com.objectshare.grid.list.JKTableListAdapter;
import com.objectshare.grid.tool.JKTableTool;
import java.awt.Event;

public class JKCompositeTool
extends JKTableTool {
    public static int MAX_MODIFIER = 15;
    public JKTableTool[] actions;
    public int[] modifiers;

    public JKCompositeTool() {
        this.initialize();
    }

    public JKCompositeTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter) {
        this.owner = jKTableList;
        this.adapter = jKTableListAdapter;
        this.initialize();
    }

    public JKTableTool getTool() {
        return this.getTool(0);
    }

    public void setTool(JKTableTool jKTableTool) {
        this.setTool(0, jKTableTool);
    }

    public JKTableTool getTool(int n) {
        return this.actions[n];
    }

    public void setTool(int n, JKTableTool jKTableTool) {
        if (n > MAX_MODIFIER) {
            throw new IllegalArgumentException("bad composite tool modifiers: " + n);
        }
        this.actions[n] = jKTableTool;
        if (jKTableTool == null) {
            return;
        }
        jKTableTool.setOwner(this.owner);
        jKTableTool.setAdapter(this.adapter);
    }

    public int getModifiers(int n) {
        return this.modifiers[n];
    }

    public void setTool(int n, JKTableTool jKTableTool, int n2) {
        this.setTool(n, jKTableTool);
        this.mapModifiers(n, n2);
    }

    public void mapModifiers(int n, int n2) {
        if (n > MAX_MODIFIER) {
            throw new IllegalArgumentException("bad composite tool modifiers: " + n);
        }
        this.modifiers[n] = n2;
    }

    protected void initialize() {
        this.actions = new JKTableTool[MAX_MODIFIER + 1];
        this.modifiers = new int[MAX_MODIFIER + 1];
        int n = 0;
        while (n <= MAX_MODIFIER) {
            this.modifiers[n] = n;
            ++n;
        }
    }

    public void setOwner(JKTableList jKTableList) {
        super.setOwner(jKTableList);
        int n = 0;
        while (n <= MAX_MODIFIER) {
            if (this.actions[n] != null) {
                this.actions[n].setOwner(jKTableList);
            }
            ++n;
        }
    }

    public void setAdapter(JKTableListAdapter jKTableListAdapter) {
        super.setAdapter(jKTableListAdapter);
        int n = 0;
        while (n <= MAX_MODIFIER) {
            if (this.actions[n] != null) {
                this.actions[n].setAdapter(jKTableListAdapter);
            }
            ++n;
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        Event event2 = event;
        int n3 = event2.modifiers & MAX_MODIFIER;
        JKTableTool jKTableTool = this.actions[n3];
        if (jKTableTool == null) {
            return false;
        }
        int n4 = this.modifiers[n3];
        if (n4 != event2.modifiers) {
            Event event3 = new Event(event2.target, event2.when, event2.id, event2.x, event2.y, event2.key, n4, event2.arg);
            event3.clickCount = event2.clickCount;
            event3.evt = event2.evt;
            event2 = event3;
        }
        return jKTableTool.mouseDown(event2, n, n2);
    }
}

