/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.draw;

import com.objectshare.grid.data.JKObservable;
import com.objectshare.grid.draw.JKDrawnObject;
import com.objectshare.grid.view.JKDrawViewEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

public class JKImage
extends JKObservable
implements JKDrawnObject {
    public transient Image image;
    public int stretch = 0;
    public static final int NO_STRETCH = 1;
    public static final int RECTANGULAR_STRETCH = 2;
    public static final int PROPORTIONAL_STRETCH = 3;
    public static final int FULL_STRETCH = 4;

    protected JKImage() {
    }

    public JKImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("null image");
        }
        this.image = image;
    }

    public JKImage(Image image, int n) {
        this(image);
        this.stretch = n;
    }

    public void jkPreDraw(JKDrawViewEvent jKDrawViewEvent) {
    }

    public void jkDraw(JKDrawViewEvent jKDrawViewEvent, Rectangle rectangle) {
        JKImage.drawImage(this.image, rectangle, null, jKDrawViewEvent.graphics, jKDrawViewEvent.getBackColor(), jKDrawViewEvent.getHorizontalJustification(), jKDrawViewEvent.getVerticalJustification(), this.stretch != 0 ? this.stretch : jKDrawViewEvent.getScale());
    }

    public Dimension jkExtent(JKDrawViewEvent jKDrawViewEvent) {
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }

    public static synchronized void drawImage(Image image, Rectangle rectangle, ImageObserver imageObserver, Graphics graphics, Color color, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n3 == 4) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, imageObserver);
            return;
        }
        int n6 = image.getWidth(imageObserver);
        int n7 = image.getHeight(imageObserver);
        if (n6 == rectangle.width && n7 == rectangle.height) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, imageObserver);
            return;
        }
        switch (n3) {
            case 2: {
                int n8 = rectangle.width - n6;
                n5 = rectangle.height - n7;
                n4 = n8 < n5 ? n8 : n5;
                n6 += n4;
                n7 += n4;
                break;
            }
            case 3: {
                float f = (float)rectangle.width / (float)n6;
                float f2 = (float)rectangle.height / (float)n7;
                if (f < f2) {
                    if (n6 == rectangle.width) break;
                    n6 = rectangle.width;
                    n7 = (int)((float)n7 * f);
                    break;
                }
                if (n7 == rectangle.height) break;
                n6 = (int)((float)n6 * f2);
                n7 = rectangle.height;
                break;
            }
        }
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.setColor(color);
        graphics2.fillRect(0, 0, rectangle.width, rectangle.height);
        if (n6 > 0 && n7 > 0) {
            n5 = 0;
            switch (n) {
                case 3: {
                    n5 = rectangle.width - n6;
                    break;
                }
                case 2: {
                    n5 = (rectangle.width - n6) / 2;
                    break;
                }
            }
            n4 = 0;
            switch (n2) {
                case 3: {
                    n4 += rectangle.height - n7;
                    break;
                }
                case 2: {
                    n4 += (rectangle.height - n7) / 2;
                    break;
                }
            }
            graphics2.drawImage(image, n5, n4, n6, n7, imageObserver);
        }
        graphics2.dispose();
    }
}

