/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.base.util;

import com.objectshare.base.util.OSIEnumeration;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class OSIArray
implements Serializable {
    int elementCount;
    Object[] elementArray;

    public OSIArray() {
        this(0);
    }

    public OSIArray(int n) {
        this.elementCount = 0;
        this.elementArray = new Object[n];
    }

    public OSIArray(Object[] objectArray) {
        this.elementCount = objectArray.length;
        this.elementArray = objectArray;
    }

    public OSIArray(Object[] objectArray, int n) {
        this.elementCount = objectArray.length;
        this.elementArray = new Object[this.elementCount > n ? this.elementCount : n];
        System.arraycopy(objectArray, 0, this.elementArray, 0, this.elementCount);
    }

    public int size() {
        return this.elementCount;
    }

    public boolean contains(Object object) {
        int n = 0;
        while (n < this.elementCount) {
            if (this.elementArray[n] == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void add(Object object) {
        if (this.elementArray.length < this.elementCount + 1) {
            Object[] objectArray = new Object[this.elementCount * 2 + 2];
            System.arraycopy(this.elementArray, 0, objectArray, 0, this.elementCount);
            this.elementArray = objectArray;
        }
        this.elementArray[this.elementCount++] = object;
    }

    public boolean addOnce(Object object) {
        if (this.contains(object)) {
            return false;
        }
        this.add(object);
        return true;
    }

    public void addAll(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.add(objectArray[n]);
            ++n;
        }
    }

    public void addAll(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement());
        }
    }

    public void addAllOnce(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.addOnce(objectArray[n]);
            ++n;
        }
    }

    public void addAllOnce(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addOnce(enumeration.nextElement());
        }
    }

    public boolean remove(Object object) {
        int n = this.elementCount;
        while (--n >= 0) {
            if (this.elementArray[n] != object) continue;
            System.arraycopy(this.elementArray, n + 1, this.elementArray, n, this.elementCount - n - 1);
            this.elementArray[--this.elementCount] = null;
            return true;
        }
        return false;
    }

    public void trim() {
        if (this.elementCount < this.elementArray.length) {
            Object[] objectArray = new Object[this.elementCount];
            System.arraycopy(this.elementArray, 0, objectArray, 0, this.elementCount);
            this.elementArray = objectArray;
        }
    }

    public OSIEnumeration elements() {
        this.trim();
        return OSIEnumeration.newFor(this.elementArray);
    }

    public Object[] toArray() {
        this.trim();
        return this.elementArray;
    }

    public Object[] copyArray() {
        return OSIEnumeration.copyArray(this.toArray());
    }

    public Vector toVector() {
        return this.elements().toVector();
    }
}

