/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.base.event.OSIEventMulticaster;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.event.GFDrawingKeyEvent;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.tool.GFConnectionHandle;
import com.objectshare.gf.tool.GFToolPaletteElement;
import com.objectshare.gf.tool.event.GFToolDelegate;
import com.objectshare.gf.tool.event.GFToolDelegateMulticaster;
import com.objectshare.gf.tool.event.GFToolEvent;
import com.objectshare.gf.tool.event.GFToolEventMulticaster;
import com.objectshare.gf.tool.event.GFToolKeyEvent;
import com.objectshare.gf.tool.event.GFToolKeyListener;
import com.objectshare.gf.tool.event.GFToolListener;
import com.objectshare.gf.tool.event.GFToolMouseEvent;
import com.objectshare.gf.tool.event.GFToolMouseListener;
import java.awt.Cursor;
import java.io.Serializable;
import java.util.EventListener;

public class GFTool
extends GFToolPaletteElement
implements GFToolDelegate,
Serializable {
    protected GFDrawingManager manager;
    protected GFTool parentTool;
    protected GFToolDelegate toolDelegate;
    protected GFTool subTool;
    protected boolean completing = false;
    protected Cursor cursor = this.getDefaultCursor();
    protected Cursor oldCursor = Cursor.getPredefinedCursor(0);
    protected GFToolListener toolListener;
    protected GFToolMouseListener mouseListener;
    protected GFToolKeyListener keyListener;

    public GFDrawingManager getManager() {
        return this.manager;
    }

    public boolean isActive() {
        return this.manager != null;
    }

    public synchronized void activated(GFDrawingManager gFDrawingManager) {
        if (this.manager == gFDrawingManager) {
            return;
        }
        this.manager = gFDrawingManager;
        this.oldCursor = this.manager.getCursor();
        this.manager.setCursor(this.getCursor());
        this.basicActivated(gFDrawingManager);
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.activated(gFDrawingManager);
        }
    }

    protected void basicActivated(GFDrawingManager gFDrawingManager) {
    }

    public synchronized void deactivated(GFDrawingManager gFDrawingManager) {
        if (this.manager == null) {
            return;
        }
        this.complete();
        if (this.manager == null) {
            return;
        }
        this.basicDeactivated(gFDrawingManager);
        gFDrawingManager.setCursor(this.oldCursor);
        this.manager = null;
    }

    protected void basicDeactivated(GFDrawingManager gFDrawingManager) {
    }

    public void beginDelegationFor(GFTool gFTool) {
        this.parentTool = gFTool;
    }

    public void endDelegationFor(GFTool gFTool) {
        this.parentTool = null;
    }

    public GFTool getParent() {
        return this.parentTool;
    }

    public void undelegate() {
        GFTool gFTool = this.getParent();
        if (gFTool != null) {
            gFTool.removeDelegate(this);
        }
    }

    public boolean hasDelegates() {
        return this.toolDelegate != null;
    }

    public boolean hasDelegate(GFToolDelegate gFToolDelegate) {
        return OSIEventMulticaster.contains((EventListener)this.toolDelegate, (EventListener)gFToolDelegate);
    }

    public void addDelegate(GFToolDelegate gFToolDelegate) {
        this.toolDelegate = GFToolDelegateMulticaster.add(this.toolDelegate, gFToolDelegate);
        gFToolDelegate.beginDelegationFor(this);
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager != null) {
            gFToolDelegate.activated(gFDrawingManager);
        }
    }

    public void addDelegates(GFToolDelegate[] gFToolDelegateArray) {
        int n = 0;
        while (n < gFToolDelegateArray.length) {
            this.addDelegate(gFToolDelegateArray[n]);
            ++n;
        }
    }

    public void removeDelegate(GFToolDelegate gFToolDelegate) {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager != null) {
            gFToolDelegate.deactivated(gFDrawingManager);
        }
        this.toolDelegate = GFToolDelegateMulticaster.remove(this.toolDelegate, gFToolDelegate);
        gFToolDelegate.endDelegationFor(this);
    }

    public GFTool setSubTool(GFTool gFTool) {
        this.subTool = gFTool;
        return this;
    }

    public GFTool getSubTool() {
        return this.subTool;
    }

    public synchronized void complete() {
        if (this.completing) {
            return;
        }
        this.completing = true;
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.complete();
        }
        this.completed();
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
        this.triggerCompletedEvent();
        this.undelegate();
        this.completing = false;
    }

    protected void completed() {
    }

    public void processMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        if (this.hasDelegates()) {
            this.processMouseDownInDelegates(gFDrawingMouseEvent);
        } else {
            this.basicProcessMouseDown(gFDrawingMouseEvent);
            if (!gFDrawingMouseEvent.isHandled() && this.subTool != null) {
                this.subTool.processSubToolMouseDown(gFDrawingMouseEvent, this, this.getManager());
            }
        }
        this.triggerMouseDownEvent(gFDrawingMouseEvent);
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
    }

    protected void basicProcessMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    protected void processSubToolMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent, GFTool gFTool, GFDrawingManager gFDrawingManager) {
        if (!this.isActive()) {
            this.activated(gFDrawingManager);
            this.basicProcessMouseDown(gFDrawingMouseEvent);
            if (gFDrawingMouseEvent.isHandled()) {
                gFTool.addDelegate(this);
                return;
            }
            this.deactivated(gFDrawingManager);
        }
        if (this.subTool != null) {
            this.subTool.processSubToolMouseDown(gFDrawingMouseEvent, gFTool, gFDrawingManager);
        }
    }

    protected void processMouseDownInDelegates(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.processMouseDown(gFDrawingMouseEvent);
        }
    }

    public void processMouseDownInDelegate(GFToolDelegate gFToolDelegate, GFDrawingMouseEvent gFDrawingMouseEvent) {
        this.addDelegate(gFToolDelegate);
        this.processMouseDownInDelegates(gFDrawingMouseEvent);
    }

    public void processMouseDownInDelegates(GFToolDelegate[] gFToolDelegateArray, GFDrawingMouseEvent gFDrawingMouseEvent) {
        this.addDelegates(gFToolDelegateArray);
        this.processMouseDownInDelegates(gFDrawingMouseEvent);
    }

    public void processMouseDrag(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        this.processMouseDragInDelegates(gFDrawingMouseEvent);
        this.basicProcessMouseDrag(gFDrawingMouseEvent);
        this.triggerMouseDragEvent(gFDrawingMouseEvent);
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
    }

    protected void basicProcessMouseDrag(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    protected void processMouseDragInDelegates(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.processMouseDrag(gFDrawingMouseEvent);
        }
    }

    public void processMouseUp(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        gFDrawingMouseEvent.setHandled(false);
        this.processMouseUpInDelegates(gFDrawingMouseEvent);
        this.basicProcessMouseUp(gFDrawingMouseEvent);
        this.triggerMouseUpEvent(gFDrawingMouseEvent);
        if (!this.hasDelegates()) {
            this.complete();
        }
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
    }

    protected void basicProcessMouseUp(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    public void processMouseUpInDelegates(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.processMouseUp(gFDrawingMouseEvent);
        }
    }

    public void processMouseClick(GFDrawingMouseEvent gFDrawingMouseEvent) {
        boolean bl = this.hasDelegates();
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        this.processMouseClickInDelegates(gFDrawingMouseEvent);
        this.basicProcessMouseClick(gFDrawingMouseEvent);
        if (bl) {
            if (!this.hasDelegates()) {
                this.complete();
            }
        } else if (!gFDrawingMouseEvent.isHandled() && this.subTool != null) {
            this.subTool.processSubToolMouseClick(gFDrawingMouseEvent, this, this.getManager());
        }
        this.triggerMouseClickEvent(gFDrawingMouseEvent);
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
    }

    protected void basicProcessMouseClick(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    protected void processSubToolMouseClick(GFDrawingMouseEvent gFDrawingMouseEvent, GFTool gFTool, GFDrawingManager gFDrawingManager) {
        if (!this.isActive()) {
            this.activated(gFDrawingManager);
            this.basicProcessMouseClick(gFDrawingMouseEvent);
            this.deactivated(gFDrawingManager);
        }
        if (!gFDrawingMouseEvent.isHandled() && this.subTool != null) {
            this.subTool.processSubToolMouseClick(gFDrawingMouseEvent, gFTool, gFDrawingManager);
        }
    }

    protected void processMouseClickInDelegates(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.processMouseClick(gFDrawingMouseEvent);
        }
    }

    public void processMouseMove(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        this.processMouseMoveInDelegates(gFDrawingMouseEvent);
        if (!gFDrawingMouseEvent.isHandled()) {
            this.basicProcessMouseMove(gFDrawingMouseEvent);
        }
        if (!gFDrawingMouseEvent.isHandled() && this.subTool != null) {
            this.subTool.processSubToolMouseMove(gFDrawingMouseEvent, this, this.getManager());
        }
        this.triggerMouseMoveEvent(gFDrawingMouseEvent);
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
    }

    protected void basicProcessMouseMove(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    protected void processSubToolMouseMove(GFDrawingMouseEvent gFDrawingMouseEvent, GFTool gFTool, GFDrawingManager gFDrawingManager) {
        if (!this.isActive()) {
            this.activated(gFDrawingManager);
            this.basicProcessMouseMove(gFDrawingMouseEvent);
            this.deactivated(gFDrawingManager);
        }
        if (!gFDrawingMouseEvent.isHandled() && this.subTool != null) {
            this.subTool.processSubToolMouseMove(gFDrawingMouseEvent, gFTool, gFDrawingManager);
        }
    }

    protected void processMouseMoveInDelegates(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.processMouseMove(gFDrawingMouseEvent);
        }
    }

    public void processMouseEnter(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        this.processMouseEnterInDelegates(gFDrawingMouseEvent);
        this.basicProcessMouseEnter(gFDrawingMouseEvent);
        this.triggerMouseEnterEvent(gFDrawingMouseEvent);
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
    }

    protected void basicProcessMouseEnter(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    protected void processMouseEnterInDelegates(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.processMouseEnter(gFDrawingMouseEvent);
        }
    }

    public void processMouseExit(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        this.processMouseExitInDelegates(gFDrawingMouseEvent);
        this.basicProcessMouseExit(gFDrawingMouseEvent);
        this.triggerMouseExitEvent(gFDrawingMouseEvent);
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
    }

    protected void basicProcessMouseExit(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    protected void processMouseExitInDelegates(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.processMouseExit(gFDrawingMouseEvent);
        }
    }

    public void processKeyDown(GFDrawingKeyEvent gFDrawingKeyEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        this.processKeyDownInDelegates(gFDrawingKeyEvent);
        if (!gFDrawingKeyEvent.isHandled()) {
            this.basicProcessKeyDown(gFDrawingKeyEvent);
        }
        if (!gFDrawingKeyEvent.isHandled() && this.subTool != null) {
            this.subTool.processSubToolKeyDown(gFDrawingKeyEvent, this, this.getManager());
        }
        this.triggerKeyDownEvent(gFDrawingKeyEvent);
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
    }

    protected void basicProcessKeyDown(GFDrawingKeyEvent gFDrawingKeyEvent) {
    }

    protected void processSubToolKeyDown(GFDrawingKeyEvent gFDrawingKeyEvent, GFTool gFTool, GFDrawingManager gFDrawingManager) {
        if (!this.isActive()) {
            this.activated(gFDrawingManager);
            this.basicProcessKeyDown(gFDrawingKeyEvent);
            this.deactivated(gFDrawingManager);
        }
        if (!gFDrawingKeyEvent.isHandled() && this.subTool != null) {
            this.subTool.processSubToolKeyDown(gFDrawingKeyEvent, gFTool, gFDrawingManager);
        }
    }

    protected void processKeyDownInDelegates(GFDrawingKeyEvent gFDrawingKeyEvent) {
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.processKeyDown(gFDrawingKeyEvent);
        }
    }

    public void processKeyTyped(GFDrawingKeyEvent gFDrawingKeyEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        this.processKeyTypedInDelegates(gFDrawingKeyEvent);
        if (!gFDrawingKeyEvent.isHandled()) {
            this.basicProcessKeyTyped(gFDrawingKeyEvent);
        }
        if (!gFDrawingKeyEvent.isHandled() && this.subTool != null) {
            this.subTool.processSubToolKeyTyped(gFDrawingKeyEvent, this, this.getManager());
        }
        this.triggerKeyTypedEvent(gFDrawingKeyEvent);
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
    }

    protected void basicProcessKeyTyped(GFDrawingKeyEvent gFDrawingKeyEvent) {
    }

    protected void processSubToolKeyTyped(GFDrawingKeyEvent gFDrawingKeyEvent, GFTool gFTool, GFDrawingManager gFDrawingManager) {
        if (!this.isActive()) {
            this.activated(gFDrawingManager);
            this.basicProcessKeyTyped(gFDrawingKeyEvent);
            this.deactivated(gFDrawingManager);
        }
        if (!gFDrawingKeyEvent.isHandled() && this.subTool != null) {
            this.subTool.processSubToolKeyTyped(gFDrawingKeyEvent, gFTool, gFDrawingManager);
        }
    }

    protected void processKeyTypedInDelegates(GFDrawingKeyEvent gFDrawingKeyEvent) {
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.processKeyTyped(gFDrawingKeyEvent);
        }
    }

    public void processKeyUp(GFDrawingKeyEvent gFDrawingKeyEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        gFDrawingManager.disableRedraw();
        this.processKeyUpInDelegates(gFDrawingKeyEvent);
        if (!gFDrawingKeyEvent.isHandled()) {
            this.basicProcessKeyUp(gFDrawingKeyEvent);
        }
        if (!gFDrawingKeyEvent.isHandled() && this.subTool != null) {
            this.subTool.processSubToolKeyUp(gFDrawingKeyEvent, this, this.getManager());
        }
        this.triggerKeyUpEvent(gFDrawingKeyEvent);
        gFDrawingManager.enableRedraw();
        gFDrawingManager.redraw();
    }

    protected void basicProcessKeyUp(GFDrawingKeyEvent gFDrawingKeyEvent) {
    }

    protected void processSubToolKeyUp(GFDrawingKeyEvent gFDrawingKeyEvent, GFTool gFTool, GFDrawingManager gFDrawingManager) {
        if (!this.isActive()) {
            this.activated(gFDrawingManager);
            this.basicProcessKeyUp(gFDrawingKeyEvent);
            this.deactivated(gFDrawingManager);
        }
        if (!gFDrawingKeyEvent.isHandled() && this.subTool != null) {
            this.subTool.processSubToolKeyUp(gFDrawingKeyEvent, gFTool, gFDrawingManager);
        }
    }

    protected void processKeyUpInDelegates(GFDrawingKeyEvent gFDrawingKeyEvent) {
        GFToolDelegate gFToolDelegate = this.toolDelegate;
        if (gFToolDelegate != null) {
            gFToolDelegate.processKeyUp(gFDrawingKeyEvent);
        }
    }

    protected void selectGO(GFGO gFGO, GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFGO.isSelected()) {
            if (gFDrawingMouseEvent.isControlDown()) {
                gFGO.unselect();
                return;
            }
        } else {
            if (!gFDrawingMouseEvent.isControlDown() && !gFDrawingMouseEvent.isShiftDown()) {
                gFDrawingManager.unselectAll();
            }
            gFGO.select();
        }
    }

    public GFHandle handleContaining(GF2DPoint gF2DPoint) {
        return this.getManager().handleContaining(gF2DPoint);
    }

    public GFGOArray handlesContaining(GF2DPoint gF2DPoint) {
        return this.getManager().handlesContaining(gF2DPoint);
    }

    public GFConnectionHandle connectionHandleContaining(GF2DPoint gF2DPoint) {
        GFGOArray gFGOArray = this.handlesContaining(gF2DPoint);
        int n = gFGOArray.size() - 1;
        while (n >= 0) {
            GFGO gFGO = gFGOArray.elementAt(n);
            if (gFGO instanceof GFConnectionHandle) {
                return (GFConnectionHandle)gFGO;
            }
            --n;
        }
        return null;
    }

    public GFGO graphicObjectContaining(GF2DPoint gF2DPoint) {
        return this.getManager().graphicObjectContaining(gF2DPoint);
    }

    public GFGOArray graphicObjectsContaining(GF2DPoint gF2DPoint) {
        return this.getManager().graphicObjectsContaining(gF2DPoint);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public Cursor getDefaultCursor() {
        return Cursor.getPredefinedCursor(0);
    }

    public void addToolListener(GFToolListener gFToolListener) {
        this.toolListener = GFToolEventMulticaster.add(this.toolListener, gFToolListener);
    }

    public void removeToolListener(GFToolListener gFToolListener) {
        this.toolListener = GFToolEventMulticaster.remove(this.toolListener, gFToolListener);
    }

    public void triggerCompletedEvent() {
        GFToolListener gFToolListener = this.toolListener;
        if (gFToolListener != null) {
            gFToolListener.toolCompleted(new GFToolEvent(this));
        }
    }

    public void addToolMouseListener(GFToolMouseListener gFToolMouseListener) {
        this.mouseListener = GFToolEventMulticaster.add(this.mouseListener, gFToolMouseListener);
    }

    public void removeToolMouseListener(GFToolMouseListener gFToolMouseListener) {
        this.mouseListener = GFToolEventMulticaster.remove(this.mouseListener, gFToolMouseListener);
    }

    public void triggerMouseDownEvent(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolMouseListener gFToolMouseListener = this.mouseListener;
        if (gFToolMouseListener != null) {
            boolean bl = gFDrawingMouseEvent.isHandled();
            gFToolMouseListener.toolMouseDown(new GFToolMouseEvent(this, gFDrawingMouseEvent));
            gFDrawingMouseEvent.setHandled(bl);
        }
    }

    public void triggerMouseDragEvent(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolMouseListener gFToolMouseListener = this.mouseListener;
        if (gFToolMouseListener != null) {
            boolean bl = gFDrawingMouseEvent.isHandled();
            gFToolMouseListener.toolMouseDrag(new GFToolMouseEvent(this, gFDrawingMouseEvent));
            gFDrawingMouseEvent.setHandled(bl);
        }
    }

    public void triggerMouseUpEvent(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolMouseListener gFToolMouseListener = this.mouseListener;
        if (gFToolMouseListener != null) {
            boolean bl = gFDrawingMouseEvent.isHandled();
            gFToolMouseListener.toolMouseUp(new GFToolMouseEvent(this, gFDrawingMouseEvent));
            gFDrawingMouseEvent.setHandled(bl);
        }
    }

    public void triggerMouseClickEvent(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolMouseListener gFToolMouseListener = this.mouseListener;
        if (gFToolMouseListener != null) {
            boolean bl = gFDrawingMouseEvent.isHandled();
            gFToolMouseListener.toolMouseClick(new GFToolMouseEvent(this, gFDrawingMouseEvent));
            gFDrawingMouseEvent.setHandled(bl);
        }
    }

    public void triggerMouseMoveEvent(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolMouseListener gFToolMouseListener = this.mouseListener;
        if (gFToolMouseListener != null) {
            boolean bl = gFDrawingMouseEvent.isHandled();
            gFToolMouseListener.toolMouseMove(new GFToolMouseEvent(this, gFDrawingMouseEvent));
            gFDrawingMouseEvent.setHandled(bl);
        }
    }

    public void triggerMouseEnterEvent(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolMouseListener gFToolMouseListener = this.mouseListener;
        if (gFToolMouseListener != null) {
            boolean bl = gFDrawingMouseEvent.isHandled();
            gFToolMouseListener.toolMouseEnter(new GFToolMouseEvent(this, gFDrawingMouseEvent));
            gFDrawingMouseEvent.setHandled(bl);
        }
    }

    public void triggerMouseExitEvent(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFToolMouseListener gFToolMouseListener = this.mouseListener;
        if (gFToolMouseListener != null) {
            boolean bl = gFDrawingMouseEvent.isHandled();
            gFToolMouseListener.toolMouseExit(new GFToolMouseEvent(this, gFDrawingMouseEvent));
            gFDrawingMouseEvent.setHandled(bl);
        }
    }

    public void addToolKeyListener(GFToolKeyListener gFToolKeyListener) {
        this.keyListener = GFToolEventMulticaster.add(this.keyListener, gFToolKeyListener);
    }

    public void removeToolKeyListener(GFToolKeyListener gFToolKeyListener) {
        this.keyListener = GFToolEventMulticaster.remove(this.keyListener, gFToolKeyListener);
    }

    public void triggerKeyDownEvent(GFDrawingKeyEvent gFDrawingKeyEvent) {
        GFToolKeyListener gFToolKeyListener = this.keyListener;
        if (gFToolKeyListener != null) {
            boolean bl = gFDrawingKeyEvent.isHandled();
            gFToolKeyListener.toolKeyDown(new GFToolKeyEvent(this, gFDrawingKeyEvent));
            gFDrawingKeyEvent.setHandled(bl);
        }
    }

    public void triggerKeyTypedEvent(GFDrawingKeyEvent gFDrawingKeyEvent) {
        GFToolKeyListener gFToolKeyListener = this.keyListener;
        if (gFToolKeyListener != null) {
            boolean bl = gFDrawingKeyEvent.isHandled();
            gFToolKeyListener.toolKeyTyped(new GFToolKeyEvent(this, gFDrawingKeyEvent));
            gFDrawingKeyEvent.setHandled(bl);
        }
    }

    public void triggerKeyUpEvent(GFDrawingKeyEvent gFDrawingKeyEvent) {
        GFToolKeyListener gFToolKeyListener = this.keyListener;
        if (gFToolKeyListener != null) {
            boolean bl = gFDrawingKeyEvent.isHandled();
            gFToolKeyListener.toolKeyUp(new GFToolKeyEvent(this, gFDrawingKeyEvent));
            gFDrawingKeyEvent.setHandled(bl);
        }
    }
}

