/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.connect.GFDisplayBoxLocator;
import com.objectshare.gf.connect.GFLocator;
import java.awt.Dimension;
import java.awt.Point;

public class GF2DReshapeHandle
extends GFHandle {
    public static int defaultMinWidth = 10;
    public static int defaultMinHeight = 10;
    public static int defaultMaxWidth = Integer.MAX_VALUE;
    public static int defaultMaxHeight = Integer.MAX_VALUE;
    public float xRatio;
    public float yRatio;
    public float widthRatio;
    public float heightRatio;
    public int minWidth;
    public int minHeight;
    public int maxWidth;
    public int maxHeight;
    protected GF2DRectangle initialDisplayBox;
    protected Point dragThreshold;
    protected boolean dragThresholdFlag;
    protected GF2DGO theOwner;

    protected GF2DReshapeHandle() {
        this(null, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public GF2DReshapeHandle(GFLocator gFLocator, float f, float f2, float f3, float f4) {
        this(gFLocator, f, f2, f3, f4, GFHandle.defaultDescription, GFHandle.defaultHandleExtent, GFHandle.defaultLimit, GFHandle.defaultSnapToGrid);
    }

    public GF2DReshapeHandle(GFLocator gFLocator, float f, float f2, float f3, float f4, String string, Dimension dimension, boolean bl, boolean bl2) {
        super(gFLocator, string, dimension, bl, bl2);
        this.xRatio = f;
        this.yRatio = f2;
        this.widthRatio = f3;
        this.heightRatio = f4;
        this.minWidth = defaultMinWidth;
        this.minHeight = defaultMinHeight;
        this.maxWidth = defaultMaxHeight;
        this.maxHeight = defaultMaxHeight;
    }

    public GFHandle copyForOwner(GFGO gFGO) {
        return this.copyForOwnerInto(new GF2DReshapeHandle(), gFGO);
    }

    protected GFHandle copyForOwnerInto(GFHandle gFHandle) {
        GF2DReshapeHandle gF2DReshapeHandle = (GF2DReshapeHandle)gFHandle;
        super.copyForOwnerInto(gFHandle);
        gF2DReshapeHandle.xRatio = this.xRatio;
        gF2DReshapeHandle.yRatio = this.yRatio;
        gF2DReshapeHandle.widthRatio = this.widthRatio;
        gF2DReshapeHandle.heightRatio = this.heightRatio;
        gF2DReshapeHandle.minWidth = this.minWidth;
        gF2DReshapeHandle.minHeight = this.minHeight;
        gF2DReshapeHandle.maxWidth = this.maxWidth;
        gF2DReshapeHandle.maxHeight = this.maxHeight;
        gF2DReshapeHandle.dragThreshold = this.dragThreshold == null ? null : new Point(this.dragThreshold.x, this.dragThreshold.y);
        return gFHandle;
    }

    public GF2DGO get2DOwner() {
        GFGO gFGO;
        if (this.theOwner == null && (gFGO = this.getOwner()) instanceof GF2DGO) {
            this.theOwner = (GF2DGO)gFGO;
        }
        return this.theOwner;
    }

    public void setInitialDisplayBox(GF2DRectangle gF2DRectangle) {
        this.initialDisplayBox = gF2DRectangle;
    }

    public void setDragThreshold(int n, int n2) {
        this.dragThreshold = new Point(n, n2);
    }

    public void setDragThreshold(int n) {
        this.setDragThreshold(n, n);
    }

    public GF2DRectangle newRectFrom(GF2DRectangle gF2DRectangle, float f, float f2) {
        int n;
        float f3 = gF2DRectangle.x + this.xRatio * f;
        float f4 = gF2DRectangle.y + this.yRatio * f2;
        float f5 = gF2DRectangle.width + this.widthRatio * f;
        float f6 = gF2DRectangle.height + this.heightRatio * f2;
        if (this.widthRatio != 0.0f) {
            if (f5 < (float)this.minWidth) {
                n = (int)(((float)this.minWidth - gF2DRectangle.width) / this.widthRatio);
                f3 = gF2DRectangle.x + (float)((int)(this.xRatio * (float)n));
                f5 = this.minWidth;
            }
            if (f5 > (float)this.maxWidth) {
                n = (int)(((float)this.maxWidth - gF2DRectangle.width) / this.widthRatio);
                f3 = gF2DRectangle.x + (float)((int)(this.xRatio * (float)n));
                f5 = this.maxWidth;
            }
        }
        if (this.heightRatio != 0.0f) {
            if (f6 < (float)this.minHeight) {
                n = (int)(((float)this.minHeight - gF2DRectangle.height) / this.heightRatio);
                f4 = gF2DRectangle.y + (float)((int)(this.yRatio * (float)n));
                f6 = this.minHeight;
            }
            if (f6 > (float)this.maxHeight) {
                n = (int)(((float)this.maxHeight - gF2DRectangle.height) / this.heightRatio);
                f4 = gF2DRectangle.y + (float)((int)(this.yRatio * (float)n));
                f6 = this.maxHeight;
            }
        }
        return new GF2DRectangle(f3, f4, f5, f6);
    }

    public void processMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
        super.processMouseDown(gFDrawingMouseEvent);
        this.dragThresholdFlag = false;
        GF2DGO gF2DGO = this.get2DOwner();
        if (gF2DGO != null) {
            this.initialDisplayBox = gF2DGO.displayBox();
            gFDrawingMouseEvent.setHandled(true);
        }
    }

    public void processMouseDrag(GFDrawingMouseEvent gFDrawingMouseEvent) {
        super.processMouseDrag(gFDrawingMouseEvent);
        if (this.dragThreshold != null && !this.dragThresholdFlag) {
            int n = Math.abs(gFDrawingMouseEvent.getViewX() - this.mouseDownEvent.getViewX());
            int n2 = Math.abs(gFDrawingMouseEvent.getViewY() - this.mouseDownEvent.getViewY());
            if (n <= this.dragThreshold.x && n2 <= this.dragThreshold.y) {
                return;
            }
            this.dragThresholdFlag = true;
        }
        GF2DRectangle gF2DRectangle = this.newRectFrom(this.initialDisplayBox, gFDrawingMouseEvent.getWorldX() - this.mouseDownEvent.getWorldX(), gFDrawingMouseEvent.getWorldY() - this.mouseDownEvent.getWorldY());
        GF2DGO gF2DGO = this.get2DOwner();
        if (gF2DGO != null) {
            gF2DGO.reshape(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
            gFDrawingMouseEvent.setHandled(true);
        }
    }

    public static GFGOArray allCornersAndCenterOf(GF2DGO gF2DGO) {
        GFGOArray gFGOArray = GF2DReshapeHandle.allCornersOf(gF2DGO);
        gFGOArray.add(GF2DReshapeHandle.centerOf(gF2DGO));
        return gFGOArray;
    }

    public static GFGOArray allCornersOf(GF2DGO gF2DGO) {
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray(5);
        gFUnsortedGOArray.add(GF2DReshapeHandle.leftTopOf(gF2DGO));
        gFUnsortedGOArray.add(GF2DReshapeHandle.rightTopOf(gF2DGO));
        gFUnsortedGOArray.add(GF2DReshapeHandle.leftBottomOf(gF2DGO));
        gFUnsortedGOArray.add(GF2DReshapeHandle.rightBottomOf(gF2DGO));
        return gFUnsortedGOArray;
    }

    public static GF2DReshapeHandle centerOf(GF2DGO gF2DGO) {
        return new GF2DReshapeHandle((GFLocator)GFDisplayBoxLocator.centerOf(gF2DGO), 1.0f, 1.0f, 0.0f, 0.0f);
    }

    public static GF2DReshapeHandle leftTopOf(GF2DGO gF2DGO) {
        return new GF2DReshapeHandle((GFLocator)GFDisplayBoxLocator.leftTopOf(gF2DGO), 1.0f, 1.0f, -1.0f, -1.0f);
    }

    public static GF2DReshapeHandle rightTopOf(GF2DGO gF2DGO) {
        return new GF2DReshapeHandle((GFLocator)GFDisplayBoxLocator.rightTopOf(gF2DGO), 0.0f, 1.0f, 1.0f, -1.0f);
    }

    public static GF2DReshapeHandle leftBottomOf(GF2DGO gF2DGO) {
        return new GF2DReshapeHandle((GFLocator)GFDisplayBoxLocator.leftBottomOf(gF2DGO), 1.0f, 0.0f, -1.0f, 1.0f);
    }

    public static GF2DReshapeHandle rightBottomOf(GF2DGO gF2DGO) {
        return new GF2DReshapeHandle((GFLocator)GFDisplayBoxLocator.rightBottomOf(gF2DGO), 0.0f, 0.0f, 1.0f, 1.0f);
    }
}

