/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.example.demo3d;

import com.objectshare.base.example.OSIExampleApplet;
import com.objectshare.base.example.OSIExampleFrame;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.example.demo3d.GFOpenCubeGO;
import com.objectshare.gf.example.howto.HowTo;
import com.objectshare.gf.go3d.GF25DCubeGO;
import com.objectshare.gf.go3d.GF25DDodecahedronGO;
import com.objectshare.gf.go3d.GF25DIcosahedronGO;
import com.objectshare.gf.go3d.GF25DPyramidGO;
import java.awt.Checkbox;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Panel;

public class Demo3D
extends HowTo
implements Runnable {
    public GF25DCubeGO animatedGO;
    public Thread animationThread;
    public Checkbox animationCheckbox;
    public Checkbox debugCheckbox;

    protected void preInit() {
        HowTo.createToolPalette = false;
    }

    protected void initDrawing(GFDrawingManager gFDrawingManager) {
        GFOpenCubeGO gFOpenCubeGO = new GFOpenCubeGO(60.0f, 150.0f, 40.0f);
        gFDrawingManager.add(gFOpenCubeGO);
        gFOpenCubeGO.translate(55.0f, -40.0f);
        gFOpenCubeGO.changeYawPitchRoll(0.4f, -0.25f, 0.0f);
        this.animatedGO = new GFOpenCubeGO(40.0f, 30.0f, 20.0f);
        gFDrawingManager.add(this.animatedGO);
        this.animatedGO.translate(180.0f, -75.0f);
        GF25DDodecahedronGO gF25DDodecahedronGO = new GF25DDodecahedronGO(20.0f);
        gFDrawingManager.add(gF25DDodecahedronGO);
        gF25DDodecahedronGO.translate(-30.0f, 5.0f);
        GF25DPyramidGO gF25DPyramidGO = new GF25DPyramidGO(25.0f, 45.0f, 80.0f);
        gFDrawingManager.add(gF25DPyramidGO);
        gF25DPyramidGO.translate(100.0f, 10.0f);
        GF25DIcosahedronGO gF25DIcosahedronGO = new GF25DIcosahedronGO(50.0f);
        gFDrawingManager.add(gF25DIcosahedronGO);
        gF25DIcosahedronGO.translate(-60.0f, -65.0f);
    }

    protected void initTopControls(Panel panel) {
        panel.setLayout(new FlowLayout(1));
        this.animationCheckbox = new Checkbox("Animate");
        this.animationCheckbox.setState(true);
        panel.add(this.animationCheckbox);
        this.debugCheckbox = new Checkbox("Debug");
    }

    public void start() {
        if (this.animationCheckbox.getState()) {
            this.startAnimation();
        }
    }

    public void stop() {
        this.stopAnimation();
    }

    public void stopAnimation() {
        if (this.animationThread != null) {
            this.animationThread.stop();
            this.animationThread = null;
        }
    }

    public void startAnimation() {
        if (this.animationThread == null) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }

    public void run() {
        try {
            while (true) {
                this.animatedGO.changeYawPitchRoll(0.2f, 0.1f, 0.05f);
                this.getManager().redraw();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.animationCheckbox) {
            if (this.animationCheckbox.getState()) {
                this.startAnimation();
            } else {
                this.stopAnimation();
            }
        }
        if (event.target == this.debugCheckbox) {
            this.getManager().debug = this.debugCheckbox.getState();
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Demo3D demo3D = new Demo3D();
        new OSIExampleFrame((OSIExampleApplet)demo3D, demo3D.getClass().getName(), 550, 350);
    }
}

