/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base.geometry;

import java.io.Serializable;

public class GF3DPoint
implements Serializable {
    public float x;
    public float y;
    public float z;

    public GF3DPoint(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public GF3DPoint(GF3DPoint gF3DPoint) {
        this(gF3DPoint.x, gF3DPoint.y, gF3DPoint.z);
    }

    public GF3DPoint translateBy(float f, float f2, float f3) {
        return new GF3DPoint(this.x + f, this.y + f2, this.z + f3);
    }

    public int hashCode() {
        int n = new Float(this.x).hashCode();
        n = 37 * n + new Float(this.y).hashCode();
        n = 37 * n + new Float(this.z).hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GF3DPoint gF3DPoint = (GF3DPoint)object;
        return this.x == gF3DPoint.x && this.y == gF3DPoint.y && this.z == gF3DPoint.z;
    }

    public GF3DPoint add(GF3DPoint gF3DPoint) {
        return new GF3DPoint(this.x + gF3DPoint.x, this.y + gF3DPoint.y, this.z + gF3DPoint.z);
    }

    public float dotProduct(GF3DPoint gF3DPoint) {
        return this.x * gF3DPoint.x + this.y * gF3DPoint.y + this.z * gF3DPoint.z;
    }

    public GF3DPoint subtract(GF3DPoint gF3DPoint) {
        return new GF3DPoint(this.x - gF3DPoint.x, this.y - gF3DPoint.y, this.z - gF3DPoint.z);
    }

    public static GF3DPoint surfaceNormal(GF3DPoint gF3DPoint, GF3DPoint gF3DPoint2, GF3DPoint gF3DPoint3) {
        GF3DPoint gF3DPoint4 = gF3DPoint2.subtract(gF3DPoint);
        GF3DPoint gF3DPoint5 = gF3DPoint3.subtract(gF3DPoint);
        return new GF3DPoint(gF3DPoint4.y * gF3DPoint5.z - gF3DPoint5.y * gF3DPoint4.z, gF3DPoint4.z * gF3DPoint5.x - gF3DPoint5.z * gF3DPoint4.x, gF3DPoint4.x * gF3DPoint5.y - gF3DPoint5.x * gF3DPoint4.y);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.x + "," + this.y + "," + this.z + "]";
    }
}

