/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base;

import com.objectshare.base.event.OSIEventMulticaster;
import com.objectshare.gf.base.GF2DWorldViewTransform;
import com.objectshare.gf.base.GFDrawingLayer;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFEventModel;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFGOContainer;
import com.objectshare.gf.base.GFGOParent;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.connect.GFConnector;
import com.objectshare.gf.connect.GFLocator;
import com.objectshare.gf.go.event.GFGODamageListener;
import com.objectshare.gf.go.event.GFGOEvent;
import com.objectshare.gf.go.event.GFGOEventMulticaster;
import com.objectshare.gf.go.event.GFGOHandleEvent;
import com.objectshare.gf.go.event.GFGOHandleListener;
import com.objectshare.gf.go.event.GFGOMenuEvent;
import com.objectshare.gf.go.event.GFGOMetaEvent;
import com.objectshare.gf.go.event.GFGOMetaListener;
import com.objectshare.gf.go.event.GFGOSelectionListener;
import java.awt.Color;
import java.awt.PopupMenu;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;

public abstract class GFGraphicObject
extends GFEventModel
implements GFGO,
Serializable {
    protected static Color DefaultLineColor;
    protected transient GFGOParent parent;
    protected transient GFDrawingManager manager;
    protected transient Object metaObject;
    protected Vector connectors = new Vector();
    protected PopupMenu contextMenu;
    protected transient GFGODamageListener damageListener;
    protected transient GFGOHandleListener handleListener;
    protected transient GFGOMetaListener metaListener;
    protected transient GFGOSelectionListener selectionListener;
    protected static final String damageListenerK = "damageL";
    protected static final String handleListenerK = "handleL";
    protected static final String metaListenerK = "metaL";
    protected static final String selectionListenerK = "selectionL";

    public GFGO copyForCreation() {
        return null;
    }

    protected GFGO copyForCreationInto(GFGO gFGO) {
        return gFGO;
    }

    public GFGOParent getParent() {
        return this.parent;
    }

    public void basicSetParent(GFGOParent gFGOParent) {
        this.parent = gFGOParent;
        if (this.parent == null) {
            if (this.manager != null) {
                this.basicSetManager(null);
                return;
            }
        } else {
            GFDrawingManager gFDrawingManager = this.parent.getManager();
            if (gFDrawingManager != null) {
                this.basicSetManager(gFDrawingManager);
            }
        }
    }

    public void basicSetParentAttribute(GFGOParent gFGOParent) {
        this.parent = gFGOParent;
    }

    public GFGOContainer getContainer() {
        GFGOParent gFGOParent = this.getParent();
        if (gFGOParent instanceof GFGOContainer) {
            return (GFGOContainer)gFGOParent;
        }
        return null;
    }

    public void basicSetManager(GFDrawingManager gFDrawingManager) {
        this.manager = gFDrawingManager;
    }

    public void basicSetAllManagerAttributes(GFDrawingManager gFDrawingManager) {
        this.manager = gFDrawingManager;
    }

    public GFDrawingManager getManager() {
        return this.manager;
    }

    public float displayBottom() {
        return this.displayBox().bottom();
    }

    public GF2DPoint displayBottomCenter() {
        return this.displayBox().bottomCenter();
    }

    public abstract GF2DRectangle displayBox();

    public GF2DPoint displayCenter() {
        return this.displayBox().center();
    }

    public GF2DDimension displayExtent() {
        return this.displayBox().extent();
    }

    public float displayLeft() {
        return this.displayBox().left();
    }

    public GF2DPoint displayLeftBottom() {
        return this.displayBox().leftBottom();
    }

    public GF2DPoint displayLeftCenter() {
        return this.displayBox().leftCenter();
    }

    public GF2DPoint displayLeftTop() {
        return this.displayBox().leftTop();
    }

    public float displayRight() {
        return this.displayBox().right();
    }

    public GF2DPoint displayRightBottom() {
        return this.displayBox().rightBottom();
    }

    public GF2DPoint displayRightCenter() {
        return this.displayBox().rightCenter();
    }

    public GF2DPoint displayRightTop() {
        return this.displayBox().rightTop();
    }

    public float displayTop() {
        return this.displayBox().top();
    }

    public GF2DPoint displayTopCenter() {
        return this.displayBox().topCenter();
    }

    public boolean containedBy(GF2DRectangle gF2DRectangle) {
        return gF2DRectangle.inside(this.displayBox());
    }

    public boolean containsPoint(GF2DPoint gF2DPoint) {
        return this.displayBox().inside(gF2DPoint);
    }

    public GFGO graphicObjectContaining(GF2DPoint gF2DPoint) {
        if (this.containsPoint(gF2DPoint)) {
            return this;
        }
        return null;
    }

    public GFGOArray graphicObjectsContaining(GF2DPoint gF2DPoint) {
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray();
        if (this.containsPoint(gF2DPoint)) {
            gFUnsortedGOArray.add(this);
        }
        return gFUnsortedGOArray;
    }

    public boolean intersects(GF2DRectangle gF2DRectangle) {
        return gF2DRectangle.intersects(this.displayBox());
    }

    public GFGOArray graphicObjectsIntersecting(GF2DRectangle gF2DRectangle) {
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray();
        if (this.intersects(gF2DRectangle)) {
            gFUnsortedGOArray.add(this);
        }
        return gFUnsortedGOArray;
    }

    public boolean intersectsDisplay(GF2DRectangle gF2DRectangle) {
        return gF2DRectangle.intersects(this.displayBox());
    }

    public abstract void display(GFGraphics var1);

    public abstract void displayShape(GFGraphics var1);

    public void beginDamage() {
        this.damagedWithoutEvent();
    }

    public void endDamage() {
        this.damaged();
    }

    public void damageRegion(GF2DRectangle gF2DRectangle) {
        GFGOParent gFGOParent = this.getParent();
        if (gFGOParent != null) {
            gFGOParent.damageRegion(gF2DRectangle);
        }
    }

    public void damagedWithoutEvent() {
        this.damagedWithoutEvent(this.displayBox());
    }

    protected void damagedWithoutEvent(GF2DRectangle gF2DRectangle) {
        this.damageRegion(gF2DRectangle);
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager != null) {
            gFDrawingManager.damageHandlesFor(this);
        }
    }

    public GF2DRectangle damaged() {
        return this.damaged(this.displayBox());
    }

    protected GF2DRectangle damaged(GF2DRectangle gF2DRectangle) {
        this.damagedWithoutEvent(gF2DRectangle);
        this.triggerDamagedEvent();
        return gF2DRectangle;
    }

    public void disableRedraw() {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager != null) {
            gFDrawingManager.disableRedraw();
        }
    }

    public void enableRedraw() {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager != null) {
            gFDrawingManager.enableRedraw();
        }
    }

    public void redraw() {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager != null) {
            gFDrawingManager.redraw();
        }
    }

    protected static Color getDefaultLineColor() {
        if (DefaultLineColor == null) {
            GFGraphicObject.setDefaultLineColor(Color.black);
        }
        return DefaultLineColor;
    }

    protected static void setDefaultLineColor(Color color) {
        DefaultLineColor = color;
    }

    public GFDrawingLayer getLayerFor(GFDrawingManager gFDrawingManager) {
        return gFDrawingManager.getActiveLayer();
    }

    public boolean includes(GFGO gFGO) {
        return this == gFGO;
    }

    public boolean remove() {
        GFGOContainer gFGOContainer = this.getContainer();
        if (gFGOContainer != null) {
            return gFGOContainer.remove(this);
        }
        return false;
    }

    public abstract GFGOArray defaultHandles();

    public abstract GFHandle defaultPositionHandle();

    public abstract GFGOArray defaultConnectionHandles();

    public GFHandle defaultCreationHandle() {
        return null;
    }

    public GFGOArray getHandles() {
        return this.triggerNeedsHandlesEvent();
    }

    public GFHandle getPositionHandle() {
        return this.triggerNeedsPositionHandleEvent();
    }

    public GFGOArray getStartConnectionHandles() {
        return this.triggerNeedsStartConnectionHandlesEvent();
    }

    public GFGOArray getEndConnectionHandles() {
        return this.triggerNeedsEndConnectionHandlesEvent();
    }

    public boolean isSelected() {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager == null) {
            return false;
        }
        return gFDrawingManager.isSelected(this);
    }

    public void select() {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager != null && !this.isSelected()) {
            gFDrawingManager.basicSelect(this);
            this.triggerSelectedEvent();
        }
    }

    public void unselect() {
        if (this.isSelected()) {
            this.getManager().basicUnselect(this);
            this.triggerUnselectedEvent();
        }
    }

    public void doubleClicked() {
        this.triggerDoubleClickedEvent();
    }

    public GF2DWorldViewTransform getWorldViewTransform() {
        GFGOParent gFGOParent = this.getParent();
        if (gFGOParent != null) {
            return gFGOParent.getWorldViewTransform();
        }
        return new GF2DWorldViewTransform();
    }

    public Object getMetaObject() {
        if (this.metaObject == null) {
            this.metaObject = this.triggerNeedsMetaObjectEvent();
        }
        return this.metaObject;
    }

    public void setMetaObject(Object object) {
        this.metaObject = object;
    }

    public Vector basicGetConnectors() {
        return this.connectors;
    }

    public void basicAddConnector(GFConnector gFConnector) {
        if (!this.basicGetConnectors().contains(gFConnector)) {
            this.basicGetConnectors().addElement(gFConnector);
        }
    }

    public void basicRemoveConnector(GFConnector gFConnector) {
        this.basicGetConnectors().removeElement(gFConnector);
    }

    public Vector getConnectors() {
        return (Vector)this.basicGetConnectors().clone();
    }

    public Vector getConnectors(GF2DPoint gF2DPoint) {
        Vector<GFConnector> vector = new Vector<GFConnector>();
        Enumeration enumeration = this.basicGetConnectors().elements();
        while (enumeration.hasMoreElements()) {
            GFConnector gFConnector = (GFConnector)enumeration.nextElement();
            if (!gF2DPoint.equals(gFConnector.getLocation())) continue;
            vector.addElement(gFConnector);
        }
        return vector;
    }

    public Vector getConnectors(GFLocator gFLocator) {
        Vector<GFConnector> vector = new Vector<GFConnector>();
        Enumeration enumeration = this.basicGetConnectors().elements();
        while (enumeration.hasMoreElements()) {
            GFConnector gFConnector = (GFConnector)enumeration.nextElement();
            if (!gFLocator.equals(gFConnector.getLocator())) continue;
            vector.addElement(gFConnector);
        }
        return vector;
    }

    public Vector getSourceConnectors() {
        Vector<GFConnector> vector = new Vector<GFConnector>();
        Enumeration enumeration = this.basicGetConnectors().elements();
        while (enumeration.hasMoreElements()) {
            GFConnector gFConnector = (GFConnector)enumeration.nextElement();
            if (gFConnector.getSource() != this) continue;
            vector.addElement(gFConnector);
        }
        return vector;
    }

    public Vector getSourceConnectors(GF2DPoint gF2DPoint) {
        Vector<GFConnector> vector = new Vector<GFConnector>();
        Enumeration enumeration = this.getSourceConnectors().elements();
        while (enumeration.hasMoreElements()) {
            GFConnector gFConnector = (GFConnector)enumeration.nextElement();
            if (!gF2DPoint.equals(gFConnector.getLocation())) continue;
            vector.addElement(gFConnector);
        }
        return vector;
    }

    public Vector getSourceConnectors(GFLocator gFLocator) {
        Vector<GFConnector> vector = new Vector<GFConnector>();
        Enumeration enumeration = this.getSourceConnectors().elements();
        while (enumeration.hasMoreElements()) {
            GFConnector gFConnector = (GFConnector)enumeration.nextElement();
            if (!gFLocator.equals(gFConnector.getLocator())) continue;
            vector.addElement(gFConnector);
        }
        return vector;
    }

    public Vector getTargetConnectors() {
        Vector<GFConnector> vector = new Vector<GFConnector>();
        Enumeration enumeration = this.basicGetConnectors().elements();
        while (enumeration.hasMoreElements()) {
            GFConnector gFConnector = (GFConnector)enumeration.nextElement();
            if (gFConnector.getTarget() != this) continue;
            vector.addElement(gFConnector);
        }
        return vector;
    }

    public Vector getTargetConnectors(GF2DPoint gF2DPoint) {
        Vector<GFConnector> vector = new Vector<GFConnector>();
        Enumeration enumeration = this.getTargetConnectors().elements();
        while (enumeration.hasMoreElements()) {
            GFConnector gFConnector = (GFConnector)enumeration.nextElement();
            if (!gF2DPoint.equals(gFConnector.getLocation())) continue;
            vector.addElement(gFConnector);
        }
        return vector;
    }

    public Vector getTargetConnectors(GFLocator gFLocator) {
        Vector<GFConnector> vector = new Vector<GFConnector>();
        Enumeration enumeration = this.getTargetConnectors().elements();
        while (enumeration.hasMoreElements()) {
            GFConnector gFConnector = (GFConnector)enumeration.nextElement();
            if (!gFLocator.equals(gFConnector.getLocator())) continue;
            vector.addElement(gFConnector);
        }
        return vector;
    }

    public void disconnectConnector(GFConnector gFConnector) {
        if (this.basicGetConnectors().contains(gFConnector)) {
            gFConnector.disconnect();
        }
    }

    public void disconnectAllConnectors() {
        Enumeration enumeration = this.getConnectors().elements();
        while (enumeration.hasMoreElements()) {
            this.disconnectConnector((GFConnector)enumeration.nextElement());
        }
    }

    public void setMenu(PopupMenu popupMenu) {
        this.contextMenu = popupMenu;
    }

    public PopupMenu getMenu() {
        return this.contextMenu;
    }

    public void releaseResources() {
    }

    public void releaseAllResources() {
        this.releaseResources();
    }

    public void addDamageListener(GFGODamageListener gFGODamageListener) {
        this.damageListener = GFGOEventMulticaster.add(this.damageListener, gFGODamageListener);
    }

    public void removeDamageListener(GFGODamageListener gFGODamageListener) {
        this.damageListener = GFGOEventMulticaster.remove(this.damageListener, gFGODamageListener);
    }

    public void triggerDamagedEvent() {
        GFGODamageListener gFGODamageListener = this.damageListener;
        if (gFGODamageListener != null) {
            gFGODamageListener.goDamaged(new GFGOEvent(this));
        }
    }

    public void addHandleListener(GFGOHandleListener gFGOHandleListener) {
        this.handleListener = GFGOEventMulticaster.add(this.handleListener, gFGOHandleListener);
    }

    public void removeHandleListener(GFGOHandleListener gFGOHandleListener) {
        this.handleListener = GFGOEventMulticaster.remove(this.handleListener, gFGOHandleListener);
    }

    protected GFGOArray triggerNeedsHandlesEvent() {
        EventListener eventListener;
        GFGOHandleEvent gFGOHandleEvent = new GFGOHandleEvent((GFGO)this, this.defaultHandles());
        Enumeration enumeration = this.getTargetConnectors().elements();
        while (enumeration.hasMoreElements()) {
            eventListener = (GFConnector)enumeration.nextElement();
            ((GFConnector)eventListener).targetNeedsHandles(gFGOHandleEvent);
        }
        eventListener = this.handleListener;
        if (eventListener != null) {
            eventListener.goNeedsHandles(gFGOHandleEvent);
        }
        return gFGOHandleEvent.getHandles();
    }

    protected GFHandle triggerNeedsPositionHandleEvent() {
        EventListener eventListener;
        GFGOHandleEvent gFGOHandleEvent = new GFGOHandleEvent((GFGO)this, this.defaultPositionHandle());
        Enumeration enumeration = this.getTargetConnectors().elements();
        while (enumeration.hasMoreElements()) {
            eventListener = (GFConnector)enumeration.nextElement();
            ((GFConnector)eventListener).targetNeedsPositionHandle(gFGOHandleEvent);
        }
        eventListener = this.handleListener;
        if (eventListener != null) {
            eventListener.goNeedsPositionHandle(gFGOHandleEvent);
        }
        return gFGOHandleEvent.getHandle();
    }

    protected GFGOArray triggerNeedsStartConnectionHandlesEvent() {
        GFGOHandleEvent gFGOHandleEvent = new GFGOHandleEvent((GFGO)this, this.defaultConnectionHandles());
        GFGOHandleListener gFGOHandleListener = this.handleListener;
        if (gFGOHandleListener != null) {
            gFGOHandleListener.goNeedsStartConnectionHandles(gFGOHandleEvent);
        }
        return gFGOHandleEvent.getHandles();
    }

    protected GFGOArray triggerNeedsEndConnectionHandlesEvent() {
        GFGOHandleEvent gFGOHandleEvent = new GFGOHandleEvent((GFGO)this, this.defaultConnectionHandles());
        GFGOHandleListener gFGOHandleListener = this.handleListener;
        if (gFGOHandleListener != null) {
            gFGOHandleListener.goNeedsEndConnectionHandles(gFGOHandleEvent);
        }
        return gFGOHandleEvent.getHandles();
    }

    public void addMetaListener(GFGOMetaListener gFGOMetaListener) {
        this.metaListener = GFGOEventMulticaster.add(this.metaListener, gFGOMetaListener);
    }

    public void removeMetaListener(GFGOMetaListener gFGOMetaListener) {
        this.metaListener = GFGOEventMulticaster.remove(this.metaListener, gFGOMetaListener);
    }

    public Object triggerNeedsMetaObjectEvent() {
        GFGOMetaEvent gFGOMetaEvent = new GFGOMetaEvent(this, this.metaObject);
        GFGOMetaListener gFGOMetaListener = this.metaListener;
        if (gFGOMetaListener != null) {
            gFGOMetaListener.goNeedsMetaObject(gFGOMetaEvent);
        }
        return gFGOMetaEvent.getMetaObject();
    }

    public void addSelectionListener(GFGOSelectionListener gFGOSelectionListener) {
        this.selectionListener = GFGOEventMulticaster.add(this.selectionListener, gFGOSelectionListener);
    }

    public void removeSelectionListener(GFGOSelectionListener gFGOSelectionListener) {
        this.selectionListener = GFGOEventMulticaster.remove(this.selectionListener, gFGOSelectionListener);
    }

    public void triggerDoubleClickedEvent() {
        GFGOSelectionListener gFGOSelectionListener = this.selectionListener;
        if (gFGOSelectionListener != null) {
            gFGOSelectionListener.goDoubleClicked(new GFGOEvent(this));
        }
    }

    public PopupMenu triggerNeedsMenuEvent(GFDrawingMouseEvent gFDrawingMouseEvent) {
        GFGOSelectionListener gFGOSelectionListener = this.selectionListener;
        if (gFGOSelectionListener != null) {
            GFGOMenuEvent gFGOMenuEvent = new GFGOMenuEvent(this, gFDrawingMouseEvent);
            gFGOSelectionListener.goNeedsMenu(gFGOMenuEvent);
            return gFGOMenuEvent.getMenu();
        }
        return this.getMenu();
    }

    public void triggerSelectedEvent() {
        GFGOSelectionListener gFGOSelectionListener = this.selectionListener;
        if (gFGOSelectionListener != null) {
            gFGOSelectionListener.goSelected(new GFGOEvent(this));
        }
    }

    public void triggerUnselectedEvent() {
        GFGOSelectionListener gFGOSelectionListener = this.selectionListener;
        if (gFGOSelectionListener != null) {
            gFGOSelectionListener.goUnselected(new GFGOEvent(this));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.metaObject instanceof Serializable) {
            objectOutputStream.writeObject(this.metaObject);
        } else {
            objectOutputStream.writeObject(null);
        }
        this.writeEventListeners(objectOutputStream);
        objectOutputStream.writeObject(null);
    }

    protected void writeEventListeners(ObjectOutputStream objectOutputStream) throws IOException {
        OSIEventMulticaster.save((ObjectOutputStream)objectOutputStream, (String)damageListenerK, (EventListener)this.damageListener);
        OSIEventMulticaster.save((ObjectOutputStream)objectOutputStream, (String)handleListenerK, (EventListener)this.handleListener);
        OSIEventMulticaster.save((ObjectOutputStream)objectOutputStream, (String)metaListenerK, (EventListener)this.metaListener);
        OSIEventMulticaster.save((ObjectOutputStream)objectOutputStream, (String)selectionListenerK, (EventListener)this.selectionListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.metaObject = objectInputStream.readObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            Object object2 = objectInputStream.readObject();
            this.registerEventListener(string, object2);
        }
    }

    protected boolean registerEventListener(String string, Object object) throws IOException {
        if (string == damageListenerK) {
            this.addDamageListener((GFGODamageListener)object);
            return true;
        }
        if (string == handleListenerK) {
            this.addHandleListener((GFGOHandleListener)object);
            return true;
        }
        if (string == metaListenerK) {
            this.addMetaListener((GFGOMetaListener)object);
            return true;
        }
        if (string == selectionListenerK) {
            this.addSelectionListener((GFGOSelectionListener)object);
            return true;
        }
        return false;
    }
}

