/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base;

import com.objectshare.base.draw.OSIBorderPolicy;
import com.objectshare.base.draw.OSIBufferedDisplaySystem;
import com.objectshare.base.draw.OSIDisplaySystemParent;
import com.objectshare.base.draw.OSIGraphicsDisplaySystem;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.java.osi.OSIPanel;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;

public class GFDrawingCanvas
extends OSIPanel {
    protected static Dimension defaultMinimumSize = new Dimension(10, 10);
    protected static Dimension defaultPreferredSize = new Dimension(100, 100);
    protected OSIGraphicsDisplaySystem displaySystem;
    protected GFDrawingManager manager;
    protected boolean autoRelease = true;
    protected Rectangle boundingRect;
    protected Dimension minimumSize = defaultMinimumSize;
    protected Dimension preferredSize = defaultPreferredSize;
    private int welcomePageNum;
    private Boolean osiServer;
    private String[] welcomeText = new String[]{"Welcome to\njKit/GraphicsFramework", "For more information:\nhttp://www.objectshare.com"};
    private Rectangle[] welcomeBoxes = new Rectangle[]{new Rectangle(10, 10, 250, 65), new Rectangle(10, 10, 300, 55)};
    private Font[] welcomeFonts = new Font[]{new Font("Helvetica", 1, 16), new Font("Helvetica", 1, 16)};

    protected OSIGraphicsDisplaySystem defaultDisplaySystem() {
        return new OSIBufferedDisplaySystem();
    }

    protected GFDrawingManager defaultManager() {
        return new GFDrawingManager();
    }

    public GFDrawingCanvas() {
        this(defaultPreferredSize);
    }

    public GFDrawingCanvas(int n, int n2) {
        this(new Dimension(n, n2));
    }

    public GFDrawingCanvas(Dimension dimension) {
        this.initializeDefaultDisplaySystem();
        this.initializeDefaultManager();
        this.setPreferredSize(dimension);
        this.enableUIEvents(56L);
        ((Container)((Object)this)).setLayout(null);
    }

    protected void initializeDefaultDisplaySystem() {
        this.setDisplaySystem(this.defaultDisplaySystem());
    }

    protected void initializeDefaultManager() {
        this.setManager(this.defaultManager());
    }

    public OSIBorderPolicy getBorder() {
        return this.getDisplaySystem().getBorder();
    }

    public void setBorder(OSIBorderPolicy oSIBorderPolicy) {
        this.getDisplaySystem().setBorder(oSIBorderPolicy);
    }

    public OSIGraphicsDisplaySystem getDisplaySystem() {
        return this.displaySystem;
    }

    public void setDisplaySystem(OSIGraphicsDisplaySystem oSIGraphicsDisplaySystem) {
        if (this.displaySystem == oSIGraphicsDisplaySystem) {
            return;
        }
        this.releaseDisplaySystem();
        oSIGraphicsDisplaySystem.setParent((OSIDisplaySystemParent)this);
        oSIGraphicsDisplaySystem.setBounds(new Rectangle(((Component)((Object)this)).size()));
        this.basicSetDisplaySystem(oSIGraphicsDisplaySystem);
    }

    protected void basicSetDisplaySystem(OSIGraphicsDisplaySystem oSIGraphicsDisplaySystem) {
        this.displaySystem = oSIGraphicsDisplaySystem;
    }

    public void releaseDisplaySystem() {
        if (this.displaySystem != null) {
            this.displaySystem.release();
            this.displaySystem = null;
        }
    }

    public GFDrawingManager getManager() {
        return this.manager;
    }

    public void setManager(GFDrawingManager gFDrawingManager) {
        if (this.manager == gFDrawingManager) {
            return;
        }
        gFDrawingManager.setCanvas(this);
    }

    protected void basicSetManager(GFDrawingManager gFDrawingManager) {
        this.manager = gFDrawingManager;
    }

    public void releaseManager() {
        if (this.manager != null) {
            this.manager.releaseCanvas();
        }
    }

    protected void basicReleaseManager() {
        this.basicSetManager(null);
    }

    public void setAutoRelease(boolean bl) {
        this.autoRelease = bl;
    }

    public boolean getAutoRelease() {
        return this.autoRelease;
    }

    public Graphics getClientAreaGraphics() {
        Graphics graphics = ((Component)((Object)this)).getGraphics();
        return graphics;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipRect();
        if (this.boundingRect != null && !rectangle.equals(this.boundingRect)) {
            return;
        }
        this.boundingRect = null;
        this.getDisplaySystem().paint(graphics);
    }

    public void paintCanvas(Graphics graphics) {
        if (graphics != null) {
            GFDrawingManager gFDrawingManager = this.getManager();
            if (gFDrawingManager != null) {
                gFDrawingManager.display(graphics);
            }
            this.paintWelcome(graphics);
        }
    }

    protected void basicReshape(int n, int n2, int n3, int n4) {
        boolean bl;
        Dimension dimension = ((Component)((Object)this)).size();
        boolean bl2 = bl = dimension.width != n3 || dimension.height != n4;
        if (bl) {
            this.boundingRect = new Rectangle(0, 0, n3, n4);
            this.getDisplaySystem().setBounds(this.boundingRect);
            GFDrawingManager gFDrawingManager = this.getManager();
            if (gFDrawingManager != null) {
                gFDrawingManager.displaySystemResized(this.getDisplaySystem().getContentBounds());
            }
            super.reshape(n, n2, n3, n4);
            ((Component)((Object)this)).repaint();
            return;
        }
        super.reshape(n, n2, n3, n4);
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        if (this.debugExceptions) {
            try {
                this.basicReshape(n, n2, n3, n4);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        this.basicReshape(n, n2, n3, n4);
    }

    protected void basicUpdate(Graphics graphics) {
        this.paint(graphics);
    }

    public void update(Graphics graphics) {
        if (this.debugExceptions) {
            try {
                this.basicUpdate(graphics);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        this.basicUpdate(graphics);
    }

    public Dimension minimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minimumSize = dimension;
    }

    public void setMinimumSize(int n, int n2) {
        this.setMinimumSize(new Dimension(n, n2));
    }

    public Dimension preferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public void setPreferredSize(int n, int n2) {
        this.setPreferredSize(new Dimension(n, n2));
    }

    public synchronized void removeNotify() {
        if (this.autoRelease) {
            this.releaseManager();
        }
        super.removeNotify();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        GFDrawingManager gFDrawingManager;
        if (!this.handleWelcomeEvent(mouseEvent) && (gFDrawingManager = this.getManager()) != null) {
            gFDrawingManager.processMouseEvent(mouseEvent);
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        GFDrawingManager gFDrawingManager;
        if (!this.handleWelcomeEvent(mouseEvent) && (gFDrawingManager = this.getManager()) != null) {
            gFDrawingManager.processMouseEvent(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        GFDrawingManager gFDrawingManager = this.getManager();
        if (gFDrawingManager != null) {
            gFDrawingManager.processKeyEvent(keyEvent);
        }
        super.processKeyEvent(keyEvent);
    }

    private boolean isOSIServer() {
        if (this.osiServer != null) {
            return this.osiServer;
        }
        Container container = ((Component)((Object)this)).getParent();
        while (!(container instanceof Applet) && !(container instanceof Frame)) {
            container = container.getParent();
        }
        if (!(container instanceof Applet)) {
            this.osiServer = new Boolean(false);
            return false;
        }
        String string = ((Applet)container).getCodeBase().getHost();
        boolean bl = string.equals("www.objectshare.com") || string.equals("www.netsmart.com");
        this.osiServer = new Boolean(bl);
        return bl;
    }

    private boolean isWelcomeDisplayed() {
        if (this.welcomePageNum >= this.welcomeText.length || this.isOSIServer()) {
            return false;
        }
        if (((Component)((Object)this)).size().width < 100) {
            return false;
        }
        return this.getManager() == null || !this.getManager().debug;
    }

    private void paintWelcome(Graphics graphics) {
        if (!this.isWelcomeDisplayed()) {
            return;
        }
        Rectangle rectangle = this.welcomeBoxes[this.welcomePageNum];
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x - 3, rectangle.y - 3, rectangle.width + 5, rectangle.height + 5);
        graphics.setColor(Color.white);
        graphics.drawRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 3);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        GFDrawingCanvas.drawWelcomeText(this.welcomeText[this.welcomePageNum], rectangle, graphics, (Component)((Object)this), this.welcomeFonts[this.welcomePageNum], Color.black, Color.white, 2, 2);
    }

    private boolean handleWelcomeEvent(MouseEvent mouseEvent) {
        if (!this.isWelcomeDisplayed()) {
            return false;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                ++this.welcomePageNum;
                this.getManager().damageViewPort();
                ((Component)((Object)this)).repaint();
            }
            case 500: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static void drawWelcomeText(String var0, Rectangle var1_1, Graphics var2_2, Component var3_3, Font var4_4, Color var5_5, Color var6_6, int var7_7, int var8_8) {
        var9_9 = var2_2.create(var1_1.x, var1_1.y, var1_1.width, var1_1.height);
        if (var6_6 != null) {
            var9_9.setColor(var6_6);
            var9_9.fillRect(0, 0, var1_1.width, var1_1.height);
        }
        var9_9.setFont(var4_4);
        var9_9.setColor(var5_5);
        var10_10 = var9_9.getFontMetrics(var4_4);
        var11_11 = 0;
        var12_12 = var10_10.getAscent() + var10_10.getLeading();
        var13_13 = var10_10.getHeight();
        var14_14 = new StringTokenizer(var0, "\n");
        var15_15 = var14_14.countTokens();
        var15_15 = var15_15 > 1 ? var15_15 * var13_13 : var13_13;
        switch (var8_8) {
            case 3: {
                var12_12 += var1_1.height - var15_15;
                ** GOTO lbl34
            }
            case 2: {
                var12_12 += (var1_1.height - var15_15) / 2;
                ** GOTO lbl34
            }
            default: {
                if (var14_14.hasMoreTokens()) ** continue;
            }
        }
        while (true) lbl-1000:
        // 2 sources

        {
            var16_16 = var14_14.nextToken();
            switch (var7_7) {
                case 3: {
                    var11_11 = var1_1.width - var10_10.stringWidth(var16_16);
                    break;
                }
                case 2: {
                    var11_11 = (var1_1.width - var10_10.stringWidth(var16_16)) / 2;
                    break;
                }
            }
            var9_9.drawString(var16_16, var11_11, var12_12);
            var12_12 += var13_13;
lbl34:
            // 3 sources

            if (var14_14.hasMoreTokens()) ** GOTO lbl-1000
            break;
        }
        var9_9.dispose();
    }
}

