/*
 * (c) Copyright 1996, KL GROUP INC.
 * ALL RIGHTS RESERVED
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES
 * RELATING TO THE USE OF THIS SOFTWARE.
 */

//   RCSID -- $RCSfile: JCMenu.java $ $Revision: 2.0 $
//            $Date: 1997/06/09 18:22:06 $  $Locker: $  KL Group Inc.

package jclass.contrib;
import java.awt.*;

/**
 * JCMenu is a container for utilities associated with
 * building menus.
 */
public class JCMenu {

/**
 * Creates a menu based on the label information provided by
 * the items parameter. The first string is the title of the
 * menu itself. If the string is prepended with an underscore "_",
 * it is a submenu that is defined later. If the string
 * is of zero length, a separator is added to the menu.<P>
 * Here is an example of how it is used:
 <PRE>
 public String[] fileMI =   {"File", "Open", "Save", "Save As...",
                                 "_Import", "Print...", "", "Exit"};
     public String[] importMI = {"From File", "From URL"};

     Menu mb = new MenuBar();
     Menu fileMenu = JCMenu.create(mb, fileMenuItems);
     Menu importMenu = JCMenu.create(JCMenu.findSubMenu(fileMenu, importMI[0]),
                                     importMI);

	 </PRE>
	 * Note that the technique for creating a submenu involves the
     * findSubMenu() member.
	 *
	 * @param mb the parent Menu or MenuBar
     * @param items[] the array of strings that define the menu item labels
	 * @return          the Menu containing specified menu items
	 */
public static Menu create(MenuContainer mb, String[] items) {
	if (items == null || items.length <= 0) return null;
	Menu r = null;
	if (mb instanceof Menu) {
		r = (Menu)mb;
	}
	else {
		r = new Menu(items[0]);
	}
	for (int i = 1; i < items.length; i++) {
		String s = items[i];
		if (s != null) {
			if (s.length() <= 0) {
				r.addSeparator();
			}
			else if (s.charAt(0) == '_') {
				r.add(new Menu(s.substring(1)));
			}
			else {
				r.add(new MenuItem(s));
			}
		}
	}
	if (mb instanceof MenuBar)
		((MenuBar)mb).add(r);
	return r;
}

/**
 * Returns a submenu with a particular title.
 *
 * @param m the menu that is searched for the specified item
 * @param l the title of the menu of interest
 * @return the menu matching the query, or null if none is found
 */
public static Menu findSubMenu(Menu m, String l) {
	Menu r = null;
	for (int i = 0; i < m.countItems(); i++) {
		if (m.getItem(i) instanceof Menu) {
			Menu temp = (Menu)m.getItem(i);
			if (temp.getLabel().equals(l)) {
				r = temp;
				break;
			}
		}
	}
	return r;
}

}

