/*
****************************************************************************

NAME: splitFile.rex inputFile [numberOfLines]

EXAMPLE USAGE:

* To split a file that has 2345 lines into files that have up to 100 lines
  (the default) do:
  
  rexx splitFile.rex children.lst

* To split a file that has 2345 lines into files that have up to 200 lines
  (the default) do:
  
  rexx splitFile.rex children.lst  200
  
* If you want to simultaneously see the messages in the screen and capture them
  into a file for later viewing, you can invoke the command as follows:

  rexx splitFile.rex children.lst  2>&1 | tee split1.out

      
ENVIRONMENT VARIABLES:
  None
      
DESCRIPTION:
  This sample command logically splits the contents of a file into
  smaller files that have a maximum number of lines of 100 (the default).
  
  It reads all the lines of an input file, and copies
  a given maximum number of lines (the default is 100) into another
  file, whose file name is based on the input file name plus a numberic
  suffix. For example, the first 100 lines will be copied into file
  file.1, the lines 101 to 200 will be copied into file file.2, etc.
  
  The input file is NOT modified at all.
  
****************************************************************************
*
*           NOTICE TO USERS OF THE SOURCE CODE EXAMPLES
*
* INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THE SOURCE CODE
* EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, "AS IS" WITHOUT
* WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
* OF THE SOURCE CODE EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS,
* IS WITH YOU.  SHOULD ANY PART OF THE SOURCE CODE EXAMPLES PROVE
* DEFECTIVE, YOU (AND NOT IBM OR AN AUTHORIZED DEALER) ASSUME THE ENTIRE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
****************************************************************************
*/

/* This block of code gets the name of the command, for later use. */

parse source . . cmdName
cmdName = filespec("name",cmdName)
cmdName = substr(cmdName,1,lastPos('.',cmdName)-1)

/* Parse the command line and display usage, if needed. */

parse arg inputFile numberLines .
if (inputFile = '') then
do
  say 'usage: 'cmdName' inputFile [numberLines]'
  say 'This sample command logically splits the contents of a file into.'
  say 'smaller files that have a maximum number of lines of 100 (the default).'
  say 'It reads all the lines of an input file, and copies'
  say 'a given maximum number of lines (the default is 100) into another'
  say 'file, whose file name is based on the input file name plus a numberic'
  say 'suffix. For example, the first 100 lines will be copied into file'
  say 'file.1, the lines 101 to 200 will be copied into file file.2, etc.'
  say 'The input file is NOT modified at all.'
  exit 1
end

if (numberLines = '') then 
do
   numberLines = 100  /* Setting up the default */   
end

say 'Executing:   ' cmdName
say 'inputFile:   ' inputFile
say 'numberLines: ' numberLines

rc_file =  STREAM( inputFile, C, 'open read' )
if ( rc_file \= "READY:" ) then
do
  say "Error while trying to open input file: " inputFile
  say "the return code from opening the stream is: " rc_file
  say "Exiting due to error."
  exit 1
end

counterLines = 1
counterTotalLines = 1
counterFiles = 1
     
/* Create the first output file */

outputFile=inputFile || '.' || counterFiles
say "Opening outputFile: " outputFile
rc_file =  STREAM( outputFile, C, 'open write' )
if ( rc_file \= "READY:" ) then do
       say "Error while trying to open outputFile: " outputFile
       say "the return code from opening the stream is: " rc_file
       say "Exiting due to error."
       exit 1
end

do until ( lines(inputFile) = 0 )  /* Read until the end of the input file */
  inputLine = LINEIN(inputFile)
  
  if ( counterLines < numberLines ) then do
     counterLines = counterLines + 1
     counterTotalLines = counterTotalLines + 1
     temp = LINEOUT(outputFile, inputLine)
  end 
  else do
     counterLines = 1
     rc = STREAM( outputFile, C, 'close' )  /* closing file */
     counterFiles = counterFiles + 1
     outputFile=inputFile || '.' || counterFiles
     say "Opening outputFile: " outputFile
     rc_file =  STREAM( outputFile, C, 'open write' )   /* opening next file */
     if ( rc_file \= "READY:" ) then do
       say "Error while trying to open outputFile: " outputFile
       say "the return code from opening the stream is: " rc_file
       say "Exiting due to error."
       exit 1
     end
     counterTotalLines = counterTotalLines + 1
     temp = LINEOUT(outputFile, inputLine)
  end 
end

say ""
say "Total number of output files: " counterFiles
say "of " numberLines " lines each, for a total of " counterTotalLines " lines."

rc = STREAM( outputFile, C, 'close' )  /* closing file */

exit 0

/* end of file */
