/*
****************************************************************************

NAME: filterPartsWithChildren.rex releaseName workareaName outputFile

EXAMPLE USAGE:

* To filter all the specified parts that have children:

  rexx filterPartsWithChildren.rex dfarel1 ibm-mig-00 children.lst
  
* If you want to simultaneously see the messages in the screen and capture them
  into a file for later viewing, you can invoke the command as follows:

  rexx filterPartsWithChildren.rex dfarel1 ibm-mig-00 children.lst  2>&1 | tee filter1.out

ENVIRONMENT VARIABLES:
      TC_FAMILY
      TC_BECOME

DESCRIPTION:
  This sample command obtains the list of ALL the part in a given
  release/workarea and filters those parts that have children.
  Then for each have children, the command "tcbv" without recursion (-rec)
  is invoked to found out the first level of children, which are stored
  in raw format in outputFile.

NOTES:
* The auxiliary temporary file "temp1fpc.out" is created by this script.
* You may change as appropriate the query for baseName (or other attributes).
  See the details in the CUSTOMIZATION section in the actual code.

****************************************************************************
*
*           NOTICE TO USERS OF THE SOURCE CODE EXAMPLES
*
* INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THE SOURCE CODE
* EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, "AS IS" WITHOUT
* WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
* OF THE SOURCE CODE EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS,
* IS WITH YOU.  SHOULD ANY PART OF THE SOURCE CODE EXAMPLES PROVE
* DEFECTIVE, YOU (AND NOT IBM OR AN AUTHORIZED DEALER) ASSUME THE ENTIRE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
****************************************************************************
*/

/* This block of code gets the name of the command, for later use. */

parse source . . cmdName
cmdName = filespec("name",cmdName)
cmdName = substr(cmdName,1,lastPos('.',cmdName)-1)

/* Parse the command line and display usage, if needed. */

parse arg releaseName workareaName outputFile .
if (releaseName = '') | (workareaName = '') | (outputFile ='') then
do
  say 'usage: 'cmdName' releaseName workareaName outputFile'
  say 'This sample command obtains the list of ALL the part in a given'
  say 'release/workarea and filters those parts that have children.'
  say 'Then for each have children, the command "tcbv" without recursion (-rec)'
  say 'is invoked to found out the first level of children, which are stored'
  say 'in raw format in outputFile.'
  exit 1
end

say 'Executing:    ' cmdName
say 'releaseName:  ' releaseName
say 'workareaName: ' workareaName
say 'outputFile:   ' outputFile

/* Cleaning up previous versions of the temporary file, if any */

tempFile="temp1fpc.out"
"del " tempFile

/* Issue the query */

say "Issuing the following query, please wait ..."

/**** CUSTOMIZATION: begin **** */
/* You may change as appropriate the query for baseName (or other attributes) */
say "teamc Report -view PartView -release" releaseName "-workarea " workareaName ||,
  " -raw -where """ || ,
  "baseName like '%.lkd' "" > " tempFile
"@teamc Report -view PartView -release" releaseName "-workarea " workareaName ||,
  " -raw -where """ || ,
  "baseName like '%.lkd' "" > " tempFile

/**** CUSTOMIZATION: end **** */

counterTotal = 0
counterSelected = 0
do until ( lines(tempFile) = 0 )  /* Read until the end of the temporary file */
  inputLine = LINEIN(tempFile)
  parse var inputLine baseName '|' releaseName '|' compName '|' committedVersion '|' ,
    addDate '|' dropDate '|' lastUpdate '|' pathName '|' currentVersion '|' ,
    nuAddDate '|' nuDropDate '|' nuPathName '|' userLogin '|' fmode '|' ,
    fileType '|' changeType '|' waName '|' partType '|' temporary '|' ,
    builderName '|' parserName '|' parentName '|' hasChildren '|',
    buildStatus '|' typeOfRelation '|' parameters '|',
    workareAreaChange '|' translation '|' transState '|' restricted .
  counterTotal = counterTotal + 1

  if (hasChildren = 'yes') then
  do
    counterSelected = counterSelected + 1
    say "Finding out the first level children for part ("counterTotal"): " pathName
    say "tcbv """pathName""" -rel " releaseName " -work " workareaName " -type " partType
    "@tcbv """pathName""" -rel " releaseName " -work " workareaName " -type " partType " >> " outputFile
  end

end

say ""
say "Total number of parts in the query:   " counterTotal
say "Total number of parts with children:  " counterSelected

rc = STREAM( tempFile, C, 'close' )

exit 0

/*                                                                   */
/*-------  the end  -------------------------------------------------*/
